/***********************************************************
*                      K O U L E S                         *
*----------------------------------------------------------*
*  C1995 JAHUSOFT                                          *
*        Jan Hubicka                                       *
*        Dukelskych Bojovniku 1944                         *
*        390 03 Tabor                                      *
*        Czech Republic                                    *
*        Telefon: (048-I think) (0361) 32613               *
*        eMail: hubicka@limax.paru.cas.cz                  *
*----------------------------------------------------------*
* Copyright(c)1995 by Jan Hubicka.See README for license   *
*                          details.                        *
*----------------------------------------------------------*
*  koules.h                                                *
***********************************************************/

#ifndef __KOULE_INCLUDED___
#define __KOULE_INCLUDED___
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <math.h>
#include <sys/types.h>
#include <fcntl.h>
#ifndef M_PI			/*hp ansi c stuff */
#define M_PI 3.14
#endif
#ifdef JOYSTICK
#include <linux/joystick.h>
#endif
#if defined(SOUND)||defined(NAS_SOUND)
#include "sound.h"
#endif

/*do not confuse compiler when function is not required */
#if defined(__GNUC__)&&!defined(ONLYANSI)
#define CONST const
#define INLINE inline
extern inline void
dummy ()
{
  return;
}
#define DUMMY dummy();
#else
#define INLINE
#define CONST
static int      dummy;
#define DUMMY (dummy++)
#endif

extern int      nomouse;
#include <interface.h>

#define MENUTIME 5



#define back(x) (32 + x)
#define ball(x) (64 + x)
#define rocket(x) (96 + x)


#define PLAY_X1 0
#define PLAY_Y1 0




#define RAD(n)  ((float)(n)/180.0*M_PI)
#define ROTSTEP RAD(20)


#define BALL_RADIUS 8
#define BBALL_RADIUS 16
#define APPLE_RADIUS 32
#define INSPECTOR_RADIUS 14
#define HOLE_RADIUS 12
#define ROCKET_RADIUS 14
#define EYE_RADIUS1 10
#define SPRINGSIZE (4*BBALL_RADIUS)
#define SPRINGSTRENGTH (BBALL_RADIUS/2)



#define NTRACKS 4
#define NTRACKS 4
#define ROCKET 1
#define BALL 2


#define LBALL 3
#define CREATOR 4
#define HOLE 5
#define BBALL 6
#define APPLE 7
#define INSPECTOR 8
#define EHOLE 9


#define MAXOBJECT 500
#define MAXPOINT (4000)
#define MAXROCKETS 5


#define L_ACCEL 'A'
#define L_SPEED 'S'
#define L_GUMM 'M'
#define A_ADD 0.13
#define M_ADD 0.8


#define LETTER 1024


#define S_START 0
#define S_END 1
#define S_COLIZE 2
#define S_DESTROY_BALL 3
#define S_DESTROY_ROCKET 4
#define S_CREATOR1 5
#define S_CREATOR2 6

#define DEATHMATCH 0
#define COOPERATIVE 1


#define NSAMPLES 7

#define MENU 1
#define KEYS 2
#define GAME 3
#define JOY 4


#define next /*((++cit)>=NTRACKS?cit=1:cit)*/


typedef struct
  {
    int             type;
    int             ctype;
    int             live;
    int             time;
    int             score;
    int             lineto;
    float           x;
    float           y;
    float           fx;		/*forces */
    float           fy;
    float           rotation;	/*for rockets */
    int             live1;	/*backup for rockets */
    float           M;
    int             radius;
    float           accel;
    char            letter;
  }
Object;
typedef struct
  {
    int             x, y, xp, yp, time, color;
  }
Point;

typedef struct
  {
    char           *text;
    void            (*func) ();
  }
Menu;

#ifdef SOUND
# define Effect(p1,p2) (sound?play_sound(p1):0)
#else
# ifdef NAS_SOUND
#  define Effect(p1,p2) (sound?play_sound(p1):0)
#  define SOUND
# else
#  define Effect(p1,p2) DUMMY
# endif
#endif

#ifndef VARIABLES_HERE
extern float    ROCKET_SPEED;
extern float    BALL_SPEED;
extern float    BBALL_SPEED;
extern float    SLOWDOWN;
extern float    GUMM;

extern float    BALLM;
extern float    LBALLM;
extern float    BBALLM;
extern float    APPLEM;
extern float    INSPECTORM;
extern float    ROCKETM;


extern int      dosprings;
extern int      randsprings;
extern int      nobjects;
extern int      drawpointer;
extern int      textcolor;
extern int      nrockets;
extern Object   object[MAXOBJECT];
extern Point    point[MAXPOINT];
extern int      gameplan;
extern int      rotation[MAXROCKETS];
#ifdef SOUND
extern int      sndinit;
#endif

extern int      mouseplayer;
#ifdef JOYSTICK
extern int      joystickplayer[2];
extern int      joystickdevice[2];
extern int      calibrated[2];
extern int      center[2][2];
#endif


extern VScreenType physicalscreen;
extern VScreenType backscreen;
extern VScreenType background;
extern VScreenType starbackground;
/*extern int      cit;*/
extern int      gamemode;
extern int      nmenu;
extern int      tbreak;
extern Menu     menu[20];

extern int      a_bballs, a_rockets, a_balls, a_holes, a_apples, a_inspectors,
                a_eholes;

extern int      keys[5][4];
extern int      sound;

extern BitmapType bball_bitmap, apple_bitmap, inspector_bitmap, mouse_bitmap,
                lball_bitmap[2], circle_bitmap, hole_bitmap, ehole_bitmap,
                ball_bitmap, eye_bitmap[MAXROCKETS], rocket_bitmap[MAXROCKETS];
extern char     rocketcolor[5];


#endif

#if defined(__GNUC__)&&!defined(ONLYANSI)
extern inline void
normalize (float *x, float *y, CONST float size)
{
  float           length = sqrt ((*x) * (*x) + (*y) * (*y));
  if (length == 0)
    length = 1;
  *x *= size / length;
  *y *= size / length;
}
#else
extern void     normalize (float *, float *, CONST float);
#endif

extern void     addpoint (CONST int, CONST int, CONST int, CONST int, CONST int, CONST int);
extern void     destroy (CONST int);
extern void     creator (CONST int);
extern void     creator_rocket (CONST int);
extern void     uninitialize ();
extern void     draw_menu (CONST int);
extern void     draw_joy (CONST int);
extern void     init_menu ();
extern void     menu_keys ();

extern void     draw_keys (int);
extern void     keys_keys ();
extern void     joy_keys ();
extern void     gameplan_init ();

extern void     update_game ();
extern void     init_objects ();
extern void     outro1 ();
extern void     outro2 ();
extern void     clearpoints ();
extern void     intro_intro ();
extern void     spring_intro ();
extern void     hole_intro ();
extern void     inspector_intro ();
extern void     bball_intro ();
extern void     bbball_intro ();
extern void     maghole_intro ();
extern void     fadeout ();
extern void     fadein ();
#if defined(__GNUC__)&&!defined(ONLYANSI)
extern int
find_possition (float *, float *, CONST float)
                __attribute ((const));
     extern int      radius (CONST int) __attribute ((const));
     extern float    M (CONST int) __attribute ((const));
     extern int      create_letter () __attribute ((const));
#else
extern int      find_possition (float *, float *, CONST float);
extern int      radius (CONST int);
extern float    M (CONST int);
extern int      create_letter ();
#endif

#endif
