/***********************************************************
*                      K O U L E S                         *
*----------------------------------------------------------*
*  C1995 JAHUSOFT                                          *
*        Jan Hubicka                                       *
*        Dukelskych bojovniku 1944                         *
*        390 03 Tabor                                      *
*        Czech Republic                                    *
*        Telefon: (048-I think) (0361) 32613               *
*        eMail: hubicka@limax.paru.cas.cz                  *
*----------------------------------------------------------*
* Copyright(c)1995 by Jan Hubicka.See README for license   *
*                          details.                        *
*----------------------------------------------------------*
*  gameplan.c scores,levels......                          *
***********************************************************/

#include "koules.h"
#define BBALLLEVEL (nrockets==1?12:10)
#define HOLELEVEL 5
#define EHOLELEVEL 25
#define SPRINGLEVEL 50
#define INSPECTORLEVEL 75
#define BBBALLLEVEL 90
static int      level = 0;
static int      time;
static int      nos;
static int      ktime = 0;
static int      kmode = 0;
void
gameplan_init ()
{
#ifdef DEBUG
  level = 98;
#else
  level = 0;
#endif
}

/* 
 * level creation routines
 */
void
init_objects ()
{
  char            s[20];
  int             i;
  dosprings = 0;
  if (gamemode != GAME)
    {
      nobjects = 0;
      return;
    }
  clearpoints ();
#ifdef SOUND
  if (!nos)
    Effect (S_START, 0);
#endif
  switch (gameplan)
    {
    case DEATHMATCH:
      nobjects = nrockets * 4;
      for (i = 0; i < nobjects; i++)
	object[i].live = 0;
      for (i = 0; i < nobjects; i++)
	{
	  object[i].live = 1;
	  object[i].lineto = -1;
	  object[i].live1 = 1;
	  object[i].time = (i < nrockets ? 99 : 0);
	  object[i].fx = 0;
	  object[i].fy = 0;
	  object[i].rotation = 0;
	  object[i].type = (i < nrockets ? ROCKET : BALL);
	  if (!find_possition (&object[i].x, &object[i].y, radius (object[i].type)))
	    return;
	  object[i].M = M (object[i].type);
	  object[i].radius = radius (object[i].type);
	  object[i].accel = ROCKET_SPEED;
	  object[i].letter = ' ';
	}
      break;
    case COOPERATIVE:
      if (level != 99)
	{
	  int             nbballs;
	  if(level>SPRINGLEVEL)
	    dosprings = 1;
	  randsprings = 40 - level / 3;
	  nobjects = 3 + sqrt (level) * ((nrockets + 1) / 2) + 2 * nrockets;
	  if (nobjects > 30)
	    nobjects = 30;
	  for (i = 0; i < nobjects; i++)
	    object[i].live = 0;
	  nbballs = nrockets + level / BBBALLLEVEL;
	  time = 100 + 1000 / (level + 1);
	  for (i = 0; i < nobjects; i++)
	    {
	      object[i].live = (i < nrockets ? 5 : 1);
	      object[i].live1 = (i < nrockets ? 5 : 1);
	      object[i].lineto = -1;
	      object[i].time = (i < nrockets ? 100 : 0);
	      object[i].fx = 0;
	      object[i].fy = 0;
	      object[i].rotation = 0;
	      object[i].type = (i < nrockets ? ROCKET : (i < nbballs ? BBALL : BALL));
	      object[i].M = M (object[i].type);
	      if (i < nrockets)
		{
		  if (level < 5)
		    object[i].M *= 1.0 + (5.0 - level) / 15.0;
		  if (level < 25)
		    object[i].M *= 1.0 + (level) / 120.0;
		}
	      object[i].radius = radius (object[i].type);
	      object[i].accel = ROCKET_SPEED;
	      if (!find_possition (&object[i].x, &object[i].y, radius (object[i].type)))
		return;
	      object[i].letter = ' ';
	    }
	  gamemode = MENU;
#ifndef DEBUG
	  if (!nos && level == 0)
#endif
	    intro_intro ();
#ifndef DEBUG
	  if (!nos && level == HOLELEVEL + 1)
#endif
	    hole_intro ();
#ifndef DEBUG
	  if (!nos && level == INSPECTORLEVEL)
#endif
	    inspector_intro ();
#ifndef DEBUG
	  if (!nos && level == BBALLLEVEL + 1)
#endif
	    bball_intro ();
#ifndef DEBUG
	  if (!nos && level == BBBALLLEVEL)
#endif
	    bbball_intro ();
#ifndef DEBUG
	  if (!nos && level == EHOLELEVEL)
#endif
	    maghole_intro ();
#ifndef DEBUG
	  if (!nos && level == SPRINGLEVEL)
#endif
	    spring_intro ();
	  gamemode = GAME;
	}
      else
	{
	  nobjects = nrockets + 10;
	  for (i = 0; i < nobjects; i++)
	    object[i].live = 0;
	  object[nrockets].type = APPLE;
	  object[nrockets].M = APPLEM;
	  object[nrockets].lineto = -1;
	  object[nrockets].radius = APPLE_RADIUS;
	  object[nrockets].live = (i < nrockets ? 5 : 1);
	  object[nrockets].fx = 0;
	  object[nrockets].fy = 0;
	  object[nrockets].x = GAMEWIDTH / 2;
	  object[nrockets].y = GAMEHEIGHT / 2;
	  for (i = 0; i < nrockets; i++)
	    {
	      object[i].live = 5;
	      object[i].live1 = 5;
	      object[i].time = 100;
	      object[i].lineto = -1;
	      object[i].fx = 0;
	      object[i].fy = 0;
	      object[i].rotation = 0;
	      object[i].type = ROCKET;
	      object[i].accel = ROCKET_SPEED;
	      object[i].M = M (object[i].type);
	      object[i].radius = radius (object[i].type);
	      object[i].letter = ' ';
	      object[i].x = GAMEWIDTH / 2 + sin (i * RAD (360) / nrockets) * GAMEHEIGHT / 3;
	      object[i].x = GAMEHEIGHT / 2 + cos (i * RAD (360) / nrockets) * GAMEHEIGHT / 3;
	    }
	  for (i = nrockets + 1; i < nobjects; i++)
	    {
	      object[i].live = 1;
	      object[i].live1 = 1;
	      object[i].lineto = -1;
	      object[i].time = 0;
	      object[i].fx = 0;
	      object[i].fy = 0;
	      object[i].rotation = 0;
	      object[i].type = BALL;
	      object[i].accel = BALL_SPEED;
	      object[i].M = M (object[i].type);
	      object[i].radius = radius (object[i].type);
	      object[i].letter = ' ';
	      if (!find_possition (&object[i].x, &object[i].y, radius (object[i].type)))
		return;
	    }
	  if (!nos)
	    outro1 ();
	}
      SetScreen (physicalscreen);
      ClearScreen ();
      tbreak = 1;
      sprintf (s, "SECTOR %i", level + 1);
#ifdef XSUPPORT
      DrawWhiteMaskedText (MAPWIDTH / 2 - 32, MAPHEIGHT / 2 - 4, s);
#else
      DrawText (MAPWIDTH / 2 - 32, MAPHEIGHT / 2 - 4, s);
#endif
      fadein ();
#ifdef XSUPPORT
      XFlush (dp);
#endif
      usleep (1000000);
    }

}

int
create_letter ()
{
  int             i;
  i = rand () % 4;
  if (i < 3)
    return (i);
  return (0);
}
void
update_game ()
{
  int             i;
  if (gamemode == GAME)
    {
      if (ktime)
	{
	  ktime--;
	  if (ktime == 0)
	    switch (kmode)
	      {
	      case 1:
		Effect (S_END, 0);
		init_objects ();
		break;
	      case 2:
		level = 1, gamemode = MENU,
		  outro2 ();
		break;
	      case 3:
		for (i = 0; i < nrockets; i++)
		  if (object[i].type == ROCKET && object[i].live)
		    object[i].score += object[i].live * 20;
		level++, init_objects ();
		break;
	      case 4:
		Effect (S_END,0);
		for (i = 0; i < nrockets; i++)
		  if (object[i].type == ROCKET)
		    object[i].score -= 100;
		nos = 1;
		init_objects ();
		nos = 0;
		break;
	      }
	}
      else
	switch (gameplan)
	  {


	  case DEATHMATCH:
	    if (a_balls == 0)
	      {
		if (!(rand () % 60))
		  creator (HOLE);
	      }
	    if (a_rockets <= 1)
	      {
		ktime = 50;
		kmode = 1;
	      }
	    break;



	  case COOPERATIVE:
	    if (level == 99)
	      {
		if (!a_apples)
		  ktime = 50, kmode = 2;
		if (a_balls < 15)
		  if (!(rand () % 40))
		    creator (BALL);
		if (a_bballs < 3)
		  if (!(rand () % 3000))
		    creator (BBALL);
	      }
	    else
	      {
		time--;
		if (a_balls == 0 && a_bballs == 0 && a_inspectors == 0)
		  {
		    ktime = 50, kmode = 3;
		  }
		if (a_balls < 4 * level && time < 0)
		  if (!(rand () % ((nrockets == 1 ? 200 : 150) + (110 - level))))
		    creator (BALL);

		if (a_holes < 4 * (level - HOLELEVEL) && time < 0)
		  if (!(rand () % (412 + 512 / level)))
		    creator (HOLE);

		if (a_bballs < 4 * (level - BBALLLEVEL) && time < 0)
		  if (!(rand () % ((nrockets == 1 ? 700 : 500) + 1 * (110 - level) / 3 + 2024 / level)))
		    creator (BBALL);
		if (a_inspectors < level / (INSPECTORLEVEL) && time < 0)
		  if (!(rand () % (1500 + 10 * (110 - level))))
		    creator (INSPECTOR);
		if (a_eholes < level / EHOLELEVEL + 1 && time < 0 && level >= EHOLELEVEL)
		  if (!(rand () % (500 + 1000 / level)))
		    creator (EHOLE);
	      }
	    if (a_rockets == 0)
	      {
		ktime = 50;
		kmode = 4;
	      }
	  }
    }
  else
    {
      if (a_balls < 5 && !(rand () % (50)))
	creator (BALL);
      if (a_bballs < 4 && !(rand () % (200)))
	creator (BBALL);
    }
}
