/*
 * Imperium
 *
 * Copyright (C) 1990-93 by David Wright
 *
 * $Id: ImpCtrl.h,v 3.4.1.1 1993/11/19 06:26:12 davewt Exp $
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 1, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Definitions used by the ImpControl() interface
 *
 * $Log: ImpCtrl.h,v $
 * Revision 3.4.1.1  1993/11/19  06:26:12  davewt
 * patch3: New base revision.
 *
 * Revision 3.4  1993/10/16  05:04:23  davewt
 * New revision.
 *
 * Revision 3.2  1993/10/07  02:10:11  davewt
 * New branch release.
 *
 * Revision 3.1.1.1  1993/09/07  01:56:07  davewt
 * patch1: First patch to initial version.
 *
 * Revision 1.1  1993/08/23  23:19:06  davewt
 * Initial revision
 *
 * 
 */

/*
 * Actions that can be performed through the ImpControl() entry point in
 * the library. These get placed in is_argShort.
 */

#define IC_RESET    0   /* reset to defaults            */
#define IC_FPOWER   1   /* force power update           */
#define IC_POWER    2   /* display-only power update    */
#define IC_UPDATE   3   /* do global planet update      */
#define IC_MINER    4   /* do global miner update       */
#define IC_BACKS    5   /* start a backup               */
#define IC_BACKE    6   /* complete a backup            */
#define IC_INCUSR   7   /* incremensts the user count   */
#define IC_DECUSR   8   /* decrements the user count    */
#define IC_DOFLUSH  9   /* flush the server's buffers   */

/*
 * Additional notes:
 *
 *  1) If is_argBool is TRUE then actions will be logged. If FALSE, no
 *     actions will be logged.
 *
 */

