/*
 * Imperium
 *
 * Copyright (C) 1990-91 by David Wright
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 1, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * definitions private to the Imperium library.
 *
 * $Id: ImpFeMess.h,v 3.4.1.1 1993/11/19 06:22:26 davewt Exp $
 *
 * $Log: ImpFeMess.h,v $
 * Revision 3.4.1.1  1993/11/19  06:22:26  davewt
 * patch3: New base revision.
 *
 * Revision 3.4  1993/10/16  05:01:23  davewt
 * New revision.
 *
 * Revision 3.3  1993/10/16  04:33:08  davewt
 * New  release.
 *
 * Revision 3.2  1993/10/07  02:06:19  davewt
 * New branch release.
 *
 * Revision 3.1.1.1  1993/09/07  01:51:52  davewt
 * patch1: First patch to initial version.
 *
 * Revision 1.1  1993/08/25  02:06:47  davewt
 * Initial revision
 *
 * Revision 1.5  1993/02/06  01:19:43  DaveWT
 * Changes to codes
 *
 * Revision 1.4  1993/02/06  00:52:41  DaveWT
 * Support for input commands to the FE
 *
 * Revision 1.3  1992/08/20  22:52:47  DaveWT
 * Added FE_PRINTREALM.
 *
 * Revision 1.2  1992/07/29  22:45:50  DaveWT
 * Added comments, and the new #define's for use with the feMode field.
 *
 * Revision 1.1  1991/09/21  23:11:23  DaveWT
 * Initial revision
 *
 *
 */

/*
 * Things for the FE support messages
 */


/*
 *          Messages that Imperium may send
 */

#define FE_COMMENT  "!<"        /* Introduces all comments      */

#define FE_PLDUMP   "!@D"       /* Introduces a planet dump     */
#define FE_PLDIRTY  "!@U"       /* Introduces a "dirty" planet #*/
#define FE_PLGEO    "!@1\n"     /* A planet geo report follows  */
#define FE_PLPOP    "!@2\n"     /* A planet population rept foll*/
#define FE_PLITE    "!@3\n"
#define FE_PLBIG    "!@4\n"     /* A planet big item rept follw */
#define FE_PLPRO    "!@5\n"     /* A planet production rept. fl */

#define FE_SHDUMP   "!$D"       /* Introduces a ship dump line  */
#define FE_SHDIRTY  "!$U"       /* Introduces a "dirty" ship #  */
#define FE_SHSTAT   "!$1\n"     /* A ship status rept follows   */
#define FE_SHCARGO  "!$2\n"     /* A ship cargo rept follows    */
#define FE_SHBIG    "!$3\n"     /* A ship big item rpt follows  */

#define FE_SRS      "!)S\n"
#define FE_LRS      "!)R\n"
#define FE_VRS      "!)V\n"

#define FE_CHREQ    "!*C\n"
#define FE_PLAYLIST "!*L\n"     /* A player list follows            */
#define FE_POWREP   "!*\x50\n"     /* A power report follows           */
#define FE_RACEREP  "!*R\n"     /* A race report follows            */
#define FE_PLAYSTAT "!*S\n"     /* A player status command follows  */
#define FE_PRINTREALM "!*A\n"   /* A realm line follows             */

#define FE_ATTLOSE  "!&L\n"     /* The last attack failed           */
#define FE_ATTWIN   "!&W\n"     /* The last attack succeeded        */

#define FE_DISP_PROMPT "!("     /* The prompt (if any) follows      */
                                /* the "!(" sequence (until EOL)    */
#define FE_GET_LINE "![\n"      /* The FE should get a line from the*/
                                /* user.                            */
#define FE_GET_CANC "!]\n"      /* The previous line requenst has   */
                                /* been canceled                    */

/*
 *      Bit-values for items the FE wants to see
 */

#define FE_WANT_COMM    0x0001  /* The player wants comments    */
#define FE_WANT_PLAN    0x0002  /* The player wants planet info */
#define FE_WANT_SHIP    0x0004  /* The player wants ship info   */
#define FE_WANT_MISC    0x0008  /* The player wants misc. info  */
#define FE_WANT_SCAN    0x0010  /* The player wants scanner info */
#define FE_WANT_ATTK    0x0020  /* The player wants attack info */

/*
 *      Bit-values for things the FE supports
 */

#define FE_HAS_GRAPH    0x0100
#define FE_HAS_SOUND    0x0200
#define FE_HAS_MOUSE    0x0400
#define FE_HAS_JOYST    0x0800
#define FE_HAS_2COLR    0x1000
#define FE_HAS_4COLR    0x2000
#define FE_HAS_PROMPT   0x4000  /* The FE supports "prompt" mode    */
