/*
 * ------------------------------------------------------------------
 * Space.cc - Code for Spaces
 * Created by Robert Heller on Sat Jun 17 23:44:46 1995
 * ------------------------------------------------------------------
 * Modification History: $Log: Space.cc,v $
// Revision 1.3  1995/06/27  12:31:55  heller
// Fix doorway PS code and adjust pos of up/down exit.
//
// Revision 1.2  1995/06/18  07:10:59  heller
// Fix HandlizePointers() to avoid references to static functions defined in
// other files
//
// Revision 1.1  1995/06/18  03:50:31  heller
// Initial revision
//
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 *  
 *     Role Playing Database -- a program for maintaining a database
 *                              for RPG characters and monsters
 *     Copyright (C) 1995  Robert Heller D/B/A Deepwoods Software
 * 			51 Locke Hill Road
 * 			Wendell, MA 01379-9728
 * 
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *  
 */

static char rcsid[] = "$Id: Space.cc,v 1.3 1995/06/27 12:31:55 heller Exp $";

#include <iostream.h>
#include <fstream.h>
#include <pfstream.h>
#include <strstream.h>
#include <Master.h>
#include <Monster.h>
#include <Character.h>
#include <tclExtend.h>
#include <tk.h>
#include <tkX.h>
#include <stdlib.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

ostream& operator << (ostream& os, Space& sp)
{
	os << sp.Name.length() << " " << sp.Name << " ";
	os << sp.Type.length() << " " << sp.Type << " ";
	os << sp.Description.length() << " " << sp.Description << " ";
	os << sp.BackgroundColor.length() << " " << sp.BackgroundColor << " ";
	os << "{";
	for (MonsterList *m = sp.Monsters;m != NULL;m = m->NextMonster)
	{
		os << *m;
		if (m->NextMonster != NULL) os << " ";
	}
	os << "} {";
	for (DressingList *d = sp.Dressings;d != NULL;d = d->NextDressing)
	{
		os << *d;
		if (d->NextDressing != NULL) os << " ";
	}
	os << "} {";
	for (TreasureList *t = sp.Treasures;t != NULL;t = t->NextTreasure)
	{
		os << *t;
		if (t->NextTreasure != NULL) os << " ";
	}
	os << "} {";
	for (TrickList *tr = sp.Tricks;tr != NULL;tr = tr->NextTrick)
	{
		os << *tr;
		os << " ";
	}
	os << "} ";
	os << sp.Exit(Space::North) << " ";
	os << sp.Exit(Space::NorthEast) << " ";
	os << sp.Exit(Space::East) << " ";
	os << sp.Exit(Space::SouthEast) << " ";
	os << sp.Exit(Space::South) << " ";
	os << sp.Exit(Space::SouthWest) << " ";
	os << sp.Exit(Space::West) << " ";
	os << sp.Exit(Space::NorthWest) << " ";
	os << sp.Exit(Space::Up) << " ";
	os << sp.Exit(Space::Down);
}

istream& operator >> (istream& is, Space& sp)
{
	int l;
	is >> l;
	is.get();
	sp.Name = "";
	while (l > 0)
	{
		sp.Name += is.get();
		l--;
	}
	is >> l;
	is.get();
	sp.Type = "";
	while (l > 0)
	{
		sp.Type += is.get();
		l--;
	}
	is >> l;
	is.get();
	sp.Description = "";
	while (l > 0)
	{
		sp.Description += is.get();
		l--;
	}
	is >> l;
	is.get();
	sp.BackgroundColor = "";
	while (l > 0)
	{
		sp.BackgroundColor += is.get();
		l--;
	}
	char ch;
	do {
		ch = is.get();
	} while (ch != '{');
	{
		MonsterList *l,**slot;
		sp.Monsters = NULL;
		slot = &sp.Monsters;
		while (is.peek() != '}')
		{
			l = new MonsterList;
			is >> *l;
			*slot = l;
			slot = &l->NextMonster;
		}
	}
	is.get();
	do {
		ch = is.get();
	} while (ch != '{');
	{
		DressingList *l,**slot;
		sp.Dressings = NULL;
		slot = &sp.Dressings;
		while (is.peek() != '}')
		{
			l = new DressingList;
			is >> *l;
			*slot = l;
			slot = &l->NextDressing;
		}
	}
	is.get();
	do {
		ch = is.get();
	} while (ch != '{');
	{
		TreasureList *l,**slot;
		sp.Treasures = NULL;
		slot = &sp.Treasures;
		while (is.peek() != '}')
		{
			l = new TreasureList;
			is >> *l;
			*slot = l;
			slot = &l->NextTreasure;
		}
	}
	is.get();
	do {
		ch = is.get();
	} while (ch != '{');
	{
		TrickList *l,**slot;
		sp.Tricks = NULL;
		slot = &sp.Tricks;
		while (is.peek() != '}')
		{
			l = new TrickList;
			is >> *l;
			*slot = l;
			slot = &l->NextTrick;
		}
	}
	is.get();
	ExitType et;
	is >> et; sp.SetExit(Space::North,et);
	is >> et; sp.SetExit(Space::NorthEast,et);
	is >> et; sp.SetExit(Space::East,et);
	is >> et; sp.SetExit(Space::SouthEast,et);
	is >> et; sp.SetExit(Space::South,et);
	is >> et; sp.SetExit(Space::SouthWest,et);
	is >> et; sp.SetExit(Space::West,et);
	is >> et; sp.SetExit(Space::NorthWest,et);
	is >> et; sp.SetExit(Space::Up,et);
	is >> et; sp.SetExit(Space::Down,et);
}

void_pt Space::Handles = NULL;

int Space::TclFunction(Tcl_Interp *interp, int argc, char *argv[])
{
	if (argc == 1)
	{
		// no option, echo slots
		Tcl_DString result;
		Tcl_DStringInit(&result);
		Tcl_DStringAppendElement(&result,"Space");

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Name");
		Tcl_DStringAppendElement(&result,(char*)Name);
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Type");
		Tcl_DStringAppendElement(&result,(char*)Type);
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Description");
		Tcl_DStringAppendElement(&result,(char*)Description);
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"BackgroundColor");
		Tcl_DStringAppendElement(&result,(char*)BackgroundColor);
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Monsters");
		if (Monsters == NULL)
		{
			Tcl_DStringAppendElement(&result,"");
		} else
		{
			char temp[32];
			if (PointerToHandle(interp,MonsterList::Handles,
			    Monsters,temp) != TCL_OK)
				return TCL_ERROR;
			Tcl_DStringAppendElement(&result,temp);
		}
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Dressings");
		if (Dressings == NULL)
		{
			Tcl_DStringAppendElement(&result,"");
		} else
		{
			char temp[32];
			if (PointerToHandle(interp,DressingList::Handles,
			    Dressings,temp) != TCL_OK)
				return TCL_ERROR;
			Tcl_DStringAppendElement(&result,temp);
		}
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Treasures");
		if (Treasures == NULL)
		{
			Tcl_DStringAppendElement(&result,"");
		} else
		{
			char temp[32];
			if (PointerToHandle(interp,TreasureList::Handles,
			    Treasures,temp) != TCL_OK)
				return TCL_ERROR;
			Tcl_DStringAppendElement(&result,temp);
		}
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Tricks");
		if (Tricks == NULL)
		{
			Tcl_DStringAppendElement(&result,"");
		} else
		{
			char temp[32];
			if (PointerToHandle(interp,TrickList::Handles,
			    Tricks,temp) != TCL_OK)
				return TCL_ERROR;
			Tcl_DStringAppendElement(&result,temp);
		}
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"North");
		Tcl_DStringAppendElement(&result,(char*)north);
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"NorthEast");
		Tcl_DStringAppendElement(&result,(char*)northeast);
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"East");
		Tcl_DStringAppendElement(&result,(char*)east);
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"SouthEast");
		Tcl_DStringAppendElement(&result,(char*)southeast);
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"South");
		Tcl_DStringAppendElement(&result,(char*)south);
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"SouthWest");
		Tcl_DStringAppendElement(&result,(char*)southwest);
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"West");
		Tcl_DStringAppendElement(&result,(char*)west);
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"NorthWest");
		Tcl_DStringAppendElement(&result,(char*)northwest);
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Up");
		Tcl_DStringAppendElement(&result,(char*)up);
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Down");
		Tcl_DStringAppendElement(&result,(char*)down);
		Tcl_DStringEndSublist(&result);

		Tcl_DStringResult(interp,&result);
		return TCL_OK;
	}
	if (strcmp(argv[1], "type") == 0)
	{
		if (argc != 2)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],(char *) NULL);
			return TCL_ERROR;
		}
		Tcl_AppendResult(interp, "Space", (char *) NULL);
		return TCL_OK;
	} else if (strcmp(argv[1], "name") == 0)
	{
		if (argc == 2)
		{
			Tcl_AppendResult(interp,(char*)Name,(char *) NULL);
			return TCL_OK;
		} else if (argc == 3)
		{
			Name = argv[2];
			Tcl_AppendResult(interp,(char*)Name,(char *) NULL);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "spacetype") == 0)
	{
		if (argc == 2)
		{
			Tcl_AppendResult(interp,(char*)Type,(char *) NULL);
			return TCL_OK;
		} else if (argc == 3)
		{
			Type = argv[2];
			Tcl_AppendResult(interp,(char*)Type,(char *) NULL);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "description") == 0)
	{
		if (argc == 2)
		{
			Tcl_AppendResult(interp,(char*)Description,(char *) NULL);
			return TCL_OK;
		} else if (argc == 3)
		{
			Description = argv[2];
			Tcl_AppendResult(interp,(char*)Description,(char *) NULL);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "backgroundcolor") == 0)
	{
		if (argc == 2)
		{
			Tcl_AppendResult(interp,(char*)BackgroundColor,(char *) NULL);
			return TCL_OK;
		} else if (argc == 3)
		{
			BackgroundColor = argv[2];
			Tcl_AppendResult(interp,(char*)BackgroundColor,(char *) NULL);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "monsters") == 0)
	{
		if (argc > 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		} else if (argc == 3)
		{
			MonsterList* nx;
			if (argv[2][0] != '\0')
			{
				void_pt ptr = Tcl_HandleXlate(interp,
					MonsterList::Handles,argv[2]);
				if (ptr == NULL) return TCL_ERROR;
				nx = *((MonsterList**) ptr);
			} else nx = NULL;
			Monsters = nx;
		}
		if (Monsters == NULL)
		{
			interp->result = "";
			return TCL_OK;
		}
		char temp[32];
		if (PointerToHandle(interp,MonsterList::Handles,Monsters,
				    temp) != TCL_OK)
			return TCL_ERROR;
		Tcl_AppendResult(interp,temp,(char *) NULL);
		return TCL_OK;
	} else if (strcmp(argv[1], "dressings") == 0)
	{
		if (argc > 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		} else if (argc == 3)
		{
			DressingList* nx;
			if (argv[2][0] != '\0')
			{
				void_pt ptr = Tcl_HandleXlate(interp,
					DressingList::Handles,argv[2]);
				if (ptr == NULL) return TCL_ERROR;
				nx = *((DressingList**) ptr);
			} else nx = NULL;
			Dressings = nx;
		}
		if (Dressings == NULL)
		{
			interp->result = "";
			return TCL_OK;
		}
		char temp[32];
		if (PointerToHandle(interp,DressingList::Handles,Dressings,
				    temp) != TCL_OK)
			return TCL_ERROR;
		Tcl_AppendResult(interp,temp,(char *) NULL);
		return TCL_OK;
	} else if (strcmp(argv[1], "treasures") == 0)
	{
		if (argc > 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		} else if (argc == 3)
		{
			TreasureList* nx;
			if (argv[2][0] != '\0')
			{
				void_pt ptr = Tcl_HandleXlate(interp,
					TreasureList::Handles,argv[2]);
				if (ptr == NULL) return TCL_ERROR;
				nx = *((TreasureList**) ptr);
			} else nx = NULL;
			Treasures = nx;
		}
		if (Treasures == NULL)
		{
			interp->result = "";
			return TCL_OK;
		}
		char temp[32];
		if (PointerToHandle(interp,TreasureList::Handles,Treasures,
				    temp) != TCL_OK)
			return TCL_ERROR;
		Tcl_AppendResult(interp,temp,(char *) NULL);
		return TCL_OK;
	} else if (strcmp(argv[1], "tricks") == 0)
	{
		if (argc > 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		} else if (argc == 3)
		{
			TrickList* nx;
			if (argv[2][0] != '\0')
			{
				void_pt ptr = Tcl_HandleXlate(interp,
					TrickList::Handles,argv[2]);
				if (ptr == NULL) return TCL_ERROR;
				nx = *((TrickList**) ptr);
			} else nx = NULL;
			Tricks = nx;
		}
		if (Tricks == NULL)
		{
			interp->result = "";
			return TCL_OK;
		}
		char temp[32];
		if (PointerToHandle(interp,TrickList::Handles,Tricks,
				    temp) != TCL_OK)
			return TCL_ERROR;
		Tcl_AppendResult(interp,temp,(char *) NULL);
		return TCL_OK;
	} else if (strcmp(argv[1], "exit") == 0)
	{
		if (argc < 3 || argc > 4)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," direction ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		Direction d;
		String dir = argv[2];
		if (dir == "north") d = North;
		else if (dir == "northeast") d = NorthEast;
		else if (dir == "east") d = East;
		else if (dir == "southeast") d = SouthEast;
		else if (dir == "south") d = South;
		else if (dir == "southwest") d = SouthWest;
		else if (dir == "west") d = West;
		else if (dir == "northwest") d = NorthWest;
		else if (dir == "up") d = Up;
		else if (dir == "down") d = Down;
		else
		{
			Tcl_AppendResult(interp, "Bad direction word: ",
					 argv[2]," Should be one of {north ",
					 "northeast east southeast south ",
					 "southwest west northwest up down}",
					 (char *) NULL);
				return TCL_ERROR;
		}
		if (argc == 4)
		{
			ExitType et = ExitType(argv[3]);
			if (!et)
			{
				Tcl_AppendResult(interp, "Bad exittype word: ",
						 argv[3]," Should be one of ",
						 "{Door Doorway DoorSecret ",
						 "DoorLocked DoorOneWay ",
						 "StairsUp StairsDown RampUp ",
						 "RampDown None}",(char *) NULL);
					return TCL_ERROR;
			}
			SetExit(d,et);
		}
		Tcl_AppendResult(interp, (char*) Exit(d), (char *) NULL);
		return TCL_OK;
	} else if (strcmp(argv[1], "delete") == 0)
	{
		if (argc != 2)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],"\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		void_pt header = Tcl_HandleXlate (interp,Space::Handles,argv[0]);
		if (header == NULL) return TCL_ERROR;
		Tcl_HandleFree (Space::Handles,header);
		return Tcl_DeleteCommand(interp,argv[0]);
	} else
	{
		Tcl_AppendResult(interp, "Bad option: ",argv[1],(char *) NULL);
		return TCL_ERROR;
	}
}

static void deleteSpace(ClientData clientData)
{
	register Space *cl = (Space*) clientData;
	delete cl;
}

static int spaceCommand(ClientData clientData, Tcl_Interp *interp,
				int argc, char *argv[])
{
	register Space *cl = (Space*) clientData;
	return cl->TclFunction(interp,argc,argv);
}

static int spaceCreate(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[])
{
	Space *cl;
	if (argc != 1 && argc != 10)
	{
		Tcl_AppendResult(interp, "Wrong # args: should be \"",
				 argv[0]," ?name type description bg mosters ",
				 "dressings treasures tricks exitpairlist?\"",
				 (char*) NULL);
		return TCL_ERROR;
	}
	if (argc == 1)
	{
		cl = new Space;
	} else
	{
		MonsterList *m;
		DressingList *d;
		TreasureList *t;
		TrickList *tr;
		ExitType n = ExitType("None"),
			 ne = ExitType("None"),
			 e = ExitType("None"),
			 se = ExitType("None"),
			 s = ExitType("None"),
			 sw = ExitType("None"),
			 w = ExitType("None"),
			 nw = ExitType("None"),
			 u = ExitType("None"),
			 dn = ExitType("None");
		/* argv[1] : Name */
		/* argv[2] : Type */
		/* argv[3] : Description */
		/* argv[4] : BackgroundColor */
		/* argv[5] : monsters handle */
		if (argv[5][0] != '\0')
		{
			void_pt ptr = Tcl_HandleXlate(interp,
						      MonsterList::Handles,
						      argv[5]);
			if (ptr == NULL) return TCL_ERROR;
			m = *((MonsterList**) ptr);
		} else m = NULL;
		/* argv[6] : dressings handle */
		if (argv[6][0] != '\0')
		{
			void_pt ptr = Tcl_HandleXlate(interp,
						      DressingList::Handles,
						      argv[6]);
			if (ptr == NULL) return TCL_ERROR;
			d = *((DressingList**) ptr);
		} else d = NULL;
		/* argv[7] : treasures handle */
		if (argv[7][0] != '\0')
		{
			void_pt ptr = Tcl_HandleXlate(interp,
						      TreasureList::Handles,
						      argv[7]);
			if (ptr == NULL) return TCL_ERROR;
			t = *((TreasureList**) ptr);
		} else t = NULL;
		/* argv[8] : tricks handle */
		if (argv[8][0] != '\0')
		{
			void_pt ptr = Tcl_HandleXlate(interp,
						      TrickList::Handles,
						      argv[8]);
			if (ptr == NULL) return TCL_ERROR;
			tr = *((TrickList**) ptr);
		} else tr = NULL;
		/* argv[9] : exitpairlist */
		int xargc;
		char **xargv;
		if (Tcl_SplitList(interp, argv[9], &xargc, &xargv) != TCL_OK)
			return(TCL_ERROR);
		if ((xargc & 01) != 0)
		{
			Tcl_AppendResult(interp, "Bad exitpairlist (not an ",
					 "even number of elements):",argv[9],
					 (char*)NULL);
				return(TCL_ERROR);
		}
		for (int i = 0; i < xargc;i += 2)
		{
			String dir = xargv[i];
			ExitType et = ExitType(xargv[i+1]);
			if (!et)
			{
				Tcl_AppendResult(interp, "Bad exittype word: ",
						 xargv[i+1]," Should be one of ",
						 "{Door Doorway DoorSecret ",
						 "DoorLocked DoorOneWay ",
						 "StairsUp StairsDown RampUp ",
						 "RampDown None}",(char *) NULL);
				return TCL_ERROR;
			}
			if (dir == "north") n = et;
			else if (dir == "northeast") ne = et;
			else if (dir == "east") e = et;
			else if (dir == "southeast") se = et;
			else if (dir == "south") s = et;
			else if (dir == "southwest") sw = et;
			else if (dir == "west") w = et;
			else if (dir == "northwest") nw = et;
			else if (dir == "up") u = et;
			else if (dir == "down") dn = et;
			else
			{
				Tcl_AppendResult(interp, "Bad direction word: ",
						 xargv[i]," Should be one of ",
						 "{north northeast east ",
						 "southeast south southwest ",
						 "west northwest up down}",
						 (char *) NULL);
				return TCL_ERROR;
			}
		}
		free(xargv);
		cl = new Space(argv[1],argv[2],argv[3],argv[4],m,d,t,tr,n,ne,e,
			       se,s,sw,w,nw,u,dn);
	}
	char handle[32];
	Space **h = (Space **) Tcl_HandleAlloc (Space::Handles,handle);
	*h = cl;
	Tcl_CreateCommand(interp,handle,(Tcl_CmdProc*)spaceCommand,
			  (ClientData)cl,
			  (Tcl_CmdDeleteProc*)deleteSpace);
	Tcl_AppendResult(interp,handle,(char *) NULL);
	return TCL_OK;
}

static int allSpaces(ClientData clientData, Tcl_Interp *interp,int argc, char *argv[])
{
	int walk;
	walk = -1;
	while (Tcl_HandleWalk(Space::Handles,&walk) != NULL)
	{
		char handle[32];
		Tcl_WalkKeyToHandle(Space::Handles,walk,handle);
		Tcl_AppendElement(interp,handle);
	}
	return TCL_OK;

}

static int findSpacesBy(ClientData clientData, Tcl_Interp *interp,int argc, char *argv[])
{
	int walk;
	enum {name, ttype, description} field;
	Space **cp;
	if (argc != 3)
	{
		Tcl_AppendResult(interp, "Wrong # args: should be \"",
				 argv[0]," ?{name, type description} pattern? \"",
				 (char*) NULL);
		return TCL_ERROR;
	}
	if (strcmp(argv[1],"name") == 0) field = name;
	else if (strcmp(argv[1],"type") == 0) field = ttype ;
	else if (strcmp(argv[1],"description") == 0) field = description;
	else
	{
		Tcl_AppendResult(interp, "Bad field name: ",argv[1],
				 "should be one of {name type description}",
				 (char*) NULL);
		 return TCL_ERROR;
	}
	walk = -1;
	while ((cp = (Space**) Tcl_HandleWalk(Space::Handles,&walk)) != NULL)
	{
		Space *c = *cp;
		String value;
		switch (field)
		{
			case name:	value = c->Name; break;
			case ttype:	value = c->Type; break;
			case description: value = c->Description; break;
		}
		if (Tcl_StringMatch((char*)value,argv[2]))
		{
			char handle[32];
			Tcl_WalkKeyToHandle(Space::Handles,walk,handle);
			Tcl_AppendElement(interp,handle);
		}
	}
	return TCL_OK;
}


int Space_Init(Tcl_Interp *interp)
{
	Space::Handles = Tcl_HandleTblInit("Space",sizeof(Space*),256);
	Tcl_CreateCommand(interp, "Space", (Tcl_CmdProc*)spaceCreate,
			  (ClientData) NULL, (Tcl_CmdDeleteProc*) NULL);
	Tcl_CreateCommand(interp, "AllSpaces", (Tcl_CmdProc*)allSpaces,
			  (ClientData) NULL, (Tcl_CmdDeleteProc*) NULL);
	Tcl_CreateCommand(interp, "FindSpaceBy", (Tcl_CmdProc*)findSpacesBy,
			  (ClientData) NULL, (Tcl_CmdDeleteProc*) NULL);
	return TCL_OK;
}

void Space::HandlizePointers(Tcl_Interp *interp)
{
	char handle[32];
	for (TrickList *t = Tricks; t != NULL; t = t->NextTrick)
	{
		t->Handlize(interp);
	}
	for (TreasureList *tr = Treasures; tr != NULL; tr = tr->NextTreasure)
	{
		tr->Handlize(interp);
	}
	for (MonsterList *m = Monsters; m != NULL; m = m->NextMonster)
	{
		m->Handlize(interp);
	}
	for (DressingList *d = Dressings; d != NULL; d = d->NextDressing)
	{
		d->Handlize(interp);
	}
}

int Space::PSPut(ostream &os)
{
	os << "(" << PSQuote(Name);
	os << " [" << PSQuote(Type);
	os << "], Color: "
	   << PSQuote(BackgroundColor) << ") showhead" << endl;
	os << "NORMFONT (" << PSQuoteXnewline(Description) << ") CommentsParagraph" << endl;
	if (Monsters != NULL)
	{
		os << "(Monsters:) showhead" << endl << "NORMFONT" << endl;
		for (MonsterList *m = Monsters;m != NULL;m = m->NextMonster)
		{
			m->PSPut(os);
		}
	}
	if (Dressings != NULL)
	{
		os << "(Dressings:) showhead" << endl << "NORMFONT" << endl;
		for (DressingList *d = Dressings;d != NULL;d = d->NextDressing)
		{
			d->PSPut(os);
		}
	}
	if (Treasures != NULL)
	{
		os << "(Treasures:) showhead" << endl << "NORMFONT" << endl;
		for (TreasureList *t = Treasures;t != NULL;t = t->NextTreasure)
		{
			t->PSPut(os);
		}
	}
	if (Tricks != NULL)
	{
		os << "(Tricks:) showhead" << endl << "NORMFONT" << endl;
		for (TrickList *tr = Tricks;tr != NULL;tr = tr->NextTrick)
		{
			tr->PSPut(os);
		}
	}
        if (north != "None") os << "(North exit: " << north << " ) putstr" << endl;
        if (northeast != "None") os << "(Northeast exit: " << northeast << " ) putstr" << endl;
        if (east != "None") os << "(East exit: " << east << " ) putstr" << endl;
        if (southeast != "None") os << "(Southeast exit: " << southeast << " ) putstr" << endl;
        if (south != "None") os << "(South exit: " << south << " ) putstr" << endl;
        if (southwest != "None") os << "(Southwest exit: " << southwest << " ) putstr" << endl;
        if (west != "None") os << "(West exit: " << west << " ) putstr" << endl;
        if (northwest != "None") os << "(Northwest exit: " << northwest << " ) putstr" << endl;
        if (up != "None") os << "(Up exit: " << up << " ) putstr" << endl;
        if (down != "None") os << "(Down exit: " << down << " ) putstr" << endl;
        os << "newline" << endl;
        if (!os) return 0;
        else return 1;
}

static int PSPutBM(ostream &os,Tcl_Interp* interp,Tk_Window main,double X,double Y,String BM)
{
        double x = X,
               y1 = 100 - Y;
        if (BM == "") return 1;
        Tk_Uid bmuid = Tk_GetUid((char*)(BM));
        Pixmap bm = Tk_GetBitmap(interp,main,bmuid);
        int bmH,bmW;
        Tk_SizeOfBitmap(Tk_Display(main),bm,&bmW,&bmH);
        double y = y1 - bmH;
        os << "gsave " << x << " " << y << " translate" << endl;
        os << bmW << " " << bmH << " false DoImageMask" << endl;
        XImage *imagePtr = XGetImage(Tk_Display(main), bm, 0, 0,
                                   bmW,bmH, 1, XYPixmap);
        int charsInLine = 0, value = 0, mask = 0x080;
        char string[4];
        for (int iy = 1; iy <= bmH; iy++)
        {
          for (int ix = 0; ix < bmW; ix++)
          {
            if (XGetPixel(imagePtr, ix, bmH-iy)) value |= mask;
            mask >>= 1;
            if (mask == 0) 
            {
              sprintf(string, "%02x", value);
              os << string;
              mask = 0x80;
              value = 0;
              charsInLine += 2;
              if (charsInLine >= 60)
              {
                os << endl;
                charsInLine = 0;
              }
            }
          }
          if (mask != 0x80)
          {
            sprintf(string, "%02x", value);
            os << string;
            charsInLine += 2;
          }
        }
        if (charsInLine > 0) os << endl;
        os << "grestore" << endl;
        if (!os) return 0;
        else return 1;
}

static int PSPutBMOpaque(ostream &os,Tcl_Interp* interp,Tk_Window main,double X,double Y,Pixmap bm)
{
        double x = X,
               y1 = 100 - Y;
        int bmH,bmW;
        Tk_SizeOfBitmap(Tk_Display(main),bm,&bmW,&bmH);
        double y = y1 - bmH;
        os << "gsave " << x << " " << y << " translate" << endl;
        os << bmW << " " << bmH << " 1 DoImage" << endl;
        XImage *imagePtr = XGetImage(Tk_Display(main), bm, 0, 0,
                                   bmW,bmH, 1, XYPixmap);
        int charsInLine = 0, value = 0, mask = 0x080;
        char string[4];
        for (int iy = 1; iy <= bmH; iy++)
        {
          for (int ix = 0; ix < bmW; ix++)
          {
            if (!XGetPixel(imagePtr, ix, bmH-iy)) value |= mask;
            mask >>= 1;
            if (mask == 0) 
            {
              sprintf(string, "%02x", value);
              os << string;
              mask = 0x80;
              value = 0;
              charsInLine += 2;
              if (charsInLine >= 60)
              {
                os << endl;
                charsInLine = 0;
              }
            }
          }
          if (mask != 0x80)
          {
            sprintf(string, "%02x", value);
            os << string;
            charsInLine += 2;
          }
        }
        if (charsInLine > 0) os << endl;
        os << "grestore" << endl;
        if (!os) return 0;
        else return 1;
}

int ExitType::PSPutMap(ostream &os,Tcl_Interp* interp,double x,double  y)
{
        static Tk_Uid door,doorlocked,dooroneway,doorsecret,rampdown,rampup,
                      stairsdown,stairsup;
        static Pixmap BMdoor,BMdoorlocked,BMdooroneway,BMdoorsecret,BMrampdown,
                      BMrampup,BMstairsdown,BMstairsup;
        static bool bms_init = FALSE;

        Tk_Window main = Tk_MainWindow(interp);

        //if (value == None || value == Bogus) return 1;

        if (!bms_init)
        {
                door = Tk_GetUid("door");
                BMdoor = Tk_GetBitmap(interp,main,door);
                doorlocked = Tk_GetUid("doorlocked");
                BMdoorlocked = Tk_GetBitmap(interp,main,doorlocked);
                dooroneway = Tk_GetUid("dooroneway");
                BMdooroneway = Tk_GetBitmap(interp,main,dooroneway);
                doorsecret = Tk_GetUid("doorsecret");
                BMdoorsecret = Tk_GetBitmap(interp,main,doorsecret);
                rampdown = Tk_GetUid("rampdown");
                BMrampdown = Tk_GetBitmap(interp,main,rampdown);
                rampup = Tk_GetUid("rampup");
                BMrampup = Tk_GetBitmap(interp,main,rampup);
                stairsdown = Tk_GetUid("stairsdown");
                BMstairsdown = Tk_GetBitmap(interp,main,stairsdown);
                stairsup = Tk_GetUid("stairsup");
                BMstairsup = Tk_GetBitmap(interp,main,stairsup);
                bms_init = TRUE;
        }
        switch (value)
        {
                case Doorway:
                        os << "gsave newpath " << x << " " << y
                           << " moveto 0 16 rlineto 16 0 rlineto"
			   << " 0 -16 rlineto closepath gsave 1 setgray"
			   << " fill grestore 0 setgray stroke grestore"
                           << endl;
                        break;
                case Door: PSPutBMOpaque(os,interp,main,x,y,BMdoor); break;
                case DoorSecret: PSPutBMOpaque(os,interp,main,x,y,BMdoorsecret); break;
                case DoorLocked: PSPutBMOpaque(os,interp,main,x,y,BMdoorlocked); break;
                case DoorOneWay: PSPutBMOpaque(os,interp,main,x,y,BMdooroneway); break;
                case StairsUp: PSPutBMOpaque(os,interp,main,x,y,BMstairsup); break;
                case StairsDown: PSPutBMOpaque(os,interp,main,x,y,BMstairsdown); break;
                case RampUp: PSPutBMOpaque(os,interp,main,x,y,BMrampup); break;
                case RampDown: PSPutBMOpaque(os,interp,main,x,y,BMrampdown); break;
                default: break;
        }
        if (!os) return 0;
        else return 1;
}
        
int Space::PSPutMap(ostream &os,Tcl_Interp* interp)
{
        Tk_Window main = Tk_MainWindow(interp);

        if (BackgroundColor != "")
        {
          Tk_Uid colorUID = Tk_GetUid((char*)BackgroundColor);
          XColor *background = Tk_GetColor(interp,main,Tk_Colormap(main),
                                           colorUID);
          os << background->red/65535.0 << " "
             << background->green/65535.0 << " "
             << background->blue/65535.0 << " setrgbcolor" << endl;
          os << "newpath 0 0 moveto 0 100 lineto 100 100 lineto 100 0 lineto closepath fill"
             << endl;
          os << "0 setgray" << endl;
        }
        if (Monsters != NULL)
        {
                for (MonsterList *m = Monsters;m != NULL;m = m->NextMonster)
                {
                        PSPutBM(os,interp,main,m->SpaceX,m->SpaceY,m->Bitmap);
                }
        }
        if (Dressings != NULL)
        {
                for (DressingList *d = Dressings;d != NULL;d = d->NextDressing)
                {
                        PSPutBM(os,interp,main,d->SpaceX,d->SpaceY,d->Bitmap);
                }
        }
        if (Treasures != NULL)
        {
                for (TreasureList *t = Treasures;t != NULL;t = t->NextTreasure)
                {
                        PSPutBM(os,interp,main,t->SpaceX,t->SpaceY,t->Bitmap);
                }
        }
        if (Tricks != NULL)
        {
                for (TrickList *tr = Tricks;tr != NULL;tr = tr->NextTrick)
                {
                        PSPutBM(os,interp,main,tr->SpaceX,tr->SpaceY,tr->Bitmap);
                }
        }
        if (north != "None") north.PSPutMap(os,interp,42.0,0.0);
        if (northeast != "None") northeast.PSPutMap(os,interp,84.0,0.0);
        if (east != "None") east.PSPutMap(os,interp,84.0,42.0);
        if (southeast != "None") southeast.PSPutMap(os,interp,84.0,84.0);
        if (south != "None") south.PSPutMap(os,interp,42.0,84.0);
        if (southwest != "None") southwest.PSPutMap(os,interp,0.0,84.0);
        if (west != "None") west.PSPutMap(os,interp,0.0,42.0);
        if (northwest != "None") northwest.PSPutMap(os,interp,0.0,0.0);
        if (up != "None") up.PSPutMap(os,interp,34.0,42.0);
        if (down != "None") down.PSPutMap(os,interp,50.0,42.0);
	if (!os) return 0;
	else return 1;
}

int Space::HTMLPut(ostream &os)
{
	os << "<h1>" << Name << " [" << Type << "], Color: "
	   << BackgroundColor << "</h1><br>" << endl;
	os << "<p>" << endl << Description << endl << "</p>" << endl;
	if (Monsters != NULL)
	{
		os << "<h1>Monsters:</h1><br>" << endl;
		for (MonsterList *m = Monsters;m != NULL;m = m->NextMonster)
		{
			m->HTMLPut(os);
		}
	}
	if (Dressings != NULL)
	{
		os << "<h1>Dressings:</h1><br>" << endl;
		for (DressingList *d = Dressings;d != NULL;d = d->NextDressing)
		{
			d->HTMLPut(os);
		}
	}
	if (Treasures != NULL)
	{
		os << "<h1>Treasures:</h1><br>" << endl;
		for (TreasureList *t = Treasures;t != NULL;t = t->NextTreasure)
		{
			t->HTMLPut(os);
		}
	}
	if (Tricks != NULL)
	{
		os << "<h1>Tricks:</h1><br>" << endl;
		for (TrickList *tr = Tricks;tr != NULL;tr = tr->NextTrick)
		{
			tr->HTMLPut(os);
		}
	}
	if (north != "None") os << "North exit: " << north << " ";
	if (northeast != "None") os << "Northeast exit: " << northeast << " " << endl;
	if (east != "None") os << "East exit: " << east << " " << endl;
	if (southeast != "None") os << "Southeast exit: " << southeast << " " << endl;
	if (south != "None") os << "South exit: " << south << " " << endl;
	if (southwest != "None") os << "Southwest exit: " << southwest << " " << endl;
	if (west != "None") os << "West exit: " << west << " " << endl;
	if (northwest != "None") os << "Northwest exit: " << northwest << " " << endl;
	if (up != "None") os << "Up exit: " << up << " " << endl;
	if (down != "None") os << "Down exit: " << down << " " << endl;
	os << "<br>" << endl;
	if (!os) return 0;
	else return 1;
}

int Space::TEXTPut(ostream &os)
{
	os << Name << " [" << Type << "], Color: "
	   << BackgroundColor << endl;
	os << Description << endl;
	if (Monsters != NULL)
	{
		os << "Monsters:" << endl;
		for (MonsterList *m = Monsters;m != NULL;m = m->NextMonster)
		{
			m->TEXTPut(os);
		}
	}
	if (Dressings != NULL)
	{
		os << "Dressings:" << endl;
		for (DressingList *d = Dressings;d != NULL;d = d->NextDressing)
		{
			d->TEXTPut(os);
		}
	}
	if (Treasures != NULL)
	{
		os << "Treasures:" << endl;
		for (TreasureList *t = Treasures;t != NULL;t = t->NextTreasure)
		{
			t->TEXTPut(os);
		}
	}
	if (Tricks != NULL)
	{
		os << "Tricks:" << endl;
		for (TrickList *tr = Tricks;tr != NULL;tr = tr->NextTrick)
		{
			tr->TEXTPut(os);
		}
	}
	if (north != "None") os << "North exit: " << north << " ";
	if (northeast != "None") os << "Northeast exit: " << northeast << " " << endl;
	if (east != "None") os << "East exit: " << east << " " << endl;
	if (southeast != "None") os << "Southeast exit: " << southeast << " " << endl;
	if (south != "None") os << "South exit: " << south << " " << endl;
	if (southwest != "None") os << "Southwest exit: " << southwest << " " << endl;
	if (west != "None") os << "West exit: " << west << " " << endl;
	if (northwest != "None") os << "Northwest exit: " << northwest << " " << endl;
	if (up != "None") os << "Up exit: " << up << " " << endl;
	if (down != "None") os << "Down exit: " << down << " " << endl;
	os << endl;
	if (!os) return 0;
	else return 1;
}


