/*
 * ------------------------------------------------------------------
 * MonsterLists.cc - Code for MonsterLists
 * Created by Robert Heller on Sat Jun 17 23:33:23 1995
 * ------------------------------------------------------------------
 * Modification History: $Log: MonsterLists.cc,v $
// Revision 1.3  1995/06/18  06:37:48  heller
// Add Handlize() method
//
// Revision 1.2  1995/06/18  06:00:49  heller
// fix static member decl. problem
//
// Revision 1.1  1995/06/18  03:50:39  heller
// Initial revision
//
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 *  
 *     Role Playing Database -- a program for maintaining a database
 *                              for RPG characters and monsters
 *     Copyright (C) 1995  Robert Heller D/B/A Deepwoods Software
 * 			51 Locke Hill Road
 * 			Wendell, MA 01379-9728
 * 
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *  
 */

static char rcsid[] = "$Id: MonsterLists.cc,v 1.3 1995/06/18 06:37:48 heller Exp $";

#include <iostream.h>
#include <fstream.h>
#include <pfstream.h>
#include <strstream.h>
#include <Master.h>
#include <Monster.h>
#include <Character.h>
#include <tclExtend.h>
#include <tk.h>
#include <tkX.h>
#include <stdlib.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

ostream& operator << (ostream& os, MonsterList& ml)
{
	if (ml.Handle == "") os << "{}";
	else os << ml.Handle;
	os << " ";
	if (ml.File == "") os << "{}";
	else os << ml.File;
	os << " ";
	if (ml.Bitmap == "") os << "{}";
	else os << ml.Bitmap;
	os << " "
	   << ml.SpaceX<< " " << ml.SpaceY << " " << ml.HitPoints;
}


istream& operator >> (istream& is, MonsterList& ml)
{
	is >> ml.Handle;
	if (ml.Handle == "{}") ml.Handle = "";
	is >> ml.File;
	if (ml.File == "{}") ml.File = "";
	is >> ml.Bitmap;
	if (ml.Bitmap == "{}") ml.Bitmap = "";
	is >> ml.SpaceX;
	is >> ml.SpaceY;
	is >> ml.HitPoints;
}


void_pt MonsterList::Handles = NULL;

int MonsterList::TclFunction(Tcl_Interp *interp, int argc, char *argv[])
{
	if (argc == 1)
	{
		// no option, echo slots
		Tcl_DString result;
		Tcl_DStringInit(&result);
		Tcl_DStringAppendElement(&result,"MonsterList");

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Handle");
		Tcl_DStringAppendElement(&result,(char*)Handle);
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"File");
		Tcl_DStringAppendElement(&result,(char*)File);
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Bitmap");
		Tcl_DStringAppendElement(&result,(char*)Bitmap);
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"NextMonster");
		if (NextMonster == NULL)
		{
			Tcl_DStringAppendElement(&result,"");
		} else
		{
			char temp[32];
			if (PointerToHandle(interp,MonsterList::Handles,
			    NextMonster,temp) != TCL_OK)
				return TCL_ERROR;
			Tcl_DStringAppendElement(&result,temp);
		}
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"SpaceX");
		{
			ostrstream stream;
			stream << SpaceX;
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"SpaceY");
		{
			ostrstream stream;
			stream << SpaceY;
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"HitPoints");
		{
			ostrstream stream;
			stream << HitPoints;
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		Tcl_DStringEndSublist(&result);

		Tcl_DStringResult(interp,&result);
		return TCL_OK;
	}
	if (strcmp(argv[1], "type") == 0)
	{
		if (argc != 2)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],(char *) NULL);
			return TCL_ERROR;
		}
		Tcl_AppendResult(interp, "MonsterList", (char *) NULL);
		return TCL_OK;
	} else if (strcmp(argv[1], "handle") == 0)
	{
		if (argc == 2)
		{
			Tcl_AppendResult(interp,(char*)Handle,(char *) NULL);
			return TCL_OK;
		} else if (argc == 3)
		{
			Handle = argv[2];
			Tcl_AppendResult(interp,(char*)Handle,(char *) NULL);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "file") == 0)
	{
		if (argc == 2)
		{
			Tcl_AppendResult(interp,(char*)File,(char *) NULL);
			return TCL_OK;
		} else if (argc == 3)
		{
			File = argv[2];
			Tcl_AppendResult(interp,(char*)File,(char *) NULL);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "bitmap") == 0)
	{
		if (argc == 2)
		{
			Tcl_AppendResult(interp,(char*)Bitmap,(char *) NULL);
			return TCL_OK;
		} else if (argc == 3)
		{
			Bitmap = argv[2];
			Tcl_AppendResult(interp,(char*)Bitmap,(char *) NULL);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "nextmonster") == 0)
	{
		if (argc == 3)
		{
			MonsterList* nx = NULL;
			if (argv[2][0] != '\0')
			{
				void_pt ptr = Tcl_HandleXlate(interp,
					MonsterList::Handles,argv[2]);
				if (ptr == NULL) return TCL_ERROR;
				nx = *((MonsterList**) ptr);
			}
			NextMonster = nx;
		} else if (argc > 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		if (NextMonster == NULL)
		{
			interp->result = "";
			return TCL_OK;
		}
		char temp[32];
		if (PointerToHandle(interp,MonsterList::Handles,NextMonster,
				    temp) != TCL_OK)
			return TCL_ERROR;
		Tcl_AppendResult(interp,temp,(char *) NULL);
		return TCL_OK;
	} else if (strcmp(argv[1], "spacex") == 0)
	{
		if (argc == 3)
		{
			if (Tcl_GetDouble(interp,argv[2],&SpaceX) != TCL_OK)
				return(TCL_ERROR);
		} else if (argc > 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		ostrstream stream;
		stream << SpaceX;
		_IO_ssize_t i = stream.pcount();
		char *s = stream.str();
		s[i] = '\0';
		Tcl_AppendResult(interp,s,(char *) NULL);
		stream.freeze(0);
		return TCL_OK;
	} else if (strcmp(argv[1], "spacey") == 0)
	{
		if (argc == 3)
		{
			if (Tcl_GetDouble(interp,argv[2],&SpaceY) != TCL_OK)
				return(TCL_ERROR);
		} else if (argc > 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		ostrstream stream;
		stream << SpaceY;
		_IO_ssize_t i = stream.pcount();
		char *s = stream.str();
		s[i] = '\0';
		Tcl_AppendResult(interp,s,(char *) NULL);
		stream.freeze(0);
		return TCL_OK;
	} else if (strcmp(argv[1], "hitpoints") == 0)
	{
		if (argc == 3)
		{
			int temp;
			if (Tcl_GetInt(interp,argv[2],&temp) != TCL_OK)
				return(TCL_ERROR);
			HitPoints = temp;
		} else if (argc > 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		ostrstream stream;
		stream << HitPoints;
		_IO_ssize_t i = stream.pcount();
		char *s = stream.str();
		s[i] = '\0';
		Tcl_AppendResult(interp,s,(char *) NULL);
		stream.freeze(0);
		return TCL_OK;
	} else if (strcmp(argv[1], "list") == 0)
	{
		if (argc != 2)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],"\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		Tcl_AppendElement(interp,argv[0]);
		for (MonsterList* nx = NextMonster; nx != NULL;
		     nx = nx->NextMonster)
		{
			char temp[32];
			if (PointerToHandle(interp,MonsterList::Handles,nx,
					    temp) != TCL_OK)
				return TCL_ERROR;
			Tcl_AppendElement(interp,temp);
		}
		return TCL_OK;
	} else if (strcmp(argv[1], "delete") == 0)
	{
		if (argc != 2)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],"\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		void_pt header = Tcl_HandleXlate (interp,MonsterList::Handles,argv[0]);
		if (header == NULL) return TCL_ERROR;
		Tcl_HandleFree (MonsterList::Handles,header);
		return Tcl_DeleteCommand(interp,argv[0]);
	} else
	{
		Tcl_AppendResult(interp, "Bad option: ",argv[1],(char *) NULL);
		return TCL_ERROR;
	}
}

static void deleteMonsterList(ClientData clientData)
{
	register MonsterList *cl = (MonsterList*) clientData;
	delete cl;
}

static int monsterListCommand(ClientData clientData, Tcl_Interp *interp,
				int argc, char *argv[])
{
	register MonsterList *cl = (MonsterList*) clientData;
	return cl->TclFunction(interp,argc,argv);
}

static int monsterListCreate(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[])
{
	MonsterList *cl;
	if (argc != 1 && argc != 8)
	{
		Tcl_AppendResult(interp, "Wrong # args: should be \"",
				 argv[0]," ?handle file bitmap next x y hp?\"",
				 (char*) NULL);
		return TCL_ERROR;
	}
	if (argc == 1)
	{
		cl = new MonsterList;
	} else
	{
		int hp;
		double x,y;
		MonsterList *nx;
		/* argv[1] : Handle */
		/* argv[2] : File */
		/* argv[3] : Bitmap */
		/* argv[4] : NextMonster handle */
		if (argv[4][0] != '\0')
		{
			void_pt ptr = Tcl_HandleXlate(interp,
						      MonsterList::Handles,
						      argv[4]);
			if (ptr == NULL) return TCL_ERROR;
			nx = *((MonsterList**) ptr);
		} else nx = NULL;
		if (Tcl_GetDouble(interp,argv[5],&x) != TCL_OK)
			return TCL_ERROR;
		if (Tcl_GetDouble(interp,argv[6],&y) != TCL_OK)
			return TCL_ERROR;
		if (Tcl_GetInt(interp,argv[7],&hp) != TCL_OK)
			return TCL_ERROR;
		cl = new MonsterList(argv[1],argv[2],argv[3],nx,x,y,hp);
	}
	char handle[32];
	MonsterList **h = (MonsterList **) Tcl_HandleAlloc (MonsterList::Handles,handle);
	*h = cl;
	Tcl_CreateCommand(interp,handle,(Tcl_CmdProc*)monsterListCommand,
			  (ClientData)cl,
			  (Tcl_CmdDeleteProc*)deleteMonsterList);
	Tcl_AppendResult(interp,handle,(char *) NULL);
	return TCL_OK;
}

int MonsterList::Handlize(Tcl_Interp *interp)
{
	char handle[32];
	MonsterList **tl = (MonsterList **)
		Tcl_HandleAlloc (MonsterList::Handles,handle);
	*tl = this;
	Tcl_CreateCommand(interp,handle,(Tcl_CmdProc*)monsterListCommand,
			  this,(Tcl_CmdDeleteProc*)deleteMonsterList);
	Tcl_AppendResult(interp,handle,(char *) NULL);
	return TCL_OK;
}

static int allMonsterLists(ClientData clientData, Tcl_Interp *interp,int argc, char *argv[])
{
	int walk;
	walk = -1;
	while (Tcl_HandleWalk(MonsterList::Handles,&walk) != NULL)
	{
		char handle[32];
		Tcl_WalkKeyToHandle(MonsterList::Handles,walk,handle);
		Tcl_AppendElement(interp,handle);
	}
	return TCL_OK;

}



int MonsterList_Init(Tcl_Interp *interp)
{
	MonsterList::Handles = Tcl_HandleTblInit("MonsterList",sizeof(MonsterList*),256);
	Tcl_CreateCommand(interp, "MonsterList", (Tcl_CmdProc*)monsterListCreate,
			  (ClientData) NULL, (Tcl_CmdDeleteProc*) NULL);
	Tcl_CreateCommand(interp, "AllMonsterLists", (Tcl_CmdProc*)allMonsterLists,
			  (ClientData) NULL, (Tcl_CmdDeleteProc*) NULL);
	return TCL_OK;
}

int MonsterList::PSPut(ostream &os)
{
	if (Handle != "")
	{
		os << "(Handle: " << Handle << ") showline" << endl;
	}
	if (File != "")
	{
		os << "(File: " << File << ") showline" << endl;
	}
	if (Bitmap != "")
	{
		os << "(Bitmap: " << Bitmap << ") showline" << endl;
	}
	os << "(Lurking at at \\(" << SpaceX << "," << SpaceY
	   << "\\), Hitpoints: " << HitPoints << ") showline" << endl;
	if (!os) return 0;
	else return 1;
}

int MonsterList::PSPut(ostream &os,Tcl_Interp* interp)
{
	if (Handle != "")
	{
		os << "(Handle: " << Handle;
		void_pt ptr;
		if ((ptr = Tcl_HandleXlate(interp,Monster::Handles,(char*)Handle)) != NULL)
		{
			Monster *mon = *((Monster**)ptr);
			os << " \\(" << PSQuote(mon->Name) << "\\)";
		} else if ((ptr = Tcl_HandleXlate(interp,Character::Handles,(char*)Handle)) != NULL)
		{
			Character *ch = *((Character**)ptr);
			os << " \\(" << PSQuote(ch->Name) << "\\)";
		}
		os << ") showline" << endl;
	}
	if (File != "")
	{
		os << "(File: " << File << ") showline" << endl;
	}
	if (Bitmap != "")
	{
		os << "(Bitmap: " << Bitmap << ") showline" << endl;
	}
	os << "(Lurking at at \\(" << SpaceX << "," << SpaceY
	   << "\\), Hitpoints: " << HitPoints << ") showline" << endl;
	if (!os) return 0;
	else return 1;
}

int MonsterList::HTMLPut(ostream &os)
{
	if (Handle != "")
	{
		os << "Handle: " << Handle << "<br>" << endl;
	}
	if (File != "")
	{
		os << "File: " << File << "<br>" << endl;
	}
	if (Bitmap != "")
	{
		os << "Bitmap: " << Bitmap << "<br>" << endl;
	}
	os << "Lurking at (" << SpaceX << "," << SpaceY
	   << "), Hitpoints: " << HitPoints << "<br>" << endl;
	if (!os) return 0;
	else return 1;
}

int MonsterList::HTMLPut(ostream &os,Tcl_Interp* interp)
{
	if (Handle != "")
	{
		os << "Handle: " << Handle;
		void_pt ptr;
		if ((ptr = Tcl_HandleXlate(interp,Monster::Handles,(char*)Handle)) != NULL)
		{
			Monster *mon = *((Monster**)ptr);
			os << " (" << mon->Name << ")";
		} else if ((ptr = Tcl_HandleXlate(interp,Character::Handles,(char*)Handle)) != NULL)
		{
			Character *ch = *((Character**)ptr);
			os << " (" << ch->Name << ")";
		}
		os << "<br>" << endl;
	}
	if (File != "")
	{
		os << "File: " << File << "<br>" << endl;
	}
	if (Bitmap != "")
	{
		os << "Bitmap: " << Bitmap << "<br>" << endl;
	}
	os << "Lurking at (" << SpaceX << "," << SpaceY
	   << "), Hitpoints: " << HitPoints << "<br>" << endl;
	if (!os) return 0;
	else return 1;
}

int MonsterList::TEXTPut(ostream &os)
{
	if (Handle != "")
	{
		os << "Handle: " << Handle << endl;
	}
	if (File != "")
	{
		os << "File: " << File << endl;
	}
	if (Bitmap != "")
	{
		os << "Bitmap: " << Bitmap << endl;
	}
	os << "Lurking at (" << SpaceX << "," << SpaceY
	   << "), Hitpoints: " << HitPoints << endl;
	if (!os) return 0;
	else return 1;
}

int MonsterList::TEXTPut(ostream &os,Tcl_Interp* interp)
{
	if (Handle != "")
	{
		os << "Handle: " << Handle;
		void_pt ptr;
		if ((ptr = Tcl_HandleXlate(interp,Monster::Handles,(char*)Handle)) != NULL)
		{
			Monster *mon = *((Monster**)ptr);
			os << " (" << mon->Name << ")";
		} else if ((ptr = Tcl_HandleXlate(interp,Character::Handles,(char*)Handle)) != NULL)
		{
			Character *ch = *((Character**)ptr);
			os << " (" << ch->Name << ")";
		}
		os << endl;
	}
	if (File != "")
	{
		os << "File: " << File << endl;
	}
	if (Bitmap != "")
	{
		os << "Bitmap: " << Bitmap << endl;
	}
	os << "Lurking at (" << SpaceX << "," << SpaceY
	   << "), Hitpoints: " << HitPoints << endl;
	if (!os) return 0;
	else return 1;
}


