/*
 * ------------------------------------------------------------------
 * Master.h - Master Class definations
 * Created by Robert Heller on Fri Mar 17 11:38:12 1995
 * ------------------------------------------------------------------
 * Modification History: $Log: Master.h,v $
 * Revision 1.13  1995/07/02  17:43:48  heller
 * Fix Memory "anti-leak" in ~Game()
 *
 * Revision 1.12  1995/07/02  02:09:50  heller
 * Add in EncumbrenceList::Handlize()
 * and use it in FixUpEncumbrenceLists()
 *
 * Revision 1.11  1995/06/24  16:43:21  heller
 * Fix hash table handling in ~Dungeon()
 *
 * Revision 1.10  1995/06/18  16:18:03  heller
 * Postscript related methods added.
 * Handle code revised to allow splitting up Master.cc
 *
 * Revision 1.9  1995/04/11  23:15:41  heller
 * Misc. typos.
 * Misc. changes to Game class (inline constructor and destructor)
 *
 * Revision 1.8  1995/04/11  02:45:52  heller
 * Add Tcl_Interp* forms for some of the Put() funs (handle expansion).
 * Add Up and Down exit directions.
 * Add pointer to treasure hash table hack to Dungeon::ReadFromFile().
 *
 * Revision 1.6  1995/03/23  00:39:59  heller
 * Added HTMLPut and TEXTPut methods
 *
 * Revision 1.5  1995/03/22  00:19:18  heller
 * Finish Dungeon I/O
 * (Includes additional adjustments to other I/O handlers)
 *
 * Revision 1.4  1995/03/21  04:25:14  heller
 * Added a big chunk of Dungeon
 *
 * Revision 1.3  1995/03/19  21:50:00  heller
 * Add Space implementation
 * Fix minor errors in Space defs.
 *
 * Revision 1.2  1995/03/19  05:07:31  heller
 * Reduce Direction from class to simple (scoped) enum
 *
 * Revision 1.1  1995/03/18  05:49:30  heller
 * Initial revision
 *
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 *  
 *     Role Playing Database -- a program for maintaining a database
 *                              for RPG characters and monsters
 *     Copyright (C) 1995  Robert Heller D/B/A Deepwoods Software
 * 			51 Locke Hill Road
 * 			Wendell, MA 01379-9728
 * 
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *  
 */

#ifndef _MASTER_H_
#define _MASTER_H_
#include <bool.h>
#include <iostream.h>
#include <String.h>
#include <tclExtend.h>

struct EncumbrenceList;

struct CharacterList {
	String Handle;
	String File;
	String Bitmap;
	CharacterList *NextCharacter;
	double MarchX, MarchY;
	EncumbrenceList *Encumbrences;
	short int HitPoints;
	static void_pt Handles;
	friend ostream& operator << (ostream& os, CharacterList& cl);
	friend istream& operator >> (istream& is, CharacterList& cl);
	int TclFunction(Tcl_Interp *interp, int argc, char *argv[]);
	int PSPut(ostream &os);
	int HTMLPut(ostream &os);
	int TEXTPut(ostream &os);
	int PSPut(ostream &os,Tcl_Interp* interp);
	int HTMLPut(ostream &os,Tcl_Interp* interp);
	int TEXTPut(ostream &os,Tcl_Interp* interp);
	CharacterList(String h = String(""),String f = String(""),
		     String b = String("questhead"),CharacterList *nx = NULL,
		     double x = 0.0, double y = 0.0, EncumbrenceList *e = NULL,
		     int hp = 0)
		{Handle = h;File = f;Bitmap = b;NextCharacter = nx;MarchX = x;
		 MarchY = y;Encumbrences = e;HitPoints = hp;
		}
};

struct EncumbrenceList {
	String Name;
	String Handle;
	String Description;
	int Weight;
	int ACAdj;
	int ToHitAdj;
	int DamAdj;
	int MagResAdj;
	int DamProtAdj;
	struct {int s,i,w,d,c,ch;} AbilityAdjs;
	struct {int g,f,s;} MoveAdj;
	int Value;
	EncumbrenceList *NextEncumbrence;
	static void_pt Handles;
	EncumbrenceList(String n = String(""),String h = String(""),
			String d = String(""),int w = 0,int a = 0,int t= 0,
			int dama = 0,int m = 0,int dpa = 0,int sa = 0,
			int ia = 0,int wa = 0,int da = 0,int ca = 0,
			int cha = 0,int ma = 0,int mfa = 0,int msa = 0,
			int v = 0, EncumbrenceList *nx = NULL)
		{
			Name = n;
			Handle = h;
			Description = d;
			Weight = w;
			ACAdj = a;
			ToHitAdj = t;
			DamAdj = dama;
			MagResAdj = m;
			DamProtAdj = dpa;
			AbilityAdjs.s = sa;
			AbilityAdjs.i = ia;
			AbilityAdjs.w = wa;
			AbilityAdjs.d = da;
			AbilityAdjs.c = ca;
			AbilityAdjs.ch = cha;
			MoveAdj.g = ma;
			MoveAdj.f = mfa;
			MoveAdj.s = msa;
			Value = v;
			NextEncumbrence = nx;
		}
	friend ostream& operator << (ostream& os, EncumbrenceList& el);
	friend istream& operator >> (istream& is, EncumbrenceList& el);
	int TclFunction(Tcl_Interp *interp, int argc, char *argv[]);
	int PSPut(ostream &os);
	int HTMLPut(ostream &os);
	int TEXTPut(ostream &os);
	int Handlize(Tcl_Interp* interp);
};

struct MonsterList {
	String Handle;
	String File;
	String Bitmap;
	MonsterList *NextMonster;
	double SpaceX, SpaceY;
	short int HitPoints;
	static void_pt Handles;
	friend ostream& operator << (ostream& os, MonsterList& ml);
	friend istream& operator >> (istream& is, MonsterList& ml);
	int TclFunction(Tcl_Interp *interp, int argc, char *argv[]);
	int PSPut(ostream &os);
	int HTMLPut(ostream &os);
	int TEXTPut(ostream &os);
	int PSPut(ostream &os,Tcl_Interp* interp);
	int HTMLPut(ostream &os,Tcl_Interp* interp);
	int TEXTPut(ostream &os,Tcl_Interp* interp);
	MonsterList(String h = String(""),String f = String(""),
		     String b = String("question"),MonsterList *nx = NULL,
		     double x = 0.0, double y = 0.0,int hp = 0)
		{Handle = h;File = f;Bitmap = b;NextMonster = nx;SpaceX = x;
		 SpaceY = y;HitPoints = hp;
		}
	int Handlize(Tcl_Interp* interp);
};

struct DressingList {
	String Name;
	String Bitmap;
	String Description;
	DressingList *NextDressing;
	double SpaceX, SpaceY;
	int Value;
	static void_pt Handles;
	DressingList(String n = String(""),String b = String("hourglass"),
		     String d = String(""),DressingList *nx = NULL,
		     double x = 0.0, double y = 0.0,int v = 0)
		{
			Name = n;
			Bitmap = b;
			Description = d;
			NextDressing = nx;
			SpaceX = x;
			SpaceY = y;
			Value = v;
		}
	friend ostream& operator << (ostream& os, DressingList& dl);
	friend istream& operator >> (istream& is, DressingList& dl);
	int TclFunction(Tcl_Interp *interp, int argc, char *argv[]);
	int PSPut(ostream &os);
	int HTMLPut(ostream &os);
	int TEXTPut(ostream &os);
	int Handlize(Tcl_Interp* interp);
};

struct TreasureList {
	String Name;
	String Bitmap;
	String Handle;
	TreasureList *NextTreasure;
	double SpaceX, SpaceY;
	int Value;
	static void_pt Handles;
	TreasureList(String n = String(""),String b = String("warning"),
		     String h = String(""),TreasureList *nx = NULL,
		     double x = 0.0, double y = 0.0,int v = 0)
		{
			Name = n;
			Bitmap = b;
			Handle = h;
			NextTreasure = nx;
			SpaceX = x;
			SpaceY = y;
			Value = v;
		}
	friend ostream& operator << (ostream& os, TreasureList& tl);
	friend istream& operator >> (istream& is, TreasureList& tl);
	int TclFunction(Tcl_Interp *interp, int argc, char *argv[]);
	int PSPut(ostream &os);
	int HTMLPut(ostream &os);
	int TEXTPut(ostream &os);
	int PSPut(ostream &os,Tcl_Interp* interp);
	int HTMLPut(ostream &os,Tcl_Interp* interp);
	int TEXTPut(ostream &os,Tcl_Interp* interp);
	int Handlize(Tcl_Interp* interp);
};

struct TrickList {
	String Name;
	String Bitmap;
	String Handle;
	TrickList *NextTrick;
	double SpaceX, SpaceY;
	int Value;
	bool Active;
	static void_pt Handles;
	TrickList(String n = String(""),String b = String("error"),
		     String h = String(""),TrickList *nx = NULL,
		     double x = 0.0, double y = 0.0,int v = 0,bool a = TRUE)
		{
			Name = n;
			Bitmap = b;
			Handle = h;
			NextTrick = nx;
			SpaceX = x;
			SpaceY = y;
			Value = v;
			Active = a;
		}
	friend ostream& operator << (ostream& os, TrickList& tl);
	friend istream& operator >> (istream& is, TrickList& tl);
	int TclFunction(Tcl_Interp *interp, int argc, char *argv[]);
	int PSPut(ostream &os);
	int HTMLPut(ostream &os);
	int TEXTPut(ostream &os);
	int PSPut(ostream &os,Tcl_Interp* interp);
	int HTMLPut(ostream &os,Tcl_Interp* interp);
	int TEXTPut(ostream &os,Tcl_Interp* interp);
	int Handlize(Tcl_Interp* interp);
};

struct Treasure {
	String Name;
	String Type;
	String Description;
	int ExperiencePointValue;
	int Value;
	bool Unique, Taken;
	static void_pt Handles;
	Treasure(String n = String(""),String t = String(""),
		 String d = String(""),int e = 0,int v = 0,bool u = FALSE,
		 bool tk = FALSE)
		{
			Name = n;
			Type = t;
			Description = d;
			ExperiencePointValue = e;
			Value = v;
			Unique = u;
			Taken = tk;
		}
	friend ostream& operator << (ostream& os, Treasure& t);
	friend istream& operator >> (istream& is, Treasure& t);
	int TclFunction(Tcl_Interp *interp, int argc, char *argv[]);
	int PSPut(ostream &os);
	int HTMLPut(ostream &os);
	int TEXTPut(ostream &os);
};

struct Trick {
	String Name;
	String Type;
	String Description;
	static void_pt Handles;
	Trick(String n = String(""),String t = String(""),
	      String d = String(""))
		{
			Name = n;
			Type = t;
			Description = d;
		}
	friend ostream& operator << (ostream& os, Trick& t);
	friend istream& operator >> (istream& is, Trick& t);
	int TclFunction(Tcl_Interp *interp, int argc, char *argv[]);
	int PSPut(ostream &os);
	int HTMLPut(ostream &os);
	int TEXTPut(ostream &os);
};

class ExitType {
private:
	enum {Door, Doorway, DoorSecret, DoorLocked, DoorOneWay, StairsUp,
	      StairsDown, RampUp, RampDown, None, Bogus} value;
public:
	ExitType () {value = Bogus;}
	ExitType (String v)
	{
		if (v == "Door") value = Door;
		else if (v == "Doorway") value = Doorway;
		else if (v == "DoorSecret") value = DoorSecret;
		else if (v == "DoorLocked") value = DoorLocked;
		else if (v == "DoorOneWay") value = DoorOneWay;
		else if (v == "StairsUp") value = StairsUp;
		else if (v == "StairsDown") value = StairsDown;
		else if (v == "RampUp") value = RampUp;
		else if (v == "RampDown") value = RampDown;
		else if (v == "None") value = None;
		else v = Bogus;
	}
	ExitType (const char* s)
		{ExitType e = ExitType(String(s));value = e.value;}
	inline operator !() {return (value == Bogus);}
	inline operator const char* ()
	{switch (value)
	  {
		case Door: return "Door";
		case Doorway: return "Doorway";
		case DoorSecret: return "DoorSecret";
		case DoorLocked: return "DoorLocked";
		case DoorOneWay: return "DoorOneWay";
		case StairsUp: return "StairsUp";
		case StairsDown: return "StairsDown";
		case RampUp: return "RampUp";
		case RampDown: return "RampDown";
		case None: return "None";
		default: return NULL;
	  }
	}
	inline friend ostream& operator << (ostream& s,ExitType& e)
	{
		s << (char*) e;
		return(s);
	}
	inline friend istream& operator >> (istream& s,ExitType& e)
	{
		String temp;
		s >> temp;
		e = ExitType(temp);
		return s;
	}
	int PSPutMap(ostream &os,Tcl_Interp* interp,double x,double y);
};

class Space {
public:
	String Name;
	String Type;
	String Description;
	String BackgroundColor;
	MonsterList *Monsters;
	DressingList *Dressings;
	TreasureList *Treasures;
	TrickList *Tricks;
	static void_pt Handles;
private:
	ExitType north, northeast, east, southeast, south, southwest, west,
		 northwest, up, down;
public:
	Space(String nm = String(""),String t = String(""),
	      String d = String(""),String bc = String(""),
	      MonsterList *ml = NULL,
	      DressingList *dl = NULL,TreasureList *tl = NULL,
	      TrickList *trl = NULL,ExitType n = ExitType("None"),
	      ExitType ne = ExitType("None"),ExitType e = ExitType("None"),
	      ExitType se = ExitType("None"),ExitType s = ExitType("None"),
	      ExitType sw = ExitType("None"),ExitType w = ExitType("None"),
	      ExitType nw = ExitType("None"),ExitType u = ExitType("None"),
	      ExitType dn = ExitType("None"))
	{
		Name = nm;
		Type = t;
		Description = d;
		BackgroundColor = bc;
		Monsters = ml;
		Dressings = dl;
		Treasures = tl;
		Tricks = trl;
		north = n;
		northeast = ne;
		east = e;
		southeast = se;
		south = s;
		southwest = sw;
		west = w;
		northwest = nw;
		up = u;
		down = dn;
	}
	enum Direction {North, NorthEast, East, SouthEast, South, SouthWest, West,
	      NorthWest, Up, Down};
	inline ExitType Exit(Direction d)
	{
		switch (d)
		{
			case North: return north;
			case NorthEast: return northeast;
			case East: return east;
			case SouthEast: return southeast;
			case South: return south;
			case SouthWest: return southwest;
			case West: return west;
			case NorthWest: return northwest;
			case Up: return up;
			case Down: return down;
			default: return ExitType();
		}
	}
	inline void SetExit(Direction d,ExitType& e)
	{
		switch (d)
		{
			case North: north = e; break;
			case NorthEast: northeast = e; break;
			case East: east = e; break;
			case SouthEast: southeast = e; break;
			case South: south = e; break;
			case SouthWest: southwest = e; break;
			case West: west = e; break;
			case NorthWest: northwest = e; break;
			case Up: up = e; break;
			case Down: down = e; break;
		}
	}
	friend ostream& operator << (ostream& os, Space& sp);
	friend istream& operator >> (istream& is, Space& sp);
	int TclFunction(Tcl_Interp *interp, int argc, char *argv[]);
	int PSPut(ostream &os);
	int HTMLPut(ostream &os);
	int TEXTPut(ostream &os);
	int PSPutMap(ostream &os,Tcl_Interp* interp);
	void HandlizePointers(Tcl_Interp *interp);
};

class Game;

class Dungeon {
public:
	enum PrintType {text, html, postscript};
	String Name;
	String Comments;
	CharacterList *NPCList;
	MonsterList *MasterMonsterList;
	TrickList *MasterTrickList;
	TreasureList *MasterTreasureList;
	int Levels,XSize,YSize;
private:
	Space ****spaces;
	Tcl_HashTable treasures;
	bool treasuresht;
public:
	Space*& operator () (int l,int x,int y);
	Dungeon(String n,String c,int l, int x, int y);
	~Dungeon();
	int ReadFromFile(Tcl_Interp *interp,char *filename,
			 Tcl_HashTable **trtab = NULL);
	int WriteToFile(Tcl_Interp *interp,char *filename);
	int PrintToFile(Tcl_Interp *interp,char *filename,PrintType typ = text);
	int TclFunction(Tcl_Interp *interp,int argc, char *argv[]);
	friend class Game;
};

class Game {
public:
	enum PrintType {text, html, postscript};
	String DungeonHandle;
	String DungeonFile;
	String Notes;
	CharacterList *Players;
	int CurLevel,CurX,CurY;
	Game(String dh,String df,String n,int cl,int cx, int cy)
	{
		DungeonHandle = dh;
		DungeonFile = df;
		Notes = n;
		Players = NULL;
		CurLevel = cl;
		CurX = cx;
		CurY = cy;
	}
	~Game() {}
	int ReadFromFile(Tcl_Interp *interp,char *filename);
	int WriteToFile(Tcl_Interp *interp,char *filename);
	int PrintToFile(Tcl_Interp *interp,char *filename,PrintType typ = text);
	int TclFunction(Tcl_Interp *interp,int argc, char *argv[]);
};
 
extern int PointerToHandle(Tcl_Interp *interp,void_pt handles,void* pointer,char* result);
	
extern String& PSQuoteXnewline(String& source);

#endif // _MASTER_H_

