/*
 * ------------------------------------------------------------------
 * DressingLists.cc - Code for DressingLists
 * Created by Robert Heller on Sat Jun 17 23:36:29 1995
 * ------------------------------------------------------------------
 * Modification History: $Log: DressingLists.cc,v $
// Revision 1.2  1995/06/18  06:37:48  heller
// Add Handlize() method
//
// Revision 1.1  1995/06/18  03:50:39  heller
// Initial revision
//
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 *  
 *     Role Playing Database -- a program for maintaining a database
 *                              for RPG characters and monsters
 *     Copyright (C) 1995  Robert Heller D/B/A Deepwoods Software
 * 			51 Locke Hill Road
 * 			Wendell, MA 01379-9728
 * 
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *  
 */

static char rcsid[] = "$Id: DressingLists.cc,v 1.2 1995/06/18 06:37:48 heller Exp $";

#include <iostream.h>
#include <fstream.h>
#include <pfstream.h>
#include <strstream.h>
#include <Master.h>
#include <Monster.h>
#include <Character.h>
#include <tclExtend.h>
#include <tk.h>
#include <tkX.h>
#include <stdlib.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

ostream& operator << (ostream& os, DressingList& dl)
{
	os << dl.Name.length() << " " << dl.Name << " ";
	if (dl.Bitmap == "") os << "{}";
	else os << dl.Bitmap;
	os << " " << dl.Description.length() << " " << dl.Description << " ";
	os << dl.SpaceX << " " << dl.SpaceY << " " << dl.Value;
}

istream& operator >> (istream& is, DressingList& dl)
{
	int l;
	is >> l;
	is.get();
	dl.Name = "";
	while (l > 0)
	{
		dl.Name += is.get();
		l--;
	}
	is >> dl.Bitmap;
	if (dl.Bitmap == "{}") dl.Bitmap = "";
	is >> l;
	is.get();
	dl.Description = "";
	while (l > 0)
	{
		dl.Description += is.get();
		l--;
	}
	is >> dl.SpaceX >> dl.SpaceY >> dl.Value;
}

void_pt DressingList::Handles = NULL;

int DressingList::TclFunction(Tcl_Interp *interp, int argc, char *argv[])
{
	if (argc == 1)
	{
		// no option, echo slots
		Tcl_DString result;
		Tcl_DStringInit(&result);
		Tcl_DStringAppendElement(&result,"DressingList");

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Name");
		Tcl_DStringAppendElement(&result,(char*)Name);
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Bitmap");
		Tcl_DStringAppendElement(&result,(char*)Bitmap);
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Description");
		Tcl_DStringAppendElement(&result,(char*)Description);
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"NextDressing");
		if (NextDressing == NULL)
		{
			Tcl_DStringAppendElement(&result,"");
		} else
		{
			char temp[32];
			if (PointerToHandle(interp,DressingList::Handles,
					    NextDressing,temp) != TCL_OK)
				return TCL_ERROR;
			Tcl_DStringAppendElement(&result,temp);
		}
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"SpaceX");
		{
			ostrstream stream;
			stream << SpaceX;
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"SpaceY");
		{
			ostrstream stream;
			stream << SpaceY;
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Value");
		{
			ostrstream stream;
			stream << Value;
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		Tcl_DStringEndSublist(&result);

		Tcl_DStringResult(interp,&result);
		return TCL_OK;
	}
	if (strcmp(argv[1], "type") == 0)
	{
		if (argc != 2)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],(char *) NULL);
			return TCL_ERROR;
		}
		Tcl_AppendResult(interp, "DressingList", (char *) NULL);
		return TCL_OK;
	} else if (strcmp(argv[1], "name") == 0)
	{
		if (argc == 2)
		{
			Tcl_AppendResult(interp,(char*)Name,(char *) NULL);
			return TCL_OK;
		} else if (argc == 3)
		{
			Name = argv[2];
			Tcl_AppendResult(interp,(char*)Name,(char *) NULL);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "bitmap") == 0)
	{
		if (argc == 2)
		{
			Tcl_AppendResult(interp,(char*)Bitmap,(char *) NULL);
			return TCL_OK;
		} else if (argc == 3)
		{
			Bitmap = argv[2];
			Tcl_AppendResult(interp,(char*)Bitmap,(char *) NULL);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "description") == 0)
	{
		if (argc == 2)
		{
			Tcl_AppendResult(interp,(char*)Description,(char *) NULL);
			return TCL_OK;
		} else if (argc == 3)
		{
			Description = argv[2];
			Tcl_AppendResult(interp,(char*)Description,(char *) NULL);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "nextdressing") == 0)
	{
		if (argc == 3)
		{
			DressingList* nx = NULL;
			if (argv[2][0] != '\0')
			{
				void_pt ptr = Tcl_HandleXlate(interp,
					DressingList::Handles,argv[2]);
				if (ptr == NULL) return TCL_ERROR;
				nx = *((DressingList**) ptr);
			}
			NextDressing = nx;
		} else if (argc > 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		if (NextDressing == NULL)
		{
			interp->result = "";
			return TCL_OK;
		}
		char temp[32];
		if (PointerToHandle(interp,DressingList::Handles,NextDressing,
				    temp) != TCL_OK)
			return TCL_ERROR;
		Tcl_AppendResult(interp,temp,(char *) NULL);
		return TCL_OK;
	} else if (strcmp(argv[1], "spacex") == 0)
	{
		if (argc == 3)
		{
			if (Tcl_GetDouble(interp,argv[2],&SpaceX) != TCL_OK)
				return(TCL_ERROR);
		} else if (argc > 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		ostrstream stream;
		stream << SpaceX;
		_IO_ssize_t i = stream.pcount();
		char *s = stream.str();
		s[i] = '\0';
		Tcl_AppendResult(interp,s,(char *) NULL);
		stream.freeze(0);
		return TCL_OK;
	} else if (strcmp(argv[1], "spacey") == 0)
	{
		if (argc == 3)
		{
			if (Tcl_GetDouble(interp,argv[2],&SpaceY) != TCL_OK)
				return(TCL_ERROR);
		} else if (argc > 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		ostrstream stream;
		stream << SpaceY;
		_IO_ssize_t i = stream.pcount();
		char *s = stream.str();
		s[i] = '\0';
		Tcl_AppendResult(interp,s,(char *) NULL);
		stream.freeze(0);
		return TCL_OK;
	} else if (strcmp(argv[1], "value") == 0)
	{
		if (argc == 3)
		{
			int temp;
			if (Tcl_GetInt(interp,argv[2],&temp) != TCL_OK)
				return(TCL_ERROR);
			Value = temp;
		} else if (argc > 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		ostrstream stream;
		stream << Value;
		_IO_ssize_t i = stream.pcount();
		char *s = stream.str();
		s[i] = '\0';
		Tcl_AppendResult(interp,s,(char *) NULL);
		stream.freeze(0);
		return TCL_OK;
	} else if (strcmp(argv[1], "list") == 0)
	{
		if (argc != 2)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],"\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		Tcl_AppendElement(interp,argv[0]);
		for (DressingList* nx = NextDressing; nx != NULL;
		     nx = nx->NextDressing)
		{
			char temp[32];
			if (PointerToHandle(interp,DressingList::Handles,nx,
					    temp) != TCL_OK)
				return TCL_ERROR;
			Tcl_AppendElement(interp,temp);
		}
		return TCL_OK;
	} else if (strcmp(argv[1], "delete") == 0)
	{
		if (argc != 2)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],"\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		void_pt header = Tcl_HandleXlate (interp,DressingList::Handles,argv[0]);
		if (header == NULL) return TCL_ERROR;
		Tcl_HandleFree (DressingList::Handles,header);
		return Tcl_DeleteCommand(interp,argv[0]);
	} else
	{
		Tcl_AppendResult(interp, "Bad option: ",argv[1],(char *) NULL);
		return TCL_ERROR;
	}
}

static void deleteDressingList(ClientData clientData)
{
	register DressingList *cl = (DressingList*) clientData;
	delete cl;
}

static int dressingListCommand(ClientData clientData, Tcl_Interp *interp,
				int argc, char *argv[])
{
	register DressingList *cl = (DressingList*) clientData;
	return cl->TclFunction(interp,argc,argv);
}

static int dressingListCreate(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[])
{
	DressingList *cl;
	if (argc != 1 && argc != 8)
	{
		Tcl_AppendResult(interp, "Wrong # args: should be \"",
				 argv[0]," ?name bitmap description next x y value?\"",
				 (char*) NULL);
		return TCL_ERROR;
	}
	if (argc == 1)
	{
		cl = new DressingList;
	} else
	{
		int v;
		double x,y;
		DressingList *nx;
		/* argv[1] : Name */
		/* argv[2] : Bitmap */
		/* argv[3] : Description */
		/* argv[4] : NextDressing handle */
		if (argv[4][0] != '\0')
		{
			void_pt ptr = Tcl_HandleXlate(interp,
						      DressingList::Handles,
						      argv[4]);
			if (ptr == NULL) return TCL_ERROR;
			nx = *((DressingList**) ptr);
		} else nx = NULL;
		if (Tcl_GetDouble(interp,argv[5],&x) != TCL_OK)
			return TCL_ERROR;
		if (Tcl_GetDouble(interp,argv[6],&y) != TCL_OK)
			return TCL_ERROR;
		if (Tcl_GetInt(interp,argv[7],&v) != TCL_OK)
			return TCL_ERROR;
		cl = new DressingList(argv[1],argv[2],argv[3],nx,x,y,v);
	}
	char handle[32];
	DressingList **h = (DressingList **) Tcl_HandleAlloc (DressingList::Handles,handle);
	*h = cl;
	Tcl_CreateCommand(interp,handle,(Tcl_CmdProc*)dressingListCommand,
			  (ClientData)cl,
			  (Tcl_CmdDeleteProc*)deleteDressingList);
	Tcl_AppendResult(interp,handle,(char *) NULL);
	return TCL_OK;
}

int DressingList::Handlize(Tcl_Interp *interp)
{
	char handle[32];
	DressingList **tl = (DressingList **)
		Tcl_HandleAlloc (DressingList::Handles,handle);
	*tl = this;
	Tcl_CreateCommand(interp,handle,(Tcl_CmdProc*)dressingListCommand,
			  this,(Tcl_CmdDeleteProc*)deleteDressingList);
	Tcl_AppendResult(interp,handle,(char *) NULL);
	return TCL_OK;
}

static int allDressingLists(ClientData clientData, Tcl_Interp *interp,int argc, char *argv[])
{
	int walk;
	walk = -1;
	while (Tcl_HandleWalk(DressingList::Handles,&walk) != NULL)
	{
		char handle[32];
		Tcl_WalkKeyToHandle(DressingList::Handles,walk,handle);
		Tcl_AppendElement(interp,handle);
	}
	return TCL_OK;

}



int DressingList_Init(Tcl_Interp *interp)
{
	DressingList::Handles = Tcl_HandleTblInit("DressingList",sizeof(DressingList*),256);
	Tcl_CreateCommand(interp, "DressingList", (Tcl_CmdProc*)dressingListCreate,
			  (ClientData) NULL, (Tcl_CmdDeleteProc*) NULL);
	Tcl_CreateCommand(interp, "AllDressingLists", (Tcl_CmdProc*)allDressingLists,
			  (ClientData) NULL, (Tcl_CmdDeleteProc*) NULL);
	return TCL_OK;
}

int DressingList::PSPut(ostream &os)
{
	os << "(" << PSQuote(Name) << ") putstr" << endl;
	if (Bitmap != NULL)
	{
		os << "( {" << Bitmap << "}) showline" << endl;
	} else	os << "newline" << endl;
	os << "(" << PSQuoteXnewline(Description) << ") CommentsParagraph"
	   << endl;
	os << "1 inch indent (at \\(" << SpaceX << "," << SpaceY << "\\) "
	   << Value << ") showline" << endl;
	if (!os) return 0;
	else return 1;
}

int DressingList::HTMLPut(ostream &os)
{
	os << Name;
	if (Bitmap != NULL)
	{
		os << " {" << Bitmap << "} <br>" << endl;
	} else	os << "<br>" << endl;
	os << "<p>" << endl;
	os << Description << endl;
	os << "</p>" << endl;
	os << "at (" << SpaceX << "," << SpaceY << ") "
	   << Value << "<br>" << endl;
	if (!os) return 0;
	else return 1;
}

int DressingList::TEXTPut(ostream &os)
{
	os << Name;
	if (Bitmap != NULL)
	{
		os << " {" << Bitmap << "}" << endl;
	} else	os << endl;
	os << Description << endl;
	os << "at (" << SpaceX << "," << SpaceY << ") "
	   << Value << endl;
	if (!os) return 0;
	else return 1;
}


