/*
 * ------------------------------------------------------------------
 * CharacterLists.cc - Code for CharacterLists and EncumbrenceLists
 * Created by Robert Heller on Sat Jun 17 23:24:27 1995
 * ------------------------------------------------------------------
 * Modification History: $Log: CharacterLists.cc,v $
// Revision 1.3  1995/07/02  02:09:50  heller
// Add in EncumbrenceList::Handlize()
// and use it in FixUpEncumbrenceLists()
//
// Revision 1.2  1995/06/18  04:53:23  heller
// fix static member decl. problem
//
// Revision 1.1  1995/06/18  03:50:39  heller
// Initial revision
//
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 *  
 *     Role Playing Database -- a program for maintaining a database
 *                              for RPG characters and monsters
 *     Copyright (C) 1995  Robert Heller D/B/A Deepwoods Software
 * 			51 Locke Hill Road
 * 			Wendell, MA 01379-9728
 * 
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *  
 */

static char rcsid[] = "$Id: CharacterLists.cc,v 1.3 1995/07/02 02:09:50 heller Exp $";

#include <iostream.h>
#include <fstream.h>
#include <pfstream.h>
#include <strstream.h>
#include <Master.h>
#include <Monster.h>
#include <Character.h>
#include <tclExtend.h>
#include <tk.h>
#include <tkX.h>
#include <stdlib.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

void_pt CharacterList::Handles = NULL;
void_pt EncumbrenceList::Handles = NULL;

ostream& operator << (ostream& os, CharacterList& cl)
{
	if (cl.Handle == "") os << "{}";
	else os << cl.Handle;
	os << " ";
	if (cl.File == "") os << "{}";
	else os << cl.File;
	os << " ";
	if (cl.Bitmap == "") os << "{}";
	else os << cl.Bitmap;
	os << " "
	   << cl.MarchX<< " " << cl.MarchY << " " << cl.HitPoints << " ";
	os << "{";
	for (EncumbrenceList *el = cl.Encumbrences; el != NULL; el = el->NextEncumbrence)
	{
		os << *el;
		if (el->NextEncumbrence != NULL) os << " ";
	}
	os << "}";
}


istream& operator >> (istream& is, CharacterList& cl)
{
	is >> cl.Handle;
	if (cl.Handle == "{}") cl.Handle = "";
	is >> cl.File;
	if (cl.File == "{}") cl.File = "";
	is >> cl.Bitmap;
	if (cl.Bitmap == "{}") cl.Bitmap = "";
	is >> cl.MarchX;
	is >> cl.MarchY;
	is >> cl.HitPoints;
	char ch;
	do {
		ch = is.get();
	} while (ch != '{');
	EncumbrenceList *el,**slot;
	cl.Encumbrences = NULL;
	slot = &cl.Encumbrences;
	while (is.peek() != '}')
	{
		el = new EncumbrenceList;
		is >> *el;
		*slot = el;
		slot = &el->NextEncumbrence;
	}
	is.get();
}


int CharacterList::TclFunction(Tcl_Interp *interp, int argc, char *argv[])
{
	if (argc == 1)
	{
		// no option, echo slots
		Tcl_DString result;
		Tcl_DStringInit(&result);
		Tcl_DStringAppendElement(&result,"CharacterList");

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Handle");
		Tcl_DStringAppendElement(&result,(char*)Handle);
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"File");
		Tcl_DStringAppendElement(&result,(char*)File);
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Bitmap");
		Tcl_DStringAppendElement(&result,(char*)Bitmap);
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"NextCharacter");
		if (NextCharacter == NULL)
		{
			Tcl_DStringAppendElement(&result,"");
		} else
		{
			char temp[32];
			if (PointerToHandle(interp,CharacterList::Handles,
			    NextCharacter,temp) != TCL_OK)
				return TCL_ERROR;
			Tcl_DStringAppendElement(&result,temp);
		}
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"MarchX");
		{
			ostrstream stream;
			stream << MarchX;
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"MarchY");
		{
			ostrstream stream;
			stream << MarchY;
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Encumbrences");
		if (Encumbrences == NULL)
		{
			Tcl_DStringAppendElement(&result,"");
		} else
		{
			char temp[32];
			if (PointerToHandle(interp,EncumbrenceList::Handles,
					    Encumbrences,temp) != TCL_OK)
				return TCL_ERROR;
			Tcl_DStringAppendElement(&result,temp);
		}
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"HitPoints");
		{
			ostrstream stream;
			stream << HitPoints;
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		Tcl_DStringEndSublist(&result);

		Tcl_DStringResult(interp,&result);
		return TCL_OK;
	}
	if (strcmp(argv[1], "type") == 0)
	{
		if (argc != 2)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],(char *) NULL);
			return TCL_ERROR;
		}
		Tcl_AppendResult(interp, "CharacterList", (char *) NULL);
		return TCL_OK;
	} else if (strcmp(argv[1], "handle") == 0)
	{
		if (argc == 2)
		{
			Tcl_AppendResult(interp,(char*)Handle,(char *) NULL);
			return TCL_OK;
		} else if (argc == 3)
		{
			Handle = argv[2];
			Tcl_AppendResult(interp,(char*)Handle,(char *) NULL);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "file") == 0)
	{
		if (argc == 2)
		{
			Tcl_AppendResult(interp,(char*)File,(char *) NULL);
			return TCL_OK;
		} else if (argc == 3)
		{
			File = argv[2];
			Tcl_AppendResult(interp,(char*)File,(char *) NULL);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "bitmap") == 0)
	{
		if (argc == 2)
		{
			Tcl_AppendResult(interp,(char*)Bitmap,(char *) NULL);
			return TCL_OK;
		} else if (argc == 3)
		{
			Bitmap = argv[2];
			Tcl_AppendResult(interp,(char*)Bitmap,(char *) NULL);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "nextcharacter") == 0)
	{
		if (argc == 3)
		{
			CharacterList* nx = NULL;
			if (argv[2][0] != '\0')
			{
				void_pt ptr = Tcl_HandleXlate(interp,
					CharacterList::Handles,argv[2]);
				if (ptr == NULL) return TCL_ERROR;
				nx = *((CharacterList**) ptr);
			}
			NextCharacter = nx;
		} else if (argc > 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		if (NextCharacter == NULL)
		{
			interp->result = "";
			return TCL_OK;
		}
		char temp[32];
		if (PointerToHandle(interp,CharacterList::Handles,NextCharacter,
				    temp) != TCL_OK)
			return TCL_ERROR;
		Tcl_AppendResult(interp,temp,(char *) NULL);
		return TCL_OK;
	} else if (strcmp(argv[1], "list") == 0)
	{
		if (argc != 2)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],"\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		Tcl_AppendElement(interp,argv[0]);
		for (CharacterList* nx = NextCharacter; nx != NULL;
		     nx = nx->NextCharacter)
		{
			char temp[32];
			if (PointerToHandle(interp,CharacterList::Handles,nx,
					    temp) != TCL_OK)
				return TCL_ERROR;
			Tcl_AppendElement(interp,temp);
		}
		return TCL_OK;
	} else if (strcmp(argv[1], "marchx") == 0)
	{
		if (argc == 3)
		{
			if (Tcl_GetDouble(interp,argv[2],&MarchX) != TCL_OK)
				return(TCL_ERROR);
		} else if (argc > 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		ostrstream stream;
		stream << MarchX;
		_IO_ssize_t i = stream.pcount();
		char *s = stream.str();
		s[i] = '\0';
		Tcl_AppendResult(interp,s,(char *) NULL);
		stream.freeze(0);
		return TCL_OK;
	} else if (strcmp(argv[1], "marchy") == 0)
	{
		if (argc == 3)
		{
			if (Tcl_GetDouble(interp,argv[2],&MarchY) != TCL_OK)
				return(TCL_ERROR);
		} else if (argc > 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		ostrstream stream;
		stream << MarchY;
		_IO_ssize_t i = stream.pcount();
		char *s = stream.str();
		s[i] = '\0';
		Tcl_AppendResult(interp,s,(char *) NULL);
		stream.freeze(0);
		return TCL_OK;
	} else if (strcmp(argv[1], "encumbrences") == 0)
	{
		if (argc == 3)
		{
			EncumbrenceList *e = NULL;
			if (argv[2][0] != '\0')
			{
				void_pt ptr =
					Tcl_HandleXlate(interp,
							EncumbrenceList::Handles,
							argv[2]);
				if (ptr == NULL) return TCL_ERROR;
				e = *((EncumbrenceList**) ptr);
			}
			Encumbrences = e;
		} else if (argc > 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		if (Encumbrences == NULL)
		{
			interp->result = "";
			return TCL_OK;
		}
		char temp[32];
		if (PointerToHandle(interp,EncumbrenceList::Handles,
				    Encumbrences,temp) != TCL_OK)
			return TCL_ERROR;
		Tcl_AppendResult(interp,temp,(char *) NULL);
		return TCL_OK;
	} else if (strcmp(argv[1], "hitpoints") == 0)
	{
		if (argc == 3)
		{
			int temp;
			if (Tcl_GetInt(interp,argv[2],&temp) != TCL_OK)
				return(TCL_ERROR);
			HitPoints = temp;
		} else if (argc > 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		ostrstream stream;
		stream << HitPoints;
		_IO_ssize_t i = stream.pcount();
		char *s = stream.str();
		s[i] = '\0';
		Tcl_AppendResult(interp,s,(char *) NULL);
		stream.freeze(0);
		return TCL_OK;
	} else if (strcmp(argv[1], "delete") == 0)
	{
		if (argc != 2)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],"\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		void_pt header = Tcl_HandleXlate (interp,CharacterList::Handles,argv[0]);
		if (header == NULL) return TCL_ERROR;
		Tcl_HandleFree (CharacterList::Handles,header);
		return Tcl_DeleteCommand(interp,argv[0]);
	} else
	{
		Tcl_AppendResult(interp, "Bad option: ",argv[1],(char *) NULL);
		return TCL_ERROR;
	}
}

static void deleteCharacterList(ClientData clientData)
{
	register CharacterList *cl = (CharacterList*) clientData;
	delete cl;
}

static int characterListCommand(ClientData clientData, Tcl_Interp *interp,
				int argc, char *argv[])
{
	register CharacterList *cl = (CharacterList*) clientData;
	return cl->TclFunction(interp,argc,argv);
}

static int characterListCreate(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[])
{
	CharacterList *cl;
	if (argc != 1 && argc != 9)
	{
		Tcl_AppendResult(interp, "Wrong # args: should be \"",
				 argv[0]," ?handle file bitmap next x y encumb hp?\"",
				 (char*) NULL);
		return TCL_ERROR;
	}
	if (argc == 1)
	{
		cl = new CharacterList;
	} else
	{
		int hp;
		double x,y;
		CharacterList *nx;
		EncumbrenceList *e;
		/* argv[1] : Handle */
		/* argv[2] : File */
		/* argv[3] : Bitmap */
		/* argv[4] : NextCharacter handle */
		if (argv[4][0] != '\0')
		{
			void_pt ptr = Tcl_HandleXlate(interp,
						      CharacterList::Handles,
						      argv[4]);
			if (ptr == NULL) return TCL_ERROR;
			nx = *((CharacterList**) ptr);
		} else nx = NULL;
		if (Tcl_GetDouble(interp,argv[5],&x) != TCL_OK)
			return TCL_ERROR;
		if (Tcl_GetDouble(interp,argv[6],&y) != TCL_OK)
			return TCL_ERROR;
		/* argv[7] : Encumbrences */
		if (argv[7][0] != '\0')
		{
			void_pt ptr = Tcl_HandleXlate(interp,
						      EncumbrenceList::Handles,
						      argv[7]);
			if (ptr == NULL) return TCL_ERROR;
			e = *((EncumbrenceList**) ptr);
		} else e = NULL;
		if (Tcl_GetInt(interp,argv[8],&hp) != TCL_OK)
			return TCL_ERROR;
		cl = new CharacterList(argv[1],argv[2],argv[3],nx,x,y,e,hp);
	}
	char handle[32];
	CharacterList **h = (CharacterList **) Tcl_HandleAlloc (CharacterList::Handles,handle);
	*h = cl;
	Tcl_CreateCommand(interp,handle,(Tcl_CmdProc*)characterListCommand,
			  (ClientData)cl,
			  (Tcl_CmdDeleteProc*)deleteCharacterList);
	Tcl_AppendResult(interp,handle,(char *) NULL);
	return TCL_OK;
}

static int allCharacterLists(ClientData clientData, Tcl_Interp *interp,int argc, char *argv[])
{
	int walk;
	walk = -1;
	while (Tcl_HandleWalk(CharacterList::Handles,&walk) != NULL)
	{
		char handle[32];
		Tcl_WalkKeyToHandle(CharacterList::Handles,walk,handle);
		Tcl_AppendElement(interp,handle);
	}
	return TCL_OK;

}



int CharacterList_Init(Tcl_Interp *interp)
{
	CharacterList::Handles = Tcl_HandleTblInit("CharacterList",sizeof(CharacterList*),256);
	Tcl_CreateCommand(interp, "CharacterList", (Tcl_CmdProc*)characterListCreate,
			  (ClientData) NULL, (Tcl_CmdDeleteProc*) NULL);
	Tcl_CreateCommand(interp, "AllCharacterLists", (Tcl_CmdProc*)allCharacterLists,
			  (ClientData) NULL, (Tcl_CmdDeleteProc*) NULL);
	return TCL_OK;
}

int CharacterList::PSPut(ostream &os)
{
	if (Handle != "")
	{
		os << "(Handle: " << Handle << ") showline" << endl;
	}
	if (File != "")
	{
		os << "(File: " << File << ") showline" << endl;
	}
	if (Bitmap != "")
	{
		os << "(Bitmap: " << Bitmap << ") showline" << endl;
	}
	os << "(Marching at \\(" << MarchX << "," << MarchY
	   << "\\), Hitpoints: " << HitPoints << ") showline" << endl;
	for (EncumbrenceList *el = Encumbrences; el != NULL; el = el->NextEncumbrence)
	{
		el->PSPut(os);
	}
	if (!os) return 0;
	else return 1;
}

int CharacterList::HTMLPut(ostream &os)
{
	if (Handle != "")
	{
		os << "Handle: " << Handle << "<br>" << endl;
	}
	if (File != "")
	{
		os << "File: " << File << "<br>" << endl;
	}
	if (Bitmap != "")
	{
		os << "Bitmap: " << Bitmap << "<br>" << endl;
	}
	os << "Marching at (" << MarchX << "," << MarchY
	   << "), Hitpoints: " << HitPoints << "<br>" << endl;
	for (EncumbrenceList *el = Encumbrences; el != NULL; el = el->NextEncumbrence)
	{
		el->HTMLPut(os);
	}
	if (!os) return 0;
	else return 1;
}

int CharacterList::TEXTPut(ostream &os)
{
	if (Handle != "")
	{
		os << "Handle: " << Handle << endl;
	}
	if (File != "")
	{
		os << "File: " << File << endl;
	}
	if (Bitmap != "")
	{
		os << "Bitmap: " << Bitmap << endl;
	}
	os << "Marching at (" << MarchX << "," << MarchY
	   << "), Hitpoints: " << HitPoints << endl;
	for (EncumbrenceList *el = Encumbrences; el != NULL; el = el->NextEncumbrence)
	{
		el->TEXTPut(os);
	}
	if (!os) return 0;
	else return 1;
}

int CharacterList::PSPut(ostream &os,Tcl_Interp* interp)
{
	if (Handle != "")
	{
		os << "(Handle: " << Handle;
		void_pt ptr = Tcl_HandleXlate(interp,Character::Handles,
					      (char*)Handle);
		if (ptr != NULL)
		{
			Character *ch = *((Character**)ptr);
			os << " \\(" << PSQuote(ch->Name) << "\\)";
		}
		os << ") showline" << endl;
	}
	if (File != "")
	{
		os << "(File: " << File << ") showline" << endl;
	}
	if (Bitmap != "")
	{
		os << "(Bitmap: " << Bitmap << ") showline" << endl;
	}
	os << "(Marching at \\(" << MarchX << "," << MarchY
	   << "\\), Hitpoints: " << HitPoints << ") showline" << endl;
	for (EncumbrenceList *el = Encumbrences; el != NULL; el = el->NextEncumbrence)
	{
		el->PSPut(os);
	}
	if (!os) return 0;
	else return 1;
}

int CharacterList::HTMLPut(ostream &os,Tcl_Interp* interp)
{
	if (Handle != "")
	{
		os << "Handle: " << Handle;
		void_pt ptr = Tcl_HandleXlate(interp,Character::Handles,
					      (char*)Handle);
		if (ptr != NULL)
		{
			Character *ch = *((Character**)ptr);
			os << " (" << ch->Name << ")";
		}
		os << "<br>" << endl;
	}
	if (File != "")
	{
		os << "File: " << File << "<br>" << endl;
	}
	if (Bitmap != "")
	{
		os << "Bitmap: " << Bitmap << "<br>" << endl;
	}
	os << "Marching at (" << MarchX << "," << MarchY
	   << "), Hitpoints: " << HitPoints << "<br>" << endl;
	for (EncumbrenceList *el = Encumbrences; el != NULL; el = el->NextEncumbrence)
	{
		el->HTMLPut(os);
	}
	if (!os) return 0;
	else return 1;
}

int CharacterList::TEXTPut(ostream &os,Tcl_Interp* interp)
{
	if (Handle != "")
	{
		os << "Handle: " << Handle;
		void_pt ptr = Tcl_HandleXlate(interp,Character::Handles,
					      (char*)Handle);
		if (ptr != NULL)
		{
			Character *ch = *((Character**)ptr);
			os << " (" << ch->Name << ")";
		}
		os << endl;
	}
	if (File != "")
	{
		os << "File: " << File << endl;
	}
	if (Bitmap != "")
	{
		os << "Bitmap: " << Bitmap << endl;
	}
	os << "Marching at (" << MarchX << "," << MarchY
	   << "), Hitpoints: " << HitPoints << endl;
	for (EncumbrenceList *el = Encumbrences; el != NULL; el = el->NextEncumbrence)
	{
		el->TEXTPut(os);
	}
	if (!os) return 0;
	else return 1;
}

ostream& operator << (ostream& os, EncumbrenceList& el)
{
	os << el.Name.length() << " " << el.Name << " ";
	if (el.Handle == "") os << "{}";
	else os << el.Handle;
	os << " " << el.Description.length() << " " << el.Description << " ";
	os << el.Weight << " " << el.ACAdj << " " << el.ToHitAdj << " "
	   << el.DamAdj << " " << el.MagResAdj << " " << el.DamProtAdj << " ";
	os << el.AbilityAdjs.s << " " << el.AbilityAdjs.i << " "
	   << el.AbilityAdjs.w << " " << el.AbilityAdjs.d << " " 
	   << el.AbilityAdjs.c << " " << el.AbilityAdjs.ch << " ";
	os << el.MoveAdj.g << " " << el.MoveAdj.f << " " << el.MoveAdj.s << " ";
	os << el.Value;
}


istream& operator >> (istream& is, EncumbrenceList& el)
{
	int l;
	is >> l;
	is.get();
	el.Name = "";
	while (l > 0)
	{
		el.Name += is.get();
		l--;
	}
	is >> el.Handle;
	if (el.Handle == "{}") el.Handle = "";
	is >> l;
	is.get();
	el.Description = "";
	while (l > 0)
	{
		el.Description += is.get();
		l--;
	}
	is >> el.Weight >> el.ACAdj >> el.ToHitAdj >> el.DamAdj
	   >> el.MagResAdj >> el.DamProtAdj >> el.AbilityAdjs.s 
	   >> el.AbilityAdjs.i >> el.AbilityAdjs.w >> el.AbilityAdjs.d 
	   >> el.AbilityAdjs.c >> el.AbilityAdjs.ch >> el.MoveAdj.g
	   >> el.MoveAdj.f >> el.MoveAdj.s >> el.Value;
}


int EncumbrenceList::TclFunction(Tcl_Interp *interp, int argc, char *argv[])
{
	if (argc == 1)
	{
		// no option, echo slots
		Tcl_DString result;
		Tcl_DStringInit(&result);
		Tcl_DStringAppendElement(&result,"EncumbrenceList");

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Name");
		Tcl_DStringAppendElement(&result,(char*)Name);
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Handle");
		Tcl_DStringAppendElement(&result,(char*)Handle);
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Description");
		Tcl_DStringAppendElement(&result,(char*)Description);
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Weight");
		{
			ostrstream stream;
			stream << Weight;
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"ACAdj");
		{
			ostrstream stream;
			stream << ACAdj;
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"ToHitAdj");
		{
			ostrstream stream;
			stream << ToHitAdj;
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"DamAdj");
		{
			ostrstream stream;
			stream << DamAdj;
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"MagResAdj");
		{
			ostrstream stream;
			stream << MagResAdj;
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"DamProtAdj");
		{
			ostrstream stream;
			stream << DamProtAdj;
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"AbilityAdjs");
		{
			ostrstream stream;
			stream << AbilityAdjs.s;
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		{
			ostrstream stream;
			stream << AbilityAdjs.i;
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		{
			ostrstream stream;
			stream << AbilityAdjs.w;
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		{
			ostrstream stream;
			stream << AbilityAdjs.d;
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		{
			ostrstream stream;
			stream << AbilityAdjs.c;
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		{
			ostrstream stream;
			stream << AbilityAdjs.ch;
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"MoveAdj");
		{
			ostrstream stream;
			stream << MoveAdj.g;
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		{
			ostrstream stream;
			stream << MoveAdj.f;
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		{
			ostrstream stream;
			stream << MoveAdj.s;
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Value");
		{
			ostrstream stream;
			stream << Value;
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"NextEncumbrence");
		if (NextEncumbrence == NULL)
		{
			Tcl_DStringAppendElement(&result,"");
		} else
		{
			char temp[32];
			if (PointerToHandle(interp,EncumbrenceList::Handles,
					    NextEncumbrence,temp) != TCL_OK)
				return TCL_ERROR;
			Tcl_DStringAppendElement(&result,temp);
		}
		Tcl_DStringEndSublist(&result);

		Tcl_DStringResult(interp,&result);
		return TCL_OK;
	}
	if (strcmp(argv[1], "type") == 0)
	{
		if (argc != 2)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],(char *) NULL);
			return TCL_ERROR;
		}
		Tcl_AppendResult(interp, "EncumbrenceList", (char *) NULL);
		return TCL_OK;
	} else if (strcmp(argv[1], "name") == 0)
	{
		if (argc == 2)
		{
			Tcl_AppendResult(interp,(char*)Name,(char *) NULL);
			return TCL_OK;
		} else if (argc == 3)
		{
			Name = argv[2];
			Tcl_AppendResult(interp,(char*)Name,(char *) NULL);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}

	} else if (strcmp(argv[1], "handle") == 0)
	{
		if (argc == 2)
		{
			Tcl_AppendResult(interp,(char*)Handle,(char *) NULL);
			return TCL_OK;
		} else if (argc == 3)
		{
			Handle = argv[2];
			Tcl_AppendResult(interp,(char*)Handle,(char *) NULL);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}

	} else if (strcmp(argv[1], "description") == 0)
	{
		if (argc == 2)
		{
			Tcl_AppendResult(interp,(char*)Description,(char *) NULL);
			return TCL_OK;
		} else if (argc == 3)
		{
			Description = argv[2];
			Tcl_AppendResult(interp,(char*)Description,(char *) NULL);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "weight") == 0)
	{
		if (argc == 3)
		{
			if (Tcl_GetInt(interp,argv[2],&Weight) != TCL_OK)
				return(TCL_ERROR);
		} else if (argc > 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		ostrstream stream;
		stream << Weight;
		_IO_ssize_t i = stream.pcount();
		char *s = stream.str();
		s[i] = '\0';
		Tcl_AppendResult(interp,s,(char *) NULL);
		stream.freeze(0);
		return TCL_OK;
	} else if (strcmp(argv[1], "acadj") == 0)
	{
		if (argc == 3)
		{
			if (Tcl_GetInt(interp,argv[2],&ACAdj) != TCL_OK)
				return(TCL_ERROR);
		} else if (argc > 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		ostrstream stream;
		stream << ACAdj;
		_IO_ssize_t i = stream.pcount();
		char *s = stream.str();
		s[i] = '\0';
		Tcl_AppendResult(interp,s,(char *) NULL);
		stream.freeze(0);
		return TCL_OK;
	} else if (strcmp(argv[1], "tohitadj") == 0)
	{
		if (argc == 3)
		{
			if (Tcl_GetInt(interp,argv[2],&ToHitAdj) != TCL_OK)
				return(TCL_ERROR);
		} else if (argc > 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		ostrstream stream;
		stream << ToHitAdj;
		_IO_ssize_t i = stream.pcount();
		char *s = stream.str();
		s[i] = '\0';
		Tcl_AppendResult(interp,s,(char *) NULL);
		stream.freeze(0);
		return TCL_OK;
	} else if (strcmp(argv[1], "damadj") == 0)
	{
		if (argc == 3)
		{
			if (Tcl_GetInt(interp,argv[2],&DamAdj) != TCL_OK)
				return(TCL_ERROR);
		} else if (argc > 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		ostrstream stream;
		stream << DamAdj;
		_IO_ssize_t i = stream.pcount();
		char *s = stream.str();
		s[i] = '\0';
		Tcl_AppendResult(interp,s,(char *) NULL);
		stream.freeze(0);
		return TCL_OK;
	} else if (strcmp(argv[1], "magresadj") == 0)
	{
		if (argc == 3)
		{
			if (Tcl_GetInt(interp,argv[2],&MagResAdj) != TCL_OK)
				return(TCL_ERROR);
		} else if (argc > 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		ostrstream stream;
		stream << MagResAdj;
		_IO_ssize_t i = stream.pcount();
		char *s = stream.str();
		s[i] = '\0';
		Tcl_AppendResult(interp,s,(char *) NULL);
		stream.freeze(0);
		return TCL_OK;
	} else if (strcmp(argv[1], "damprotadj") == 0)
	{
		if (argc == 3)
		{
			if (Tcl_GetInt(interp,argv[2],&DamProtAdj) != TCL_OK)
				return(TCL_ERROR);
		} else if (argc > 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		ostrstream stream;
		stream << DamProtAdj;
		_IO_ssize_t i = stream.pcount();
		char *s = stream.str();
		s[i] = '\0';
		Tcl_AppendResult(interp,s,(char *) NULL);
		stream.freeze(0);
		return TCL_OK;
	} else if (strcmp(argv[1], "abilityadjs") == 0)
	{
		if (argc == 3)
		{
			int xargc;
			char **xargv;
			if (Tcl_SplitList(interp, argv[3], &xargc, &xargv) != TCL_OK)
				return(TCL_ERROR);
			if (xargc != 6)
			{
				Tcl_AppendResult(interp, "Bad abilityadjs: ",
						 argv[3],"should be a list of six ints",
						 (char*) NULL);
				return(TCL_ERROR);
			}
			if (Tcl_GetInt(interp,xargv[0],&AbilityAdjs.s) != TCL_OK)
				return(TCL_ERROR);
			if (Tcl_GetInt(interp,xargv[1],&AbilityAdjs.i) != TCL_OK)
				return(TCL_ERROR);
			if (Tcl_GetInt(interp,xargv[2],&AbilityAdjs.w) != TCL_OK)
				return(TCL_ERROR);
			if (Tcl_GetInt(interp,xargv[3],&AbilityAdjs.d) != TCL_OK)
				return(TCL_ERROR);
			if (Tcl_GetInt(interp,xargv[4],&AbilityAdjs.c) != TCL_OK)
				return(TCL_ERROR);
			if (Tcl_GetInt(interp,xargv[5],&AbilityAdjs.ch) != TCL_OK)
				return(TCL_ERROR);
			free(xargv);
		} else if (argc > 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		{
			ostrstream stream;
			stream << AbilityAdjs.s;
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_AppendElement(interp,s);
			stream.freeze(0);
		}
		{
			ostrstream stream;
			stream << AbilityAdjs.i;
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_AppendElement(interp,s);
			stream.freeze(0);
		}
		{
			ostrstream stream;
			stream << AbilityAdjs.w;
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_AppendElement(interp,s);
			stream.freeze(0);
		}
		{
			ostrstream stream;
			stream << AbilityAdjs.d;
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_AppendElement(interp,s);
			stream.freeze(0);
		}
		{
			ostrstream stream;
			stream << AbilityAdjs.c;
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_AppendElement(interp,s);
			stream.freeze(0);
		}
		{
			ostrstream stream;
			stream << AbilityAdjs.ch;
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_AppendElement(interp,s);
			stream.freeze(0);
		}
		return TCL_OK;
	} else if (strcmp(argv[1], "moveadj") == 0)
	{
		if (argc == 3)
		{
			int xargc;
			char **xargv;
			if (Tcl_SplitList(interp, argv[3], &xargc, &xargv) != TCL_OK)
				return(TCL_ERROR);
			if (xargc != 3)
			{
				Tcl_AppendResult(interp, "Bad moveadj: ",
				argv[3],"should be either a list of three ints",
						 (char*) NULL);
				return(TCL_ERROR);
			}
			if (Tcl_GetInt(interp,xargv[0],&MoveAdj.g) != TCL_OK)
				return(TCL_ERROR);
			if (Tcl_GetInt(interp,xargv[1],&MoveAdj.f) != TCL_OK)
				return(TCL_ERROR);
			if (Tcl_GetInt(interp,xargv[2],&MoveAdj.s) != TCL_OK)
				return(TCL_ERROR);
			free(xargv);
		} else if (argc > 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		{
			ostrstream stream;
			stream << MoveAdj.g;
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_AppendElement(interp,s);
			stream.freeze(0);
		}
		{
			ostrstream stream;
			stream << MoveAdj.f;
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_AppendElement(interp,s);
			stream.freeze(0);
		}
		{
			ostrstream stream;
			stream << MoveAdj.s;
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_AppendElement(interp,s);
			stream.freeze(0);
		}
		return TCL_OK;
	} else if (strcmp(argv[1], "value") == 0)
	{
		if (argc == 3)
		{
			if (Tcl_GetInt(interp,argv[2],&Value) != TCL_OK)
				return(TCL_ERROR);
		} else if (argc > 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		ostrstream stream;
		stream << Value;
		_IO_ssize_t i = stream.pcount();
		char *s = stream.str();
		s[i] = '\0';
		Tcl_AppendResult(interp,s,(char *) NULL);
		stream.freeze(0);
		return TCL_OK;
	} else if (strcmp(argv[1], "nextencumbrence") == 0)
	{
		if (argc == 3)
		{
			EncumbrenceList *e = NULL;
			if (argv[2][0] != '\0')
			{
				void_pt ptr =
					Tcl_HandleXlate(interp,
							EncumbrenceList::Handles,
							argv[2]);
				if (ptr == NULL) return TCL_ERROR;
				e = *((EncumbrenceList**) ptr);
			}
			NextEncumbrence = e;
		} else if (argc > 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		if (NextEncumbrence == NULL)
		{
			interp->result = "";
			return TCL_OK;
		}
		char temp[32];
		if (PointerToHandle(interp,EncumbrenceList::Handles,
				    NextEncumbrence,temp) != TCL_OK)
			return TCL_ERROR;
		Tcl_AppendResult(interp,temp,(char *) NULL);
		return TCL_OK;
	} else if (strcmp(argv[1], "list") == 0)
	{
		if (argc != 2)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],"\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		Tcl_AppendElement(interp,argv[0]);
		for (EncumbrenceList* nx = NextEncumbrence; nx != NULL;
		     nx = nx->NextEncumbrence)
		{
			char temp[32];
			if (PointerToHandle(interp,EncumbrenceList::Handles,nx,
					    temp) != TCL_OK)
				return TCL_ERROR;
			Tcl_AppendElement(interp,temp);
		}
		return TCL_OK;
	} else if (strcmp(argv[1], "delete") == 0)
	{
		if (argc != 2)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],"\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		void_pt header = Tcl_HandleXlate (interp,EncumbrenceList::Handles,argv[0]);
		if (header == NULL) return TCL_ERROR;
		Tcl_HandleFree (EncumbrenceList::Handles,header);
		return Tcl_DeleteCommand(interp,argv[0]);
	} else
	{
		Tcl_AppendResult(interp, "Bad option: ",argv[1],(char *) NULL);
		return TCL_ERROR;
	}
}

static void deleteEncumbrenceList(ClientData clientData)
{
	register EncumbrenceList *el = (EncumbrenceList*) clientData;
	delete el;
}

static int encumbrenceListCommand(ClientData clientData, Tcl_Interp *interp,
				int argc, char *argv[])
{
	register EncumbrenceList *el = (EncumbrenceList*) clientData;
	return el->TclFunction(interp,argc,argv);
}

static int encumbrenceListCreate(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[])
{
	EncumbrenceList *el;
	if (argc != 1 && argc != 14)
	{
		Tcl_AppendResult(interp, "Wrong # args: should be \"",
				 argv[0]," ?name handle description weight",
				 " acadj tohitadj damadj magresadj damprotadj",
				 " abilityadjs moveadj value nextencumbrence?\"",
				 (char*) NULL);
		return TCL_ERROR;
	}
	if (argc == 1)
	{
		el = new EncumbrenceList;
	} else
	{
		int weight, acadj, tohitadj, damadj, magresadj, damprotadj,
		    abilityadjs_s, abilityadjs_i, abilityadjs_w, abilityadjs_d,
		    abilityadjs_c, abilityadjs_ch, moveadj_g, moveadj_f,
		    moveadj_s, value, xargc;
		EncumbrenceList *nx;
		char **xargv;
		/* argv[1] : Name */
		/* argv[2] : Handle */
		/* argv[3] : Description */
		if (Tcl_GetInt(interp,argv[4],&weight) != TCL_OK)
			return TCL_ERROR;
		if (Tcl_GetInt(interp,argv[5],&acadj) != TCL_OK)
			return TCL_ERROR;
		if (Tcl_GetInt(interp,argv[6],&tohitadj) != TCL_OK)
			return TCL_ERROR;
		if (Tcl_GetInt(interp,argv[7],&damadj) != TCL_OK)
			return TCL_ERROR;
		if (Tcl_GetInt(interp,argv[8],&magresadj) != TCL_OK)
			return TCL_ERROR;
		if (Tcl_GetInt(interp,argv[9],&damprotadj) != TCL_OK)
			return TCL_ERROR;
		if (Tcl_SplitList(interp, argv[10], &xargc, &xargv) != TCL_OK)
			return(TCL_ERROR);
		if (xargc != 6)
		{
			Tcl_AppendResult(interp, "Bad abilityadjs: ",
					 argv[10],"should be a list of six ints",
					 (char*) NULL);
			return(TCL_ERROR);
		}
		if (Tcl_GetInt(interp,xargv[0],&abilityadjs_s) != TCL_OK)
			return TCL_ERROR;
		if (Tcl_GetInt(interp,xargv[1],&abilityadjs_i) != TCL_OK)
			return TCL_ERROR;
		if (Tcl_GetInt(interp,xargv[2],&abilityadjs_w) != TCL_OK)
			return TCL_ERROR;
		if (Tcl_GetInt(interp,xargv[3],&abilityadjs_d) != TCL_OK)
			return TCL_ERROR;
		if (Tcl_GetInt(interp,xargv[4],&abilityadjs_c) != TCL_OK)
			return TCL_ERROR;
		if (Tcl_GetInt(interp,xargv[5],&abilityadjs_ch) != TCL_OK)
			return TCL_ERROR;
		free (xargv);
		if (Tcl_SplitList(interp, argv[11], &xargc, &xargv) != TCL_OK)
			return(TCL_ERROR);
		if (xargc != 3)
		{
			Tcl_AppendResult(interp, "Bad moveadj: ",
					 argv[11], "should be a list of three ints",
					 (char*) NULL);
				return(TCL_ERROR);
		}
		if (Tcl_GetInt(interp,xargv[0],&moveadj_g) != TCL_OK)
			return(TCL_ERROR);
		if (Tcl_GetInt(interp,xargv[1],&moveadj_f) != TCL_OK)
			return(TCL_ERROR);
		if (Tcl_GetInt(interp,xargv[2],&moveadj_s) != TCL_OK)
			return(TCL_ERROR);
		free (xargv);
		if (Tcl_GetInt(interp,argv[12],&value) != TCL_OK)
			return TCL_ERROR;
		if (argv[13][0] != '\0')
		{
			void_pt ptr = Tcl_HandleXlate(interp,
						      EncumbrenceList::Handles,
						      argv[13]);
			if (ptr == NULL) return TCL_ERROR;
			nx = *((EncumbrenceList**) ptr);
		} else nx = NULL;
		el = new EncumbrenceList(argv[1],argv[2],argv[3],weight,acadj,
					 tohitadj,damadj,magresadj,damprotadj,
					 abilityadjs_s,abilityadjs_i,
					 abilityadjs_w,abilityadjs_d,
					 abilityadjs_c,abilityadjs_ch,
					 moveadj_g,moveadj_f,moveadj_s,value,
					 nx);
	}
	char handle[32];
	EncumbrenceList **h = (EncumbrenceList **) Tcl_HandleAlloc (EncumbrenceList::Handles,handle);
	*h = el;
	Tcl_CreateCommand(interp,handle,(Tcl_CmdProc*)encumbrenceListCommand,
			  (ClientData)el,
			  (Tcl_CmdDeleteProc*)deleteEncumbrenceList);
	Tcl_AppendResult(interp,handle,(char *) NULL);
	return TCL_OK;
}

static int allEncumbrenceLists(ClientData clientData, Tcl_Interp *interp,int argc, char *argv[])
{
	int walk;
	walk = -1;
	while (Tcl_HandleWalk(EncumbrenceList::Handles,&walk) != NULL)
	{
		char handle[32];
		Tcl_WalkKeyToHandle(EncumbrenceList::Handles,walk,handle);
		Tcl_AppendElement(interp,handle);
	}
	return TCL_OK;

}

int EncumbrenceList_Init(Tcl_Interp *interp)
{
	EncumbrenceList::Handles = Tcl_HandleTblInit("EncumbrenceList",sizeof(EncumbrenceList),256);
	Tcl_CreateCommand(interp, "EncumbrenceList", (Tcl_CmdProc*)encumbrenceListCreate,
			  (ClientData) NULL, (Tcl_CmdDeleteProc*) NULL);
	Tcl_CreateCommand(interp, "AllEncumbrenceLists", (Tcl_CmdProc*)allEncumbrenceLists,
			  (ClientData) NULL, (Tcl_CmdDeleteProc*) NULL);
	return TCL_OK;
}	

static void putadj(String Flag,int adj,ostream& os)
{
	if (adj == 0) return;
	os << Flag << " ";
	if (adj > 0) os << "+";
	os << adj;
}


int EncumbrenceList::PSPut(ostream &os)
{
	os << "(" << PSQuote(Name) << ") putstr" << endl;
	if (Handle != "")
	{
		os << "( [" << Handle << "]) putstr" << endl ;
	}
	os << "( " << PSQuoteXnewline(Description) << ") putstr" << endl;
	os << "(Weight: " << Weight << ", Value: " << Value;

	putadj(", AC",ACAdj,os);
	putadj(", To Hit",ToHitAdj,os);
	putadj(", Damage",DamAdj,os);
	putadj(", Magical Resistance",MagResAdj,os);
	putadj(", Damage Protection",DamProtAdj,os);


	putadj(", Str",AbilityAdjs.s,os);
	putadj(", Int",AbilityAdjs.i,os);
	putadj(", Wis",AbilityAdjs.w,os);
	putadj(", Dex",AbilityAdjs.d,os);
	putadj(", Con",AbilityAdjs.c,os);
	putadj(", Chr",AbilityAdjs.ch,os);

	putadj(", Move",MoveAdj.g,os);
	putadj(", Fly",MoveAdj.f,os);
	putadj(", Swim",MoveAdj.s,os);

	os << ") CommentsParagraph" << endl;
	if (!os) return 0;
	else return 1;
}

int EncumbrenceList::HTMLPut(ostream &os)
{
	os << Name;
	if (Handle != "")
	{
		os << " [" << Handle << "]";
	}
	os << Description << "<br>" << endl;
	os << "<p>" << endl;
	os << "Weight: " << Weight << ", Value: " << Value;

	putadj(", AC",ACAdj,os);
	putadj(", To Hit",ToHitAdj,os);
	putadj(", Damage",DamAdj,os);
	putadj(", Magical Resistance",MagResAdj,os);
	putadj(", Damage Protection",DamProtAdj,os);


	putadj(", Str",AbilityAdjs.s,os);
	putadj(", Int",AbilityAdjs.i,os);
	putadj(", Wis",AbilityAdjs.w,os);
	putadj(", Dex",AbilityAdjs.d,os);
	putadj(", Con",AbilityAdjs.c,os);
	putadj(", Chr",AbilityAdjs.ch,os);

	putadj(", Move",MoveAdj.g,os);
	putadj(", Fly",MoveAdj.f,os);
	putadj(", Swim",MoveAdj.s,os);

	os << endl;
	os << "</p>" << endl;
	if (!os) return 0;
	else return 1;
}

int EncumbrenceList::TEXTPut(ostream &os)
{
	os << Name;
	if (Handle != "")
	{
		os << " [" << Handle << "]";
	}
	os << Description << endl;
	os << "Weight: " << Weight << ", Value: " << Value;

	putadj(", AC",ACAdj,os);
	putadj(", To Hit",ToHitAdj,os);
	putadj(", Damage",DamAdj,os);
	putadj(", Magical Resistance",MagResAdj,os);
	putadj(", Damage Protection",DamProtAdj,os);


	putadj(", Str",AbilityAdjs.s,os);
	putadj(", Int",AbilityAdjs.i,os);
	putadj(", Wis",AbilityAdjs.w,os);
	putadj(", Dex",AbilityAdjs.d,os);
	putadj(", Con",AbilityAdjs.c,os);
	putadj(", Chr",AbilityAdjs.ch,os);

	putadj(", Move",MoveAdj.g,os);
	putadj(", Fly",MoveAdj.f,os);
	putadj(", Swim",MoveAdj.s,os);

	os << endl;
	if (!os) return 0;
	else return 1;
}


int EncumbrenceList::Handlize(Tcl_Interp *interp)
{
	char handle[32];
	EncumbrenceList **tl = (EncumbrenceList **)
		Tcl_HandleAlloc (EncumbrenceList::Handles,handle);
	*tl = this;
	Tcl_CreateCommand(interp,handle,(Tcl_CmdProc*)encumbrenceListCommand,
			  this,(Tcl_CmdDeleteProc*)deleteEncumbrenceList);
	Tcl_AppendResult(interp,handle,(char *) NULL);
	return TCL_OK;
}
