/*
 * ------------------------------------------------------------------
 * Character.cc - Characte class implementation
 * Created by Robert Heller on Sat Feb 25 17:18:02 1995
 * ------------------------------------------------------------------
 * Modification History: $Log: Character.cc,v $
// Revision 1.14  1995/07/11  19:21:42  heller
// Fix missing s on AllCharacters
//
// Revision 1.13  1995/06/18  17:38:55  heller
// Updated the Postscript code (cleaned it up, added RPGDict, etc.)
//
// Revision 1.12  1995/03/23  23:40:24  heller
// Make CharacterHandles a static member
//
// Revision 1.11  1995/03/18  23:19:48  heller
// Add AllCharacters and FindCharactersBy
//
// Revision 1.10  1995/03/17  06:35:57  heller
// Add missing slots for Alignment, Sex, and Age
//
// Revision 1.9  1995/03/16  00:27:08  heller
// Add type hack
//
// Revision 1.8  1995/03/14  21:59:51  heller
// Update to use handles
//
// Revision 1.7  1995/03/12  05:46:17  heller
// Fixed readline problems
// Added no option for object command
//
// Revision 1.6  1995/03/04  20:42:00  heller
// Added '%' to PSQuoted characters
//
// Revision 1.5  1995/03/04  20:03:03  heller
// Properly handle empty comments (eof is ok at that point)
//
// Revision 1.4  1995/02/28  04:35:55  heller
// Add missing fields to print
//
// Revision 1.3  1995/02/28  03:35:22  heller
// Installed Postscript code
//
// Revision 1.2  1995/02/26  14:56:55  heller
// Add delete option to tcl interface
//
// Revision 1.1  1995/02/26  04:41:53  heller
// Initial revision
//
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 *  
 *     Role Playing Database -- a program for maintaining a database
 *                              for RPG characters and monsters
 *     Copyright (C) 1995  Robert Heller D/B/A Deepwoods Software
 * 			51 Locke Hill Road
 * 			Wendell, MA 01379-9728
 * 
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *  
 */

static char rcsid[] = "$Id: Character.cc,v 1.14 1995/07/11 19:21:42 heller Exp $";

#include <iostream.h>
#include <fstream.h>
#include <pfstream.h>
#include <strstream.h>
#include <Character.h>
#include <Dice.h>
#include <tclExtend.h>

#include <string.h>

String& PSQuote(String& source)
{
	static const Regex PSQChars = "[\\\\(\\)\\%]";
	String b = "", a = "", m = "";
	static String result;
	result = "";
	for (String temp = source;temp != "";temp = a)
	{
		b = temp.before(PSQChars);
		m = temp.at(PSQChars);
		a = temp.after(PSQChars);
		result += b;
		if (m != "")
		{
			result += "\\";
			result += m;
		} else  result += temp;
	}
	return result;
}

void Character::AdvanceLevel()
{
	level++;
	if (ndie == maxdie) return;
	Dice die(hdie);
	ndie++;
	hitpoints += die.Roll();
}

void Character::_Character(int s, int i, int w, int d, int c, int ch,
			   int es, int l, int hd, int nd, int md,
			   String n, String p, String r, String chc, 
			   String align, String sex, int ag,String com)
{
	ExperiencePoints = 0;
	strength = s;
	intelligence = i;
	wisdom = w;
	dexterity = d;
	constitution = c;
	chrisma = ch;
	exceptional_strength = es;
	level = l;
	hdie = hd;
	ndie = nd;
	maxdie = md;
	hitpoints = 0;
	Dice dice(hd,nd);
	hitpoints = dice.Roll();
	Name = n;
	Player = p;
	Race = r;
	ChClass = chc;
	Alignment = align;
	Sex = sex;
	age = ag;
	Comments = com;
}

Character::~Character()
{
}

int Character::ReadFromFile(char *filename)
{
	int temp;
	ifstream stream(filename);
	if (!stream) return 0;
	stream >> ExperiencePoints;
	if (!stream) return 0;
	stream >> temp; strength = temp;
	if (!stream) return 0;
	stream >> temp; intelligence = temp;
	if (!stream) return 0;
	stream >> temp; wisdom = temp;
	if (!stream) return 0;
	stream >> temp; dexterity = temp;
	if (!stream) return 0;
	stream >> temp; constitution = temp;
	if (!stream) return 0;
	stream >> temp; chrisma = temp;
	if (!stream) return 0;
	stream >> temp; exceptional_strength = temp;
	if (!stream) return 0;
	stream >> temp; level = temp;
	if (!stream) return 0;
	stream >> temp; hdie = temp;
	if (!stream) return 0;
	stream >> temp; ndie = temp;
	if (!stream) return 0;
	stream >> temp; maxdie = temp;
	if (!stream) return 0;
	stream >> hitpoints;
	if (!stream) return 0;
	stream >> age;
	if (!stream) return 0;
	stream.get(); // gobble \n after hitpoints
	if (!stream) return 0;
	static char buffer[2048];
	stream.getline(buffer,2048,'\n'); Name = buffer;
	if (!stream) return 0;
	stream.getline(buffer,2048,'\n'); Player = buffer;
	if (!stream) return 0;
	stream.getline(buffer,2048,'\n'); Race = buffer;
	if (!stream) return 0;
	stream.getline(buffer,2048,'\n'); ChClass = buffer;
	if (!stream) return 0;
	stream.getline(buffer,2048,'\n'); Alignment = buffer;
	if (!stream) return 0;
	stream.getline(buffer,2048,'\n'); Sex = buffer;
	if (!stream) return 0;
	Comments = "";
	while (stream)
	{
		stream.getline(buffer,2048,EOF); Comments += buffer;
	}
	if (!stream && !stream.eof()) return 0;
	return 1;
}

int Character::WriteToFile(char *filename)
{
	ofstream stream(filename);
	if (!stream) return 0;
	stream << ExperiencePoints << endl;
	if (!stream) return 0;
	stream << ((int)strength) << " " << ((int)intelligence) << " "
	       << ((int)wisdom) << " " << ((int)dexterity) << " " 
	       << ((int)constitution) << " " << ((int)chrisma) << " " 
	       << ((int)exceptional_strength)
	       << endl;
	if (!stream) return 0;
	stream << ((int)level) << " " << ((int)hdie) << " "
	       << ((int)ndie) << " " << ((int)maxdie) << " "
	       << hitpoints << " " << age << endl;
	if (!stream) return 0;
	stream << Name << endl;
	if (!stream) return 0;
	stream << Player << endl;
	if (!stream) return 0;
	stream << Race << endl;
	if (!stream) return 0;
	stream << ChClass << endl;
	if (!stream) return 0;
	stream << Alignment << endl;
	if (!stream) return 0;
	stream << Sex << endl;
	if (!stream) return 0;
	stream << Comments << endl;
	if (!stream) return 0;
	return 1;
}

#include <RPGDict.h>

int Character::PrintToFile(char *filename,PrintType typ)
{
	opfstream stream(filename);
	if (!stream) return 0;
	switch (typ)
	{
		case text:
			stream << "Name: " << Name << endl;
			if (!stream) return 0;
			stream << "Player: " << Player << endl;
			if (!stream) return 0;
			stream << "Race: " << Race << endl;
			if (!stream) return 0;
			stream << "Class: " << ChClass << endl;
			if (!stream) return 0;
			stream << "Alignment: " << Alignment << endl;
			if (!stream) return 0;
			stream << "Sex: " << Sex << endl;
			if (!stream) return 0;
			stream << "Age: " << age << endl;
			if (!stream) return 0;
			stream << "S: " << ((int)strength);
			if (!stream) return 0;
			if (strength == 18 && exceptional_strength > 0)
			{
			       if (exceptional_strength == 100) stream << "(00)";
			       else stream << "(" << ((int)exceptional_strength) << ")";
			       if (!stream) return 0;
			}
			stream << " ";
			if (!stream) return 0;
			stream << "I: " << ((int)intelligence) << " "
			       << "W: " << ((int)wisdom) << " "
			       << "D: " << ((int)dexterity) << " "
			       << "C: " << ((int)constitution) << " "
			       << "CH: " << ((int)chrisma) << endl;
			if (!stream) return 0;
			stream << "Level: " << ((int)level) << " "
			       << "HitDice: " << ((int)ndie) << "d" << ((int)hdie) << endl;
			if (!stream) return 0;
			stream << "Hit Points: " << hitpoints << " Experience Points: "
			       << ExperiencePoints << endl;
			if (!stream) return 0;
			stream << "Comments:" << endl;
			if (!stream) return 0;
			stream << Comments << endl;
			if (!stream) return 0;
			break;
		case html:
			stream << "<title>" << Name << "</title>" << endl;
			if (!stream) return 0;
			stream << "<h1>" << "Name: " << Name << "</h1><br>" << endl;
			if (!stream) return 0;
			stream << "<h1>" << "Player: " << Player << "</h1><br>" << endl;
			if (!stream) return 0;
			stream << "<h1>" << "Race: " << Race << "</h1><br>" << endl;
			if (!stream) return 0;
			stream << "<h1>" << "Class: " << ChClass << "</h1><br>" << endl;
			if (!stream) return 0;
			stream << "<h1>" << "Alignment: " << Alignment << "</h1><br>" << endl;
			if (!stream) return 0;
			stream << "<h1>" << "Sex: " << Sex << "</h1><br>" << endl;
			if (!stream) return 0;
			stream << "<h1>" << "Age: " << age << "</h1><br>" << endl;
			if (!stream) return 0;
			stream << "<h1>" << "S: " << ((int)strength);
			if (!stream) return 0;
			if (strength == 18 && exceptional_strength > 0)
			{
				if (exceptional_strength == 100)
				     stream << "(00)";
				else stream << "("
					    << ((int)exceptional_strength) 
					    << ")";
				if (!stream) return 0;
			}
			stream << " ";
			if (!stream) return 0;
			stream << "I: " << ((int)intelligence) << " "
			       << "W: " << ((int)wisdom) << " "
			       << "D: " << ((int)dexterity) << " "
			       << "C: " << ((int)constitution) << " "
			       << "CH: " << ((int)chrisma) << "</h1><br>" << endl;
			if (!stream) return 0;
			stream << "<h1>" << "Level: " << ((int)level) << " "
			       << "HitDice: " << ((int)ndie) << "d" 
			       << ((int)hdie) << "</h1><br>" << endl;
			if (!stream) return 0;
			stream << "<h1>Hit Points: " << hitpoints
			       << " Experience Points: " << ExperiencePoints 
			       << "</h1><br>" << endl;
			stream << "<h1>Comments:</h1><br>" << endl;
			if (!stream) return 0;
			stream << "<p>" <<  Comments << "</p>" << endl;
			if (!stream) return 0;
			break;
		case postscript:
			RPGDict(stream,Name);
			stream << "BIGFONT" << endl;
			stream << "(Character) showline" << endl;
			if (!stream) return 0;
			stream << "(Name: " << PSQuote(Name) << ") showhead" << endl;
			if (!stream) return 0;
			stream << "(Player: " << PSQuote(Player) << ") showline" << endl;
			if (!stream) return 0;
			stream << "(Race: " << PSQuote(Race) << ") showline" << endl;
			if (!stream) return 0;
			stream << "(Class: " << PSQuote(ChClass) << ") showline" << endl;
			if (!stream) return 0;
			stream << "(Alignment: " << PSQuote(Alignment) << ") showline" << endl;
			if (!stream) return 0;
			stream << "(Sex: " << PSQuote(Sex) << ") showline" << endl;
			if (!stream) return 0;
			stream << "(Age: " << age << ") showline" << endl;
			if (!stream) return 0;
			stream << "(S: " << ((int)strength);
			if (!stream) return 0;
			if (strength == 18 && exceptional_strength > 0)
			{
				if (exceptional_strength == 100) stream << "\\(00\\)";
				else stream << "\\(" << ((int)exceptional_strength) << "\\)";
				if (!stream) return 0;
			}
			stream << " ";
			if (!stream) return 0;
			stream << "I: " << ((int)intelligence) << " "
			       << "W: " << ((int)wisdom) << " "
			       << "D: " << ((int)dexterity) << " "
			       << "C: " << ((int)constitution) << " "
			       << "CH: " << ((int)chrisma) << ") showline" << endl;
			if (!stream) return 0;
			stream << "(Level: " << ((int)level) << " "
			       << "HitDice: " << ((int)ndie) << "d" 
			       << ((int)hdie) << ") showline" << endl;
			if (!stream) return 0;
			stream << "(Hit Points: " << hitpoints 
			       << " Experience Points: " << ExperiencePoints 
			       << ") showline" << endl;
			if (!stream) return 0;
			stream << "(Comments:) showline newline" << endl;
			if (!stream) return 0;
			stream << "NORMFONT" << endl; if (!stream) return 0;
			stream << "(" << PSQuoteXnewline(Comments)
			       << ") CommentsParagraph" << endl;
			stream << "newpage" << endl;
			RPGDictEnd(stream);
			if (!stream) return 0;
			break;
		default:
			break;
	}
	if (!stream) return 0;
	return 1;	
}

void_pt Character::Handles = NULL;

int Character::TclFunction(Tcl_Interp *interp,int argc, char *argv[])
{
	if (argc == 1)
	{
		// no option, echo slots
		Tcl_DString result;
		Tcl_DStringInit(&result);
		Tcl_DStringAppendElement(&result,"Character");
		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Name");
		Tcl_DStringAppendElement(&result,(char*)Name);
		Tcl_DStringEndSublist(&result);
		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Player");
		Tcl_DStringAppendElement(&result,(char*)Player);
		Tcl_DStringEndSublist(&result);
		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Race");
		Tcl_DStringAppendElement(&result,(char*)Race);
		Tcl_DStringEndSublist(&result);
		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Class");
		Tcl_DStringAppendElement(&result,(char*)ChClass);
		Tcl_DStringEndSublist(&result);
		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Alignment");
		Tcl_DStringAppendElement(&result,(char*)Alignment);
		Tcl_DStringEndSublist(&result);
		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Sex");
		Tcl_DStringAppendElement(&result,(char*)Sex);
		Tcl_DStringEndSublist(&result);
		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Age");
		{
			ostrstream stream;
			stream << age;
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		Tcl_DStringEndSublist(&result);
		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Strength");
		{
			ostrstream stream;
			stream << ((int) strength)<< " " << ((int) exceptional_strength);
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		Tcl_DStringEndSublist(&result);
		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Intelligence");
		{
			ostrstream stream;
			stream << ((int) intelligence);
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		Tcl_DStringEndSublist(&result);
		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Wisdom");
		{
			ostrstream stream;
			stream << ((int) wisdom);
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		Tcl_DStringEndSublist(&result);
		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Dexterity");
		{
			ostrstream stream;
			stream << ((int) dexterity);
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		Tcl_DStringEndSublist(&result);
		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Constitution");
		{
			ostrstream stream;
			stream << ((int) constitution);
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		Tcl_DStringEndSublist(&result);
		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Chrisma");
		{
			ostrstream stream;
			stream << ((int) chrisma);
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		Tcl_DStringEndSublist(&result);
		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Level");
		{
			ostrstream stream;
			stream << ((int) level);
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		Tcl_DStringEndSublist(&result);
		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"HitDice");
		{
			ostrstream stream;
			stream << ((int) ndie) << "d" << ((int) hdie);
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		{
			ostrstream stream;
			stream << ((int) maxdie);
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		Tcl_DStringEndSublist(&result);
		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"HitPoints");
		{
			ostrstream stream;
			stream << hitpoints;
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		Tcl_DStringEndSublist(&result);
		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"ExperiencePoints");
		{
			ostrstream stream;
			stream << ExperiencePoints;
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		Tcl_DStringEndSublist(&result);
		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Comments");
		Tcl_DStringAppendElement(&result,(char*)Comments);
		Tcl_DStringEndSublist(&result);
		Tcl_DStringResult(interp,&result);
		return TCL_OK;
	}
	if (argc < 2)
	{
		Tcl_AppendResult(interp, "wrong # args: should be \"",
				 argv[0], " option ?arg arg ...?\"",
				 (char *) NULL);
		return TCL_ERROR;
	}
	if (strcmp(argv[1], "type") == 0)
	{
		if (argc != 2)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],(char *) NULL);
			return TCL_ERROR;
		}
		Tcl_AppendResult(interp, "Character", (char *) NULL);
		return TCL_OK;
	} else if (strcmp(argv[1], "write") == 0)
	{
		if (argc != 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
			 		  argv[0]," ",argv[1]," filename\"",
					  (char *) NULL);
			return TCL_ERROR;
		}
		if (!WriteToFile(argv[2]))
		{
			Tcl_AppendResult(interp, "Error writing file ",argv[2],
					 (char *) NULL);
			return TCL_ERROR;
		} else return TCL_OK;
	} else if (strcmp(argv[1], "read") == 0)
	{
		if (argc != 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
			 		  argv[0]," ",argv[1]," filename\"",
					  (char *) NULL);
			return TCL_ERROR;
		}
		if (!ReadFromFile(argv[2]))
		{
			Tcl_AppendResult(interp, "Error reading file ",argv[2],
					 (char *) NULL);
			return TCL_ERROR;
		} else return TCL_OK;
	} else if (strcmp(argv[1], "name") == 0)
	{
		if (argc == 2)
		{
			Tcl_AppendResult(interp,(char*)Name,(char *) NULL);
			return TCL_OK;
		} else if (argc == 3)
		{
			Name = argv[2];
			Tcl_AppendResult(interp,(char*)Name,(char *) NULL);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
			 		  argv[0]," ",argv[1]," ?value?\"",
					  (char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "player") == 0)
	{
		if (argc == 2)
		{
			Tcl_AppendResult(interp,(char*)Player,(char *) NULL);
			return TCL_OK;
		} else if (argc == 3)
		{
			Player = argv[2];
			Tcl_AppendResult(interp,(char*)Player,(char *) NULL);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
			 		  argv[0]," ",argv[1]," ?value?\"",
					  (char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "race") == 0)
	{
		if (argc == 2)
		{
			Tcl_AppendResult(interp,(char*)Race,(char *) NULL);
			return TCL_OK;
		} else if (argc == 3)
		{
			Race = argv[2];
			Tcl_AppendResult(interp,(char*)Race,(char *) NULL);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
			 		  argv[0]," ",argv[1]," ?value?\"",
					  (char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "class") == 0)
	{
		if (argc == 2)
		{
			Tcl_AppendResult(interp,(char*)ChClass,(char *) NULL);
			return TCL_OK;
		} else if (argc == 3)
		{
			ChClass = argv[2];
			Tcl_AppendResult(interp,(char*)ChClass,(char *) NULL);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
			 		  argv[0]," ",argv[1]," ?value?\"",
					  (char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "alignment") == 0)
	{
		if (argc == 2)
		{
			Tcl_AppendResult(interp,(char*)Alignment,(char *) NULL);
			return TCL_OK;
		} else if (argc == 3)
		{
			Alignment = argv[2];
			Tcl_AppendResult(interp,(char*)Alignment,(char *) NULL);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
			 		  argv[0]," ",argv[1]," ?value?\"",
					  (char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "sex") == 0)
	{
		if (argc == 2)
		{
			Tcl_AppendResult(interp,(char*)Sex,(char *) NULL);
			return TCL_OK;
		} else if (argc == 3)
		{
			Sex = argv[2];
			Tcl_AppendResult(interp,(char*)Sex,(char *) NULL);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
			 		  argv[0]," ",argv[1]," ?value?\"",
					  (char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "comments") == 0)
	{
		if (argc == 2)
		{
			Tcl_AppendResult(interp,(char*)Comments,(char *) NULL);
			return TCL_OK;
		} else if (argc == 3)
		{
			Comments = argv[2];
			Tcl_AppendResult(interp,(char*)Comments,(char *) NULL);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
			 		  argv[0]," ",argv[1]," ?value?\"",
					  (char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "strength") == 0)
	{
		if (argc == 2)
		{
			ostrstream stream;
			stream << ((int) strength);
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_AppendResult(interp,s,(char *) NULL);
			return TCL_OK;
		} else if (argc == 3)
		{
			int temp;
			if (Tcl_GetInt(interp,argv[2],&temp) != TCL_OK)
				return(TCL_ERROR);
			strength = temp;
			ostrstream stream;
			stream << ((int) strength);
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_AppendResult(interp,s,(char *) NULL);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
			 		  argv[0]," ",argv[1]," ?value?\"",
					  (char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "intelligence") == 0)
	{
		if (argc == 2)
		{
			ostrstream stream;
			stream << ((int) intelligence);
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_AppendResult(interp,s,(char *) NULL);
			return TCL_OK;
		} else if (argc == 3)
		{
			int temp;
			if (Tcl_GetInt(interp,argv[2],&temp) != TCL_OK)
				return(TCL_ERROR);
			intelligence = temp;
			ostrstream stream;
			stream << ((int) intelligence);
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_AppendResult(interp,s,(char *) NULL);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
			 		  argv[0]," ",argv[1]," ?value?\"",
					  (char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "wisdom") == 0)
	{
		if (argc == 2)
		{
			ostrstream stream;
			stream << ((int) wisdom);
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_AppendResult(interp,s,(char *) NULL);
			return TCL_OK;
		} else if (argc == 3)
		{
			int temp;
			if (Tcl_GetInt(interp,argv[2],&temp) != TCL_OK)
				return(TCL_ERROR);
			wisdom = temp;
			ostrstream stream;
			stream << ((int) wisdom);
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_AppendResult(interp,s,(char *) NULL);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
			 		  argv[0]," ",argv[1]," ?value?\"",
					  (char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "dexterity") == 0)
	{
		if (argc == 2)
		{
			ostrstream stream;
			stream << ((int) dexterity);
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_AppendResult(interp,s,(char *) NULL);
			return TCL_OK;
		} else if (argc == 3)
		{
			int temp;
			if (Tcl_GetInt(interp,argv[2],&temp) != TCL_OK)
				return(TCL_ERROR);
			dexterity = temp;
			ostrstream stream;
			stream << ((int) dexterity);
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_AppendResult(interp,s,(char *) NULL);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
			 		  argv[0]," ",argv[1]," ?value?\"",
					  (char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "constitution") == 0)
	{
		if (argc == 2)
		{
			ostrstream stream;
			stream << ((int) constitution);
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_AppendResult(interp,s,(char *) NULL);
			return TCL_OK;
		} else if (argc == 3)
		{
			int temp;
			if (Tcl_GetInt(interp,argv[2],&temp) != TCL_OK)
				return(TCL_ERROR);
			constitution = temp;
			ostrstream stream;
			stream << ((int) constitution);
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_AppendResult(interp,s,(char *) NULL);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
			 		  argv[0]," ",argv[1]," ?value?\"",
					  (char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "chrisma") == 0)
	{
		if (argc == 2)
		{
			ostrstream stream;
			stream << ((int) chrisma);
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_AppendResult(interp,s,(char *) NULL);
			return TCL_OK;
		} else if (argc == 3)
		{
			int temp;
			if (Tcl_GetInt(interp,argv[2],&temp) != TCL_OK)
				return(TCL_ERROR);
			chrisma = temp;
			ostrstream stream;
			stream << ((int) chrisma);
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_AppendResult(interp,s,(char *) NULL);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
			 		  argv[0]," ",argv[1]," ?value?\"",
					  (char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "exceptional_strength") == 0)
	{
		if (argc == 2)
		{
			ostrstream stream;
			stream << ((int) exceptional_strength);
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_AppendResult(interp,s,(char *) NULL);
			return TCL_OK;
		} else if (argc == 3)
		{
			int temp;
			if (Tcl_GetInt(interp,argv[2],&temp) != TCL_OK)
				return(TCL_ERROR);
			exceptional_strength = temp;
			ostrstream stream;
			stream << ((int) exceptional_strength);
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_AppendResult(interp,s,(char *) NULL);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
			 		  argv[0]," ",argv[1]," ?value?\"",
					  (char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "level") == 0)
	{
		if (argc == 2)
		{
			ostrstream stream;
			stream << ((int) level);
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_AppendResult(interp,s,(char *) NULL);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
			 		  argv[0]," ",argv[1],"\"",
					  (char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "hitdie") == 0)
	{
		if (argc == 2)
		{
			ostrstream stream;
			stream << ((int) hdie);
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_AppendResult(interp,s,(char *) NULL);
			return TCL_OK;
		} else if (argc == 3)
		{
			int temp;
			if (Tcl_GetInt(interp,argv[2],&temp) != TCL_OK)
				return(TCL_ERROR);
			hdie = temp;
			ostrstream stream;
			stream << ((int) hdie);
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_AppendResult(interp,s,(char *) NULL);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
			 		  argv[0]," ",argv[1]," ?value?\"",
					  (char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "numberhitdie") == 0)
	{
		if (argc == 2)
		{
			ostrstream stream;
			stream << ((int) ndie);
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_AppendResult(interp,s,(char *) NULL);
			return TCL_OK;
		} else if (argc == 3)
		{
			int temp;
			if (Tcl_GetInt(interp,argv[2],&temp) != TCL_OK)
				return(TCL_ERROR);
			ndie = temp;
			ostrstream stream;
			stream << ((int) ndie);
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_AppendResult(interp,s,(char *) NULL);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
			 		  argv[0]," ",argv[1]," ?value?\"",
					  (char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "maxhitdie") == 0)
	{
		if (argc == 2)
		{
			ostrstream stream;
			stream << ((int) maxdie);
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_AppendResult(interp,s,(char *) NULL);
			return TCL_OK;
		} else if (argc == 3)
		{
			int temp;
			if (Tcl_GetInt(interp,argv[2],&temp) != TCL_OK)
				return(TCL_ERROR);
			maxdie = temp;
			ostrstream stream;
			stream << ((int) maxdie);
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_AppendResult(interp,s,(char *) NULL);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
			 		  argv[0]," ",argv[1]," ?value?\"",
					  (char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "experiencepoints") == 0)
	{
		if (argc == 2)
		{
			ostrstream stream;
			stream << ExperiencePoints;
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_AppendResult(interp,s,(char *) NULL);
			return TCL_OK;
		} else if (argc == 3)
		{
			if (Tcl_GetInt(interp,argv[2],&ExperiencePoints) != TCL_OK)
				return(TCL_ERROR);
			ostrstream stream;
			stream << ExperiencePoints;
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_AppendResult(interp,s,(char *) NULL);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
			 		  argv[0]," ",argv[1]," ?value?\"",
					  (char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "hitpoints") == 0)
	{
		if (argc == 2)
		{
			ostrstream stream;
			stream << hitpoints;
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_AppendResult(interp,s,(char *) NULL);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
			 		  argv[0]," ",argv[1],"\"",
					  (char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "age") == 0)
	{
		if (argc == 2)
		{
			ostrstream stream;
			stream << age;
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_AppendResult(interp,s,(char *) NULL);
			return TCL_OK;
		} else if (argc == 3)
		{
			int temp;
			if (Tcl_GetInt(interp,argv[2],&temp) != TCL_OK)
				return(TCL_ERROR);
			age = temp;
			ostrstream stream;
			stream << age;
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_AppendResult(interp,s,(char *) NULL);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
			 		  argv[0]," ",argv[1],"\"",
					  (char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "computehitpoints") == 0)
	{
		if (argc != 2)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],"\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		hitpoints = 0;
		Dice dice(hdie,ndie);
		hitpoints = dice.Roll();
		ostrstream stream;
		stream << hitpoints;
		_IO_ssize_t i = stream.pcount();
		char *s = stream.str();
		s[i] = '\0';
		Tcl_AppendResult(interp,s,(char *) NULL);
		return TCL_OK;
	} else if (strcmp(argv[1], "print") == 0)
	{
		if (argc < 3 || argc > 4)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],
					 " filename ?mode?\"",(char *) NULL);
			return TCL_ERROR;
		}
		PrintType typ = text;
		if (argc == 4)
		{
			if (strcmp(argv[3],"text") == 0) typ = text;
			else if (strcmp(argv[3],"html") == 0) typ = html;
			else if (strcmp(argv[3],"postscript") == 0)
				typ = postscript;
			else
			{
				Tcl_AppendResult(interp, "wrong print mode: ",
						 argv[3]," should be one of {",
						 "text html html}",
						 (char *) NULL);
				return TCL_ERROR;
			}
		}
		if (!PrintToFile(argv[2],typ))
		{
			Tcl_AppendResult(interp, "Error printing to ",
					 argv[2],(char *) NULL);
			return TCL_ERROR;
		} else return TCL_OK;
	} else if (strcmp(argv[1], "advancelevel") == 0)
	{
		if (argc != 2)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],"\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		AdvanceLevel();
		ostrstream stream;
		stream << ((int) level);
		_IO_ssize_t i = stream.pcount();
		char *s = stream.str();
		s[i] = '\0';
		Tcl_AppendResult(interp,s,(char *) NULL);
		return TCL_OK;
	} else if (strcmp(argv[1], "delete") == 0)
	{
		if (argc != 2)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],"\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		void_pt header = Tcl_HandleXlate (interp,Character::Handles,argv[0]);
		if (header == NULL) return TCL_ERROR;
		Tcl_HandleFree (Character::Handles,header);
		return Tcl_DeleteCommand(interp,argv[0]);
	} else
	{
		Tcl_AppendResult(interp, "Bad option: ",argv[1],(char *) NULL);
		return TCL_ERROR;
	}
}


static void deleteCharacter(ClientData clientData)
{
        register Character *character = (Character *) clientData;
        delete character;
}

static int characterCommand(ClientData clientData, Tcl_Interp *interp,
                       int argc, char *argv[])
{
	register Character *character = (Character*)clientData;
	return character->TclFunction(interp,argc,argv);
}


static int CharacterCreate(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[])
{
	register Character *character;
	if (argc != 1 && (argc < 18 || argc > 20))
	{
		 Tcl_AppendResult(interp, "Wrong # args: should be \"",
		 		argv[0]," ?name player race class alignment ",
				"sex age strength ",
				"?exceptStrength? intelligence wisdom ",
				"dexterity constitution chrisma level hitdie ",
				"?numHitDie? maxhitdie comments?\"", 
				(char*) NULL);
		return TCL_ERROR;
	}
	if (argc == 1)
	{
		/* nothing but the handle */
		character = new Character;
	} else if (argc == 18)
	{
		/* no exceptStrength or numHitDie */
		int strength, intelligence, wisdom, dexterity, constitution,
		    chrisma, level, hitdie, maxhitdie, age;
		/* argv[1] : name */
		/* argv[2] : player */
		/* argv[3] : race */
		/* argv[4] : class */
		/* argv[5] : alignment */
		/* argv[6] : sex */
		if (Tcl_GetInt(interp,argv[7],&age) != TCL_OK)
			return(TCL_ERROR);
		if (Tcl_GetInt(interp,argv[8],&strength) != TCL_OK)
			return(TCL_ERROR);
		if (Tcl_GetInt(interp,argv[9],&intelligence) != TCL_OK)
			return(TCL_ERROR);
		if (Tcl_GetInt(interp,argv[10],&wisdom) != TCL_OK)
			return(TCL_ERROR);
		if (Tcl_GetInt(interp,argv[11],&dexterity) != TCL_OK)
			return(TCL_ERROR);
		if (Tcl_GetInt(interp,argv[12],&constitution) != TCL_OK)
			return(TCL_ERROR);
		if (Tcl_GetInt(interp,argv[13],&chrisma) != TCL_OK)
			return(TCL_ERROR);
		if (Tcl_GetInt(interp,argv[14],&level) != TCL_OK)
			return(TCL_ERROR);
		if (Tcl_GetInt(interp,argv[15],&hitdie) != TCL_OK)
			return(TCL_ERROR);
		if (Tcl_GetInt(interp,argv[16],&maxhitdie) != TCL_OK)
			return(TCL_ERROR);
		/* argv[17] : comments */
		character = new Character(strength,intelligence,wisdom,
					  dexterity,constitution,chrisma,
					  level,hitdie,maxhitdie,argv[1],
					  argv[2],argv[3],argv[4],argv[5],
					  argv[6],age,argv[17]);
	} else if (argc == 19)
	{
		/* no numHitDie */
		int strength, intelligence, wisdom, dexterity, constitution,
		    chrisma, level, hitdie, maxhitdie, except_strength, age;
		/* argv[1] : name */
		/* argv[2] : player */
		/* argv[3] : race */
		/* argv[4] : class */
		/* argv[5] : alignment */
		/* argv[6] : sex */
		if (Tcl_GetInt(interp,argv[7],&age) != TCL_OK)
			return(TCL_ERROR);
		if (Tcl_GetInt(interp,argv[8],&strength) != TCL_OK)
			return(TCL_ERROR);
		if (Tcl_GetInt(interp,argv[9],&except_strength) != TCL_OK)
		        return(TCL_ERROR);
		if (Tcl_GetInt(interp,argv[10],&intelligence) != TCL_OK)
			return(TCL_ERROR);
		if (Tcl_GetInt(interp,argv[11],&wisdom) != TCL_OK)
			return(TCL_ERROR);
		if (Tcl_GetInt(interp,argv[12],&dexterity) != TCL_OK)
			return(TCL_ERROR);
		if (Tcl_GetInt(interp,argv[13],&constitution) != TCL_OK)
			return(TCL_ERROR);
		if (Tcl_GetInt(interp,argv[14],&chrisma) != TCL_OK)
			return(TCL_ERROR);
		if (Tcl_GetInt(interp,argv[15],&level) != TCL_OK)
			return(TCL_ERROR);
		if (Tcl_GetInt(interp,argv[16],&hitdie) != TCL_OK)
			return(TCL_ERROR);
		if (Tcl_GetInt(interp,argv[17],&maxhitdie) != TCL_OK)
			return(TCL_ERROR);
		/* argv[18] : comments */
		character = new Character(strength,intelligence,wisdom,
					  dexterity,constitution,chrisma,
					  except_strength,
					  level,hitdie,maxhitdie,argv[1],
					  argv[2],argv[3],argv[4],argv[5],
					  argv[6],age,argv[18]);
	} else
	{
		int strength, intelligence, wisdom, dexterity, constitution,
		    chrisma, level, hitdie, maxhitdie, except_strength,
		    numhitd, age;
		/* argv[1] : name */
		/* argv[2] : player */
		/* argv[3] : race */
		/* argv[4] : class */
		/* argv[5] : alignment */
		/* argv[6] : sex */
		if (Tcl_GetInt(interp,argv[7],&age) != TCL_OK)
			return(TCL_ERROR);
		if (Tcl_GetInt(interp,argv[8],&strength) != TCL_OK)
			return(TCL_ERROR);
		if (Tcl_GetInt(interp,argv[9],&except_strength) != TCL_OK)
		        return(TCL_ERROR);
		if (Tcl_GetInt(interp,argv[10],&intelligence) != TCL_OK)
			return(TCL_ERROR);
		if (Tcl_GetInt(interp,argv[11],&wisdom) != TCL_OK)
			return(TCL_ERROR);
		if (Tcl_GetInt(interp,argv[12],&dexterity) != TCL_OK)
			return(TCL_ERROR);
		if (Tcl_GetInt(interp,argv[13],&constitution) != TCL_OK)
			return(TCL_ERROR);
		if (Tcl_GetInt(interp,argv[14],&chrisma) != TCL_OK)
			return(TCL_ERROR);
		if (Tcl_GetInt(interp,argv[15],&level) != TCL_OK)
			return(TCL_ERROR);
		if (Tcl_GetInt(interp,argv[16],&hitdie) != TCL_OK)
			return(TCL_ERROR);
		if (Tcl_GetInt(interp,argv[17],&numhitd) != TCL_OK)
			return(TCL_ERROR);
		if (Tcl_GetInt(interp,argv[18],&maxhitdie) != TCL_OK)
			return(TCL_ERROR);
		/* argv[19] : comments */
		character = new Character(strength,intelligence,wisdom,
					  dexterity,constitution,chrisma,
					  except_strength,
					  level,hitdie,numhitd,maxhitdie,
					  argv[1],argv[2],argv[3],argv[4],
					  argv[5],argv[6],age,argv[19]);
	}
	static char handle[32];
	Character** h = (Character**) Tcl_HandleAlloc (Character::Handles,handle);
	*h = character;
	Tcl_CreateCommand(interp,handle,(Tcl_CmdProc*)characterCommand,
			  (ClientData)character,
			  (Tcl_CmdDeleteProc*)deleteCharacter);
	Tcl_AppendResult(interp,handle,(char *) NULL);
	return TCL_OK;
}

static int allCharacters(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[])
{
	int walk;
	walk = -1;
	while (Tcl_HandleWalk(Character::Handles,&walk) != NULL)
	{
		char handle[32];
		Tcl_WalkKeyToHandle(Character::Handles,walk,handle);
		Tcl_AppendElement(interp,handle);
	}
	return TCL_OK;

}

static int findCharactersBy(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[])
{
	int walk;
	enum {name, alignment, player, race, chclass, sex} field;
	Character **cp;
	if (argc != 3)
	{
		Tcl_AppendResult(interp, "Wrong # args: should be \"",
				 argv[0]," ?{name, alignment, player, race, chclass, sex} pattern? \"",
				 (char*) NULL);
		return TCL_ERROR;
	}
	if (strcmp(argv[1],"name") == 0) field = name;
	else if (strcmp(argv[1],"class") == 0) field = chclass;
	else if (strcmp(argv[1],"alignment") == 0) field = alignment;
	else if (strcmp(argv[1],"player") == 0) field = player;
	else if (strcmp(argv[1],"race") == 0) field = race;
	else if (strcmp(argv[1],"sex") == 0) field = sex;
	else
	{
		Tcl_AppendResult(interp, "Bad field name: ",argv[1],
				 "should be one of {name treasure alignment}",
				 (char*) NULL);
		 return TCL_ERROR;
	}
	walk = -1;
	while ((cp = (Character**) Tcl_HandleWalk(Character::Handles,&walk)) != NULL)
	{
		Character *c = *cp;
		String value;
		switch (field)
		{
			case name:	value = c->Name; break;
			case chclass:	value = c->ChClass ; break;
			case alignment:	value = c->Alignment; break;
			case player:	value = c->Player; break;
			case race:	value = c->Race; break;
			case sex:	value = c->Sex; break;
		}
		if (Tcl_StringMatch((char*)value,argv[2]))
		{
			char handle[32];
			Tcl_WalkKeyToHandle(Character::Handles,walk,handle);
			Tcl_AppendElement(interp,handle);
		}
	}
	return TCL_OK;
}

int Character_Init(Tcl_Interp *interp)
{
	Character::Handles = Tcl_HandleTblInit("Character",sizeof(Character*),256);
	Tcl_CreateCommand(interp, "Character", (Tcl_CmdProc*)CharacterCreate,
			  (ClientData) NULL, (Tcl_CmdDeleteProc*) NULL);
	Tcl_CreateCommand(interp, "AllCharacters", (Tcl_CmdProc*)allCharacters,
			  (ClientData) NULL, (Tcl_CmdDeleteProc*) NULL);
	Tcl_CreateCommand(interp, "FindCharactersBy", (Tcl_CmdProc*)findCharactersBy,
			  (ClientData) NULL, (Tcl_CmdDeleteProc*) NULL);
	return TCL_OK;
}
