/* $Id: variable.h,v 30000.21 1993/05/08 00:02:19 kkeys Exp $ */
/******************************************************************
 * Copyright 1993 by Ken Keys.
 * Permission is granted to obtain and redistribute this code freely.
 * All redistributions must contain this header.  You may modify this
 * software, but any redistributions of modified code must be clearly
 * marked as having been modified.
 ******************************************************************/

#ifndef VARIABLE_H
#define VARIABLE_H

/*********************************************
 * Internal, user, and environment variables *
 *********************************************/

#define VAR_EXPORT 1
#define VAR_FLAG   2
#define VAR_INT    4
#define VAR_STR    8

typedef struct Var {
    char *name;
    char *value;
    int flags;
    int ival;                      /* integer value */
    Toggler *func;                 /* called when ival changes */
    struct ListEntry *node;        /* backpointer to node in List */
} Var;

extern void  NDECL(init_variables);
extern void  NDECL(init_values);
extern char *FDECL(getvar,(char *name));
extern int   FDECL(setvar,(char *name, char *value, int exportflag));
extern void  FDECL(setivar,(char *name, int value, int exportflag));
extern void  FDECL(unsetvar,(char *name));
extern void  FDECL(listvar,(int exportflag));
extern int   FDECL(export,(char *name));

/* these must be in same order as special_var (sorted by user name) */
enum Vars {
    MAIL        ,      /* All caps.  Other vars are lowercase. */
    BACKGROUND  ,
    BACKSLASH   ,
    BAMF        ,
    BARATTR     ,
    BEEPING     ,      /* user name is "beep" */
    BORG        ,
    CLEARDONE   ,
    CLEARFULL   ,
    GAG         ,
    GPRI        ,
    HILITE      ,
    HILITEATTR  ,
    HOOKFLAG    ,      /* user name is "hook" */
    HPRI        ,
    INSERT      ,
    ISIZE       ,
    KECHO       ,
    KPREFIX     ,
    LOGIN       ,
    LPFLAG      ,      /* user name is "lp" */
    LPQUOTE     ,
    MAILDELAY   ,
    MAX_RECUR   ,
    MECHO       ,
    MORE        ,
    MPREFIX     ,
    OLDSLASH    ,
    PROMPT_SEC  ,
    PROMPT_USEC ,
    PROCESS_TIME,      /* user name is "ptime" */
    QECHO       ,
    QPREFIX     ,
    QUIET       ,
    QUITDONE    ,
    REDEF       ,
    REFRESHTIME ,
    SHPAUSE     ,
    SNARF       ,
    SOCKMLOAD   ,
#if 0
    SWITCH_ON_CONNECT ,
#endif
    VISUAL      ,
    WATCHDOG    ,
    WATCHNAME   ,
    WRAPFLAG    ,      /* user name is "wrap" */
    WRAPLOG     ,
    WRAPSIZE    ,
    WRAPSPACE   ,
    NUM_VARS           /* not a Var, but a count */
};

#define background        (special_var[ BACKGROUND        ].ival)
#define backslash         (special_var[ BACKSLASH         ].ival)
#define bamf              (special_var[ BAMF              ].ival)
#define barattr           (special_var[ BARATTR           ].ival)
#define beeping           (special_var[ BEEPING           ].ival)
#define borg              (special_var[ BORG              ].ival)
#define cleardone         (special_var[ CLEARDONE         ].ival)
#define clearfull         (special_var[ CLEARFULL         ].ival)
#define gag               (special_var[ GAG               ].ival)
#define gpri              (special_var[ GPRI              ].ival)
#define hilite            (special_var[ HILITE            ].ival)
#define hiliteattr        (special_var[ HILITEATTR        ].ival)
#define hookflag          (special_var[ HOOKFLAG          ].ival)
#define hpri              (special_var[ HPRI              ].ival)
#define insert            (special_var[ INSERT            ].ival)
#define isize             (special_var[ ISIZE             ].ival)
#define kecho             (special_var[ KECHO             ].ival)
/* #define kprefix */
#define login             (special_var[ LOGIN             ].ival)
#define lpflag            (special_var[ LPFLAG            ].ival)
#define lpquote           (special_var[ LPQUOTE           ].ival)
/* #define mail */
#define maildelay         (special_var[ MAILDELAY         ].ival)
#define max_recur         (special_var[ MAX_RECUR         ].ival)
#define mecho             (special_var[ MECHO             ].ival)
#define more              (special_var[ MORE              ].ival)
/* #define mprefix */
#define oldslash          (special_var[ OLDSLASH          ].ival)
#define prompt_sec        (special_var[ PROMPT_SEC        ].ival)
#define prompt_usec       (special_var[ PROMPT_USEC       ].ival)
#define process_time      (special_var[ PROCESS_TIME      ].ival)
#define qecho             (special_var[ QECHO             ].ival)
/* #define qprefix */
#define quiet             (special_var[ QUIET             ].ival)
#define quitdone          (special_var[ QUITDONE          ].ival)
#define redef             (special_var[ REDEF             ].ival)
#define refreshtime       (special_var[ REFRESHTIME       ].ival)
#define shpause           (special_var[ SHPAUSE           ].ival)
#define snarf             (special_var[ SNARF             ].ival)
#define sockmload         (special_var[ SOCKMLOAD         ].ival)
#if 0
#define switch_on_connect (special_var[ SWITCH_ON_CONNECT ].ival)
#endif
#define visual            (special_var[ VISUAL            ].ival)
#define watchdog          (special_var[ WATCHDOG          ].ival)
#define watchname         (special_var[ WATCHNAME         ].ival)
#define wrapflag          (special_var[ WRAPFLAG          ].ival)
#define wraplog           (special_var[ WRAPLOG           ].ival)
#define wrapsize          (special_var[ WRAPSIZE          ].ival)
#define wrapspace         (special_var[ WRAPSPACE         ].ival)

extern Var special_var[];

#endif /* VARIABLE_H */
