/* $Id: util.h,v 30000.21 1993/05/18 09:09:47 kkeys Exp $ */
/******************************************************************
 * Copyright 1993 by Ken Keys.
 * Permission is granted to obtain and redistribute this code freely.
 * All redistributions must contain this header.  You may modify this
 * software, but any redistributions of modified code must be clearly
 * marked as having been modified.
 ******************************************************************/

#ifndef UTIL_H
#define UTIL_H

/* Not even all ANSI systems have strerror()!  So, we assume at least */
/* sys_errlist[] is available, and roll our own strerror() */
extern int sys_nerr;
extern char *sys_errlist[];
#define STRERROR(n) (((n) > 0 && (n) < sys_nerr) ? sys_errlist[(n)] : \
    "unknown error")

#ifdef DMALLOC
#define STRDUP(src) \
    (strcpy(dmalloc(strlen(src) + 1, __FILE__, __LINE__), (src)))
#define STRINGDUP(src) \
    (strcpy(dmalloc((src)->len + 1, __FILE__, __LINE__), (src)->s))
#else
#define STRDUP(src) (strcpy(dmalloc(strlen(src) + 1), (src)))
#define STRINGDUP(src) (strcpy(dmalloc((src)->len + 1), (src)->s))
#endif

extern char lowercase_values[128], uppercase_values[128];
#define lcase(x) (lowercase_values[(x)])
#define ucase(x) (uppercase_values[(x)])
#define equalstr(s, t) (!smatch((s), (t)))

#ifdef HAVE_STRTOL
# define strtochr(sp) (char)(strtol(*(sp), sp, 0) % 128)
#else
extern char   FDECL(strtochr,(char **sp));
#endif
extern void   NDECL(init_table);
extern char  *FDECL(cstrchr,(CONST char *s, int c));
extern char  *FDECL(estrchr,(CONST char *s, int c, int e));
extern int    FDECL(cstrcmp,(CONST char *s, CONST char *t));
extern int    FDECL(cstrncmp,(CONST char *s, CONST char *t, int n));

#ifdef HAVE_STRSTR
# define STRSTR(s1, s2) strstr((s1), (s2))
#else
  extern char *FDECL(STRSTR,(CONST char *s1, CONST char *s2));
#endif

extern int    FDECL(numarg,(char **str));
extern int    FDECL(smatch,(char *s, char *t));
extern int    FDECL(smatch_check,(CONST char *s));
extern char  *FDECL(stripstr,(char *s));
extern void   FDECL(startopt,(char *args, char *opts));
extern char   FDECL(nextopt,(char **arg, int *num));
#ifdef DMALLOC
extern Aline  *FDECL(dnew_aline,(char *str, int attrs, char *file, int line));
#define new_aline(str, attrs) dnew_aline((str), (attrs), __FILE__, __LINE__)
#else
extern Aline  *FDECL(new_aline,(char *str, int attrs));
#endif
extern void   FDECL(free_aline,(Aline *aline));
extern TOGGLER(change_mailfile);
extern TOGGLER(change_maildelay);
extern void   NDECL(check_mail);
extern void   NDECL(cleanup);
extern void   FDECL(die,(CONST char *why));

#endif /* UTIL_H */
