/* game.h */

/* Command handlers */

#include "config.h"

/* Miscellaneous flags */
#define CHECK_INVENTORY            0x10
#define CHECK_NEIGHBORS            0x20
#define CHECK_SELF                 0x40
#define CHECK_HERE                 0x80
#define CHECK_ZONE                 0x100
#define CHECK_GLOBAL               0x200

/* hash table stuff */
extern void init_func_hashtab();       /* eval.c */
extern void init_aname_hashtab();      /* attrib.c */
extern void init_flag_hashtab();       /* flags.c */

/* From bsd.c */
extern void do_new_spitfile();
extern void fcache_init();
extern void fcache_load();
extern void hide_player();
extern void do_motd();

/* From cque.c */
extern void do_notify();
extern void do_wait();
extern void do_queue();
extern void do_halt1();
extern void do_allhalt();

/* From create.c */
extern void do_open();
extern void do_link();
extern void do_unlink();
extern void do_clone();

/* From eval.c */
extern void do_list_functions();
extern void do_function();

/* From game.c */
extern void do_dump();
extern void do_shutdown();

/* From look.c */
extern void do_examine();
extern void do_inventory();
extern void do_find();
extern void do_whereis();
extern void do_score();
extern void do_sweep();
extern void do_entrances();
extern void do_decompile();

#ifdef USE_MAILER
/* From mail.c */
extern void do_mail();
extern void do_mail_stats();
extern void do_mail_debug();
#endif				/* USE_MAILER */

/* From move.c */
extern void do_get();
extern void do_drop();
extern void do_enter();
extern void do_leave();

/* From player.c */
extern void do_password();

/* From predicates.c */
extern void do_switch();
extern void do_verb();
extern void do_grep();

/* From rob.c */
extern void do_kill();
extern void do_give();
#ifdef ROBBERS
extern void do_rob();
#endif
extern void do_slay();

#ifdef ALLOW_RPAGE
/* From rpage.c */
extern void do_rpage();
extern void do_rpage_add();
extern void do_rpage_delete();
extern void do_rpage_list();
#endif				/* ALLOW_RPAGE */

/* From set.c */
extern void do_name();
extern void do_lock();
extern void do_unlock();
extern void do_chown();
extern void do_chzone();
extern void do_set();
extern void do_cpattr();
extern void do_gedit();
extern void do_trigger();
extern void do_use();
extern void do_parent();
extern void do_wipe();

/* From speech.c */
extern void do_say();
extern void do_oemit();
extern void do_whisper();
extern void do_pemit();
extern void do_pose();
extern void do_wall();
extern void do_page();
extern void do_think();
extern void do_emit();
extern void do_remit();
extern void do_lemit();
extern void do_zemit();

/* From wiz.c */
extern void do_debug_examine();
extern void do_enable();
extern void do_fixdb();
extern void do_kick();
extern void do_search();
#ifdef WCREAT
extern void do_pcreate();
#endif
#ifdef QUOTA
extern void do_quota();
extern void do_allquota();
#endif
extern void do_teleport();
extern void do_force();
extern void do_stats();
extern void do_toad();
extern void do_newpassword();
extern void do_boot();
extern void do_chzoneall();
extern int force_by_number();
extern void do_power();

/* From destroy.c */
extern void do_dbck();
extern void do_destroy();

