/* dump.c */

#include "copyright.h"

#include <stdio.h>
#include "config.h"
#include "db.h"

/* The following are needed so that modules that contain required code can
 * be linked in.. However the following routines do not NEED to do anything.
 */
/*****************************************************************************/

int paranoid_checkpt = 1;

FILE *checklog_fp = stderr;

ATTR *aname_hash_lookup(string)
     char *string;
{ return NULL; }

unsigned hash_fn()
{ return 0; }

void report()
{ }

dbref free_get()
{ return NOTHING; }

void fix_free_list()
{ }

void parse_que(player, command, cause)
    dbref player, cause;
    char *command;
{ }

int eval_boolexp(player, b, privs, nrecurs, locktype)
     dbref player;
     struct boolexp *b;
     dbref privs;
     int nrecurs;
     int locktype;
{ return 1; }

int wild_match(s, d)
    char *s, *d;
{ return 1; }

#define notify(p,m)     notify_check(p,m,0)

void notify_check(player, msg, no_puppet)
    dbref player;
    const char *msg;
    int no_puppet;
{ }

void init_match(player, arg, type)
    dbref player;
    const char *arg;
    int type;
{ }

void match_everything()
{ }

dbref match_thing(player, name)
     dbref player;
     const char *name;
{ return 1; }

dbref noisy_match_result()
{ return 1; }

char *tprintf(format, a, b, c, d, e, f)
    char *format;
    int a, b, c, d, e, f;
{ return (char *)""; }

void panic(message)
const char *message;
{
  fprintf(stderr, "PANIC: %s\n", message);
  exit(-1);
}

/*****************************************************************************/

/* in a dump, you can see everything */

int controls(who, what)
    dbref who;
    dbref what;
{
  return 1;
}

void main(argc, argv)
    int argc;
    char **argv;
{
  struct object *o;
  dbref owner;
  dbref thing;

  if (argc < 1) {
    fprintf(stderr, "Usage: %s [owner]\n", *argv);
    exit(1);
  }

  if (argc >= 2) {
    owner = atol(argv[1]);
  } else {
    owner = NOTHING;
  }

  if (db_read(stdin) < 0) {
    fprintf(stderr, "%s: bad input\n", argv[0]);
    exit(5);
  }

  for (o = db; o < db + db_top; o++) {
    /* don't show it if it isn't owned by the right player */
    if (owner != NOTHING && o->owner != owner)
      continue;

    printf("OBJECT #%d: %s [OWNER: %s(#%d)]\nLOC: %s\nPENNIES: %d\nTYPE: ",
	   o - db, o->name, db[o->owner].name, o->owner,
	   unparse_object(owner, o->location), o->penn);
    switch (o->flags & TYPE_MASK) {
      case TYPE_ROOM:
	printf("Room");
	break;
      case TYPE_EXIT:
	printf("Exit");
	break;
      case TYPE_THING:
	printf("Thing");
	break;
      case TYPE_PLAYER:
	printf("Player");
	break;
      default:
	printf("***UNKNOWN TYPE***");
	break;
    }

    /* handle flags */
    putchar('\n');
    if (o->flags & ~TYPE_MASK) {
      printf("TYPE FLAGS: ");
      switch(o->flags & TYPE_MASK) {
	case TYPE_PLAYER:
	  if(o->flags & PLAYER_UNFIND) printf("Unfind ");
	  if(o->flags & PLAYER_NOSPOOF) printf("Nospoof ");
	  if(o->flags & PLAYER_TERSE) printf("Terse ");
	  if(o->flags & PLAYER_MYOPIC) printf("Myopic ");
	  if(o->flags & PLAYER_MONITOR) printf("Monitor ");
	  if(o->flags & PLAYER_GAGGED) printf("Gagged ");
	  if(o->flags & PLAYER_SUSPECT) printf("Suspect ");
	  break;
        case TYPE_THING:
	  if(o->flags & THING_PUPPET) printf("Puppet ");
	  if(o->flags & THING_KEY) printf("Key ");
	  if(o->flags & THING_LISTEN) printf("Listener ");
	  if(o->flags & THING_SAFE) printf("Safe ");
	  if(o->flags & THING_STICKY) printf("Sticky ");
	  if(o->flags & THING_VERBOSE) printf("Verbose ");
#ifdef DESTROY
	  if(o->flags & THING_DEST_OK) printf("Destroy_ok ");
#endif /* DESTROY */
	  break;
        case TYPE_ROOM:
	  if(o->flags & LINK_OK) printf("Link_Ok ");
	  if(o->flags & ROOM_TEMPLE) printf("Temple ");
	  if(o->flags & ROOM_UNFIND) printf("Unfindable ");
	  if(o->flags & ROOM_ABODE) printf("Abode ");
	  if(o->flags & ROOM_JUMP_OK) printf("Jump_Ok ");
	  if(o->flags & ROOM_FLOATING) printf("Floating ");
	  if(o->flags & ROOM_NO_TEL) printf("No_Tel ");
	  if(o->flags & ROOM_STICKY) printf("Sticky ");
	  if(o->flags & ROOM_TRANSPARENT) printf("Transparent ");
	  break;
        case TYPE_EXIT:
	  if(o->flags & EXIT_TRANSPARENT) printf("Transparent ");
	  if(o->flags & EXIT_KEY) printf("Key ");
	  break;
      }
      printf("\nGENERAL FLAGS: ");
      if(o->flags & WIZARD) printf("Wizard ");
      if(o->flags & DARK) printf("Dark ");
      if(o->flags & HAVEN) printf("Haven ");
      if(o->flags & HALT) printf("Halt ");
      if(o->flags & AUDIBLE) {
	if ((o->flags & TYPE_MASK) != TYPE_PLAYER)
	  printf("Audible ");
	else
	  printf("Ansi_Display ");
      }
      if(o->flags & QUIET) printf("Quiet ");
#ifdef DESTROY
      if(o->flags & GOING) printf("Destroyed ");
#endif /* DESTROY */
      if(o->flags & CHOWN_OK) printf("Chown_Ok ");
      if(o->flags & ENTER_OK) printf("Enter_Ok ");
      if(o->flags & VISUAL) printf("Visual ");
      if(o->flags & OPAQUE) printf("Opaque ");
      if(o->flags & STARTUP) printf("Startup ");
#ifdef INHERIT_FLAG
      if(o->flags & INHERIT) printf("Inherit ");
#endif
#ifdef ROYALTY_FLAG
      if(o->flags & ROYALTY) printf ("Royalty ");
#endif
    }
    putchar('\n');

    if (o->key != TRUE_BOOLEXP)
      printf("KEY: %s\n", unparse_boolexp(owner, o->key, 0));
    if (((o->flags & TYPE_MASK) == TYPE_PLAYER)
	&& (o->usekey != TRUE_BOOLEXP))
      printf("USEKEY: %s\n", unparse_boolexp(owner, o->usekey, 0));
    if (o->enterkey != TRUE_BOOLEXP)
      printf("ENTERKEY: %s\n", unparse_boolexp(owner, o->enterkey, 0));
    if(o->list) {
      ALIST *list;
      ATTR *my_attr;
      printf("ATTRIBUTES:\n");
      for(list = o->list; list; list = AL_NEXT(list)) {
	if(!AL_BAD(list)) {
	  my_attr = AL_ATTR(list);
	  if(!strcasecmp("XYXXY", my_attr->name))
	    printf("\tPassword: %s\n", uncompress(AL_STR(list)));
	  else 
	    printf("\t%s: %s\n", my_attr->name, uncompress(AL_STR(list)));
        }
      }
    }
    if (o->contents != NOTHING) {
      printf("CONTENTS:\n");
      DOLIST(thing, o->contents) {
	/* dump thing description */
	printf("\t%s(%d) [OWNER: %s(%d)]\n",unparse_object(owner, thing),
	       thing, db[owner].name, owner);
      }
    }
    if (o->exits != NOTHING) {
      if ((o->flags & TYPE_MASK) == TYPE_ROOM) {
	puts("EXITS:\n");
	DOLIST(thing, o->exits) {
	  printf("\t%s ", unparse_object(owner, thing));
          if (db[thing].location != NOTHING) {
            printf(" => %s\n", unparse_object(owner, db[thing].location));
          } else {
            printf(" ***OPEN***\n");
          }
	  if (db[thing].key != TRUE_BOOLEXP) {
	    printf("\tKEY: %s\n",
		   unparse_boolexp(owner, db[thing].key, 0));
	  }
	}
      } else {
	printf("HOME: %s\n", unparse_object(owner, o->exits));
      }
    }
    putchar('\n');
  }
  exit(0);
}
