/* db.h */

#include "copyright.h"

#ifndef __DB_H
#define __DB_H
#include <stdio.h>

#include "attrib.h"
#include "flags.h"
#include "dbdefs.h"

/* Power macros */

#define Builder(x)       ((Powers(Owner(x)) & CAN_BUILD) || \
			  (Powers(x) & CAN_BUILD) || \
			  Hasprivs(x) || Hasprivs(Owner(x)))
#define Tel_Anywhere(x)  (Hasprivs(x) || (Powers(x) & TEL_ANYWHERE))
#define Tel_Anything(x)  (Hasprivs(x) || (Powers(x) & TEL_OTHER))
#define See_All(x)       (Hasprivs(x) || (Powers(x) & SEE_ALL))
#define Priv_Who(x)      (Hasprivs(x) || (Powers(x) & SEE_ALL))
#define Immortal(x)      (Powers(x) & IMMORTAL)
#define Can_Hide(x)      (Hasprivs(x) || (Powers(x) & CAN_HIDE))
#define Can_Login(x)     (Hasprivs(x) || (Powers(x) & LOGIN_ANYTIME))
#define Can_Idle(x)      (Hasprivs(x) || (Powers(x) & UNLIMITED_IDLE))
#define Long_Fingers(x)  (Hasprivs(x) || (Powers(x) & LONG_FINGERS))
#define Can_Boot(x)      (Wizard(x) || (Powers(x) & CAN_BOOT))
#define Do_Quotas(x)     (Wizard(x) || (Powers(x) & CHANGE_QUOTAS))
#define Change_Poll(x)   (Wizard(x) || (Powers(x) & SET_POLL))
#define HugeQueue(x)     (Wizard(x) || (Powers(x) & HUGE_QUEUE))
#define LookQueue(x)     (Hasprivs(x) || (Powers(x) & PS_ALL))
#define HaltAny(x)       (Wizard(x) || (Powers(x) & HALT_ANYTHING))
#define NoPay(x)         (Hasprivs(x) || Hasprivs(Owner(x)) || Immortal(x))
#define Search_All(x)    (Hasprivs(x) || (Powers(x) & SEARCH_ALL))
#define Global_Funcs(x)  (Wizard(x) || (Powers(x) & GLOBAL_FUNCS))
#define Create_Player(x) (Wizard(x) || (Powers(x) & CREATE_PLAYER))

/* Permission macros */

#ifdef PLAYER_LOCATE
#define Can_Locate(p,x)     (controls(p,x) || nearby(p,x) || \
			     ((Typeof(x) == TYPE_PLAYER) && \
			      !(Flags(x) & UNFIND) && \
			      !(Flags(Location(x)) & UNFIND)) || \
			     See_All(p))
#else
#define Can_Locate(p,x)     (controls(p,x) || nearby(p,x) || See_All(p))
#endif				/* PLAYER_LOCATE */

#define Can_Examine(p,x)    (controls(p,x) || See_All(p) || Visual(x))
#define can_link(p,x)  (controls(p,x) || \
			((Typeof(x) == TYPE_EXIT) && (Location(x) == NOTHING)))
#define can_link_to(p,x)    (GoodObject(x) && \
			     (controls(p,x) || (Flags(x) & LINK_OK)))

/* can p access attribute a on object x? */

#define Can_Read_Attr(p,x,a)   \
   (!((a)->flags & AF_DARK) && \
    (See_All(p) || \
     (!((a)->flags & AF_MDARK) && \
      (controls(p,x) || !((a)->flags & AF_ODARK) || Visual(x) || \
       (Owner((a)->creator) == Owner(p))))))

#define Can_Write_Attr(p,x,a)  \
   (Wizard(p) || (!((a)->flags & AF_WIZARD) &&   \
		  (!((a)->flags & AF_LOCKED) ||  \
		  ((a)->creator == Owner(p)))))

#endif				/* __DB_H */
