/*
    genesis.m  Subprogram to cheezmud.
    Copyright (C) 1995  David Flater.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "cheezmud.h"

void
adminrooms ()
{
  id t;

  t = [Room new];
  [t describe: "dave_workshop":
               "Dave's Workshop":
               "Dave's Workshop":
"This is a small, odd-shaped room with no obvious entrance or exit.\n\
Prominently located in the far corner, atop a strange piece of\n\
furniture that could only have come from a yard sale, is an ancient\n\
386 with a filthy white case.  It does not appear to be of any\n\
recognizable make or model.  One wall is obscured by a stack of\n\
gadgetry that is all interconnected by miles of wires and cables.  The\n\
other walls are covered by lewd posters.  There is also a small fridge\n\
with empty beer bottles and an incense burner sitting on top."];

  t = [Room new];
  [t describe: "paddedcell":
               "Padded Cell":
               "Padded Cell":
"This is a small, brightly lit room with padded walls and floor.  There\n\
are no obvious exits."];
}

id
impheadquarters ()
{
  id imp1a, imp1b, imp1s, imp0, imp2a, imp2b, imp2s, imp3s, roof,
  ofqwand, ofqcup, ofqsword, ofqcoin, ofkwand, ofkcup, ofksword, ofkcoin;

  // Pages are idiots who move about the castle and run away and pray
  // Knights attack on sight and hunt you down, but don't pray or exit
  // the castle
  // Queens, kings will fight back and run away when close to death

  // Mina takes care of replacing dead people

  //  Put 2 knights here
  imp1a = [Room new];
  [imp1a describe: "imp1a": "Imperial Headquarters": "Imperial Headquarters":
"You are in the hallway of a small castle that houses the imperial offices\n\
of this locality.  To the east and west are offices.  There is a spiral\n\
staircase leading up to the second floor.  The hallway continues to the north.\n\
The exit is south."];
  [[Page new] setlocation: imp1a];
  [[Page new] setlocation: imp1a];
  [[Page new] setlocation: imp1a];
  [[Page new] setlocation: imp1a];

  imp1b = [Room new];
  [imp1b describe: "imp1b": "Imperial Headquarters": "Imperial Headquarters":
"You are in the hallway of a small castle that houses the imperial offices\n\
of this locality.  To the east and west are offices.  The hallway continues\n\
to the south.  To the north are stairs."];
  [imp1b setexit: "s": imp1a];
  [imp1a setexit: "n": imp1b];

  imp1s = [Room new];
  [imp1s describe: "imp1s": "Stairwell": "Stairwell":
"You are in the stairwell of a small castle that houses the imperial offices\n\
of this locality.  You can go up or down, or enter the castle to the south."];
  [imp1b setexit: "n": imp1s];
  [imp1s setexit: "s": imp1b];

  imp0 = [Mina_shrine new];
  [imp0 setexit: "u": imp1s];
  [imp1s setexit: "d": imp0];

  imp2a = [Room new];
  [imp2a describe: "imp2a": "Imperial Headquarters": "Imperial Headquarters":
"You are in the hallway of a small castle that houses the imperial offices\n\
of this locality.  To the east and west are offices.  There is a spiral\n\
staircase leading down to the first floor.  The hallway continues to the north."];
  [imp2a setexit: "d": imp1a];
  [imp1a setexit: "u": imp2a];

  imp2b = [Room new];
  [imp2b describe: "imp2b": "Imperial Headquarters": "Imperial Headquarters":
"You are in the hallway of a small castle that houses the imperial offices\n\
of this locality.  To the east and west are offices.  The hallway continues\n\
to the south.  To the north are stairs."];
  [imp2b setexit: "s": imp2a];
  [imp2a setexit: "n": imp2b];

  imp2s = [Room new];
  [imp2s describe: "imp2s": "Stairwell": "Stairwell":
"You are in the stairwell of a small castle that houses the imperial offices\n\
of this locality.  You can go up or down, or enter the castle to the south."];
  [imp2b setexit: "n": imp2s];
  [imp2s setexit: "s": imp2b];
  [imp2s setexit: "d": imp1s];
  [imp1s setexit: "u": imp2s];

  imp3s = [Room new];
  [imp3s describe: "imp3s": "Stairwell": "Stairwell":
"You are in the stairwell of a small castle that houses the imperial offices\n\
of this locality.  You can go back down, or go out onto the roof to the south."];
  [imp3s setexit: "d": imp2s];
  [imp2s setexit: "u": imp3s];

  //  Put 2 knights here
  roof = [Room new];
  [roof describe: "imp3a": "Roof": "Roof":
"You are on the battlement of a small castle that houses the imperial\n\
offices of this locality.  To the north are the stairs to get back into the\n\
castle."];
  [roof setexit: "n": imp3s];
  [imp3s setexit: "s": roof];
  [[Knight new] setlocation: roof];
  [[Knight new] setlocation: roof];
  [[Knight new] setlocation: roof];
  [[Knight new] setlocation: roof];

  ofqwand = [Imp_Office new: "ofqwand"];
  [ofqwand describe: "ofqwand": "Office of the Queen of Wands":
  "Office of the Queen of Wands":
  "This tiny office is where the Queen of Wands normally does her work."];
  [ofqwand setexit: "e": imp1a];
  [imp1a setexit: "w": ofqwand];

  ofqcup = [Imp_Office new: "ofqcup"];
  [ofqcup describe: "ofqcup": "Office of the Queen of Cups":
  "Office of the Queen of Cups":
  "This tiny office is where the Queen of Cups normally does her work."];
  [ofqcup setexit: "w": imp1a];
  [imp1a setexit: "e": ofqcup];

  ofqsword = [Imp_Office new: "ofqsword"];
  [ofqsword describe: "ofqsword": "Office of the Queen of Swords":
  "Office of the Queen of Swords":
  "This tiny office is where the Queen of Swords normally does her work."];
  [ofqsword setexit: "e": imp1b];
  [imp1b setexit: "w": ofqsword];

  ofqcoin = [Imp_Office new: "ofqcoin"];
  [ofqcoin describe: "ofqcoin": "Office of the Queen of Coins":
  "Office of the Queen of Coins":
  "This tiny office is where the Queen of Coins normally does her work."];
  [ofqcoin setexit: "w": imp1b];
  [imp1b setexit: "e": ofqcoin];

  ofkwand = [Imp_Office new: "ofkwand"];
  [ofkwand describe: "ofkwand": "Office of the King of Wands":
  "Office of the King of Wands":
  "This tiny office is where the King of Wands normally does his work."];
  [ofkwand setexit: "e": imp2a];
  [imp2a setexit: "w": ofkwand];

  ofkcup = [Imp_Office new: "ofkcup"];
  [ofkcup describe: "ofkcup": "Office of the King of Cups":
  "Office of the King of Cups":
  "This tiny office is where the King of Cups normally does his work."];
  [ofkcup setexit: "w": imp2a];
  [imp2a setexit: "e": ofkcup];

  ofksword = [Imp_Office new: "ofksword"];
  [ofksword describe: "ofksword": "Office of the King of Swords":
  "Office of the King of Swords":
  "This tiny office is where the King of Swords normally does his work."];
  [ofksword setexit: "e": imp2b];
  [imp2b setexit: "w": ofksword];

  ofkcoin = [Imp_Office new: "ofkcoin"];
  [ofkcoin describe: "ofkcoin": "Office of the King of Coins":
  "Office of the King of Coins":
  "This tiny office is where the King of Coins normally does his work."];
  [ofkcoin setexit: "w": imp2b];
  [imp2b setexit: "e": ofkcoin];

  return imp1a;
}

void
startingtown ()
{
  id t, u, road1, road2, middleroad, imp;
  int a;

  t = [Room new];
  [t describe: "culdesac1":
               "Cul-De-Sac":
               "Cul-De-Sac":
"This is the end of the road -- or is it the beginning?  The path leads\n\
eastward; all other directions are blocked by a peculiar shrubbery that\n\
bristles with razor-sharp points and edges."];
  [[Sack new] setlocation: t];

  road2 = [Room new];
  [road2 describe: "road2": "On The Road": "On The Road":
"To the east the road widens.  The road continues west."];
  [road2 setexit: "w": t];
  [t setexit: "e": road2];
  [[Bob new] setlocation: road2];

  middleroad = [Room new];
  [middleroad describe: "middleroad":
               "Middle of the Road":
               "Middle of the Road":
"The road is wide here, leading east and west.  There are rows of chile peppers\n\
growing along each side of the road, where you might expect to see palm trees.\n\
To the north is the imperial headquarters; to the south, the Tech Center."];
  [[Bee new] setlocation: middleroad];
  [road2 setexit: "e": middleroad];
  [middleroad setexit: "w": road2];

  imp = impheadquarters ();
  [imp setexit: "s": middleroad];
  [middleroad setexit: "n": imp];

  road1 = [Room new];
  [road1 describe: "road1": "On The Road": "On The Road":
"To the west the road widens.  To the north is a small, creepy looking\n\
shack.  The road continues east."];
  [middleroad setexit: "e": road1];
  [road1 setexit: "w": middleroad];  

  t = [Room new];
  [t describe: "shack": "Creepy Shack": "Creepy Shack":
"This small shack shows signs of being lived in, but whoever lives here cares\n\
little for normal standards of cleanliness.  All manner of insect, spider, slug\n\
and rodent are peering at you with hungry eyes.  The exit is to the south."];
  [t setexit: "s": road1];
  [road1 setexit: "n": t];

  t = [Room new];
  [t describe: "culdesac2":
               "Cul-De-Sac":
               "Cul-De-Sac":
"This is the end of the road -- or is it the beginning?  The path leads\n\
westward; all other directions are blocked by a bizarre flaming shrubbery\n\
that grows out faster than the fire can consume it."];
  [[Sack new] setlocation: t];
  [[Lightbug new] setlocation: t];
  [[Lightbug new] setlocation: t];
  [road1 setexit: "e": t];
  [t setexit: "w": road1];

  u = [[Start new] setexit: "n": middleroad];
  [middleroad setexit: "s": u];

  t = [TechCenter new];
  [t setexit: "n": u];
  [u setexit: "s": t];

  u = [Darkroom new];
  [u describe: "underfloor":
               "Under the Floor":
               "Under the Floor":
"You are in deep dark hole in the floor of the Tech Center.  To the east\n\
you can see a dim, pulsing light at the end of a long crawlspace.  However,\n\
there is a big yellow and black sign next to the entrance to the crawlspace\n\
that says:  DO NOT ENTER THIS TUNNEL UNLESS YOU WANT TO GET YOUR DAMNFOOL HEAD\n\
BLOWN OFF!  You can return to the Tech Center by going up."];
  [u setdarkindef: "a dark hole"];
  [u setdarkdef: "the dark hole"];
  [u setdarklongdesc:
"It is too dark to see in here.  To the east you can see a dim, pulsing light,\n\
but every ounce of common sense you ever had is screaming at you not to go\n\
there until you can get some light down here and see what you are entering\n\
into.  You can return to the Tech Center by going up."];
  [[Spider new] setlocation: u];
  [t setexit: "d": u];
  [u setexit: "u": t];

  //  The Temple of Doom takes care of linking itself up.
  [[Chaingundude new] setlocation: [Doomroom new]];
  [[Shotgundude new] setlocation: [Doomroom new]];
  for (a=2;a<20;a++)
    [Doomroom new];
}


//  This function handles the creation of the world.

void
genesis ()
{
  adminrooms ();
  startingtown ();
}
