/*
    Shotgundude.m  Class definition.
    Copyright (C) 1995  David Flater.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "cheezmud.h"

@implementation Shotgundude

- init
{
  [super init];
  [self describe: "guerrilla": "a guerrilla": "the guerrilla":
  "This dude just stepped out of a Stallone movie.  He eats newbies for\n\
breakfast."];
  stamina = maxstamina = 60.0;
  movecount = 0;
  [[Shotgun new] setlocation: self];
  [[Flakjacket new] setlocation: self];
  strcpy (deadname, "guerrilla");
  strcpy (deaddef, "the dead guerrilla");
  strcpy (deadindef, "a dead guerrilla");
  strcpy (deaddesc, "This combat unit is inoperative.");
  return self;
}

- (void) heartbeat
{
  if (dead)
    return;
  [super heartbeat];

  //  Attack everything
  {
    void wasteEm (id whatever)
    {
      if ([whatever isKindOf: [Fighter class]] &&
          ((!([whatever isKindOf: [Chaingundude class]])) &&
           (!([whatever isKindOf: [Shotgundude class]]))))
        [enemies addElementIfAbsent: whatever];
    }
    [[location contents] withObjectsCall:wasteEm];
  }

  //  Move around (hit and run)
  if (++movecount == 13) {
    movecount = 0;
    [self runaway];
  }

}

- runaway
{
  int result, choice, loop;
  id w;
  if (!location)
    return self;
  for (loop=0;loop<12;loop++) {
    choice = random() % 6;
    result = 0;
    switch (choice) {
    case 0:
      result = [self do: "n"];
      break;
    case 1:
      result = [self do: "s"];
      break;
    case 2:
      result = [self do: "e"];
      break;
    case 3:
      w = [location dirquery: 'w'];
      if (!w)
        break;
      if (strcmp ([w mudname], "underfloor"))
        result = [self do: "w"];
      break;
    case 4:
      result = [self do: "u"];
      break;
    case 5:
      result = [self do: "d"];
      break;
    default:
      assert (0);
    }
    if (result)
      return self;
  }
  return self;
}

- (int) level
{
  return 4;
}

@end
