/*
    Queen.m  Class definition.
    Copyright (C) 1995  David Flater.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "cheezmud.h"

@implementation Queen

+ new: (char *) whose_office
{
  return [[self alloc] init: whose_office];
}

- init: (char *) whose_office
{
  [super init];
  [self setmudname: "queen"];
  [self setlongdesc: "This is one of the four queens of the Tarot Empire."];
  if (!strcmp (whose_office, "ofqcup")) {
    [self setdef: "the Queen of Cups"];
    [self setindef: "the Queen of Cups"];
    [[[Lightarmor new] describe: "armor": "fancy armor":
    "the fancy armor":
"This soft armor has been decorated with gold and silver to depict the Last\n\
Supper."] setlocation: self];
    [[Shortsword new] setlocation: self];
  } else if (!strcmp (whose_office, "ofqwand")) {
    [self setdef: "the Queen of Wands"];
    [self setindef: "the Queen of Wands"];
    [[Lightarmor new] setlocation: self];
    [[Staff new] setlocation: self];
  } else if (!strcmp (whose_office, "ofqsword")) {
    [self setdef: "the Queen of Swords"];
    [self setindef: "the Queen of Swords"];
    [[Lightarmor new] setlocation: self];
    [[Sword new] setlocation: self];
  } else /* ofqcoin */ {
    [self setdef: "the Queen of Coins"];
    [self setindef: "the Queen of Coins"];
    [[Shield new] setlocation: self];
    [[Shortsword new] setlocation: self];
  }
  stamina = maxstamina = 30.0;
  strcpy (deadname, "queen");
  strcpy (deaddef, "the dead queen");
  strcpy (deadindef, "a dead queen");
  strcpy (deaddesc, "The queen is dead.  Long live the queen!");
  return self;
}

- (int) level
{
  return 2;
}

@end
