/*
    Player.h  Class definition.
    Copyright (C) 1995  David Flater.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _PLAYER_H
#define _PLAYER_H

//  Class for player object.

#include "Fighter.h"

@interface Player: Fighter
{
  //  I don't want to mess with net.h here so I'll just use a void pointer
  void *tty;
  unsigned long experience;
}

//  ACTIONS

- l: who;
- names: who;
- examine: who: dobj;
- get: who: dobj;
- drop: who: dobj;
- inv: who;
- who: who;
- ver: who;

// Emotions
- smile: who;
- frown: who;
- giggle: who;
- grumble: who;
- laugh: who;
- yawn: who;
- cough: who;
- spit: who;
- hug: who: dobj;
- finger: who: dobj;
- kiss: who: dobj;

//  METHODS

- init;
- die;
- logout;
- help;

- (int) level;
- (float) maxstamina;

//  Get / set the struct conlist for this player.
- (void *) getty;
- setty: (void *) term;

//  Load / save player from db
- load;
- save;

//  Return priority of an action method.
- (float) priority: (char *) action: (int) numargs;

//  Display text on terminal.
- echo: (char *) text;

//  We'll get these from objects in our inventory.
- emote: emoter: (char *) verb_you: (char *) verb_he: (char *) emotion;
- emote: emoter: (char *) verb_you: (char *) verb_he: dobj: (char *) emotion;
- say: emoter: (char *) verb_you: (char *) verb_he: (char *) emotion;

//  Receive command from terminal.
- (int) ohce: (char *) text;

//  Receive experience for killing something.
- get_experience: (unsigned long) exp;
//  Check experience.
- (unsigned long) experience;

@end
#endif
