/*
    Pipe.m  Class definition.
    Copyright (C) 1995  David Flater.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "cheezmud.h"

@implementation Pipe

- init
{
  [super init];
  [self describe: "pipe": "the Pipe of Eternal Slack":
  "the Pipe of Eternal Slack":
  "This pipe was pried from the cold, dead teeth of \"Bob\" himself!  There\n\
is something written on it.  Say 'smoke' to puff some smoke; say 'smoke\n\
somebody' to blow smoke at somebody."];
  return self;
}

- getread: who
{
  [[who getlocation] emote: who: "read": "reads": self: ""];
  [who echo: "Don't let your slack EXPIRE!  Send a donation to:"];
  [who echo: "   The Church of the SubGenius"];
  [who echo: "   PO Box 140306"];
  [who echo: "   Dallas, TX 75214"];
  [who echo: "(or don't)"];
  return self;
}

- (float) priority: (char *) action: (int) numargs
{
  if (numargs == 1) {
    if (!strcmp (action, "smoke"))
      return 10.0;
  }
  if (numargs == 2) {
    if (!strcmp (action, "smoke"))
      return 10.0;
  }
  return [super priority: action: numargs];
}

- smoke: who
{
  [[who getlocation] emote: who: "puff": "puffs":
  " some smoke from the Pipe of Eternal Slack"];
  return self;
}

- smoke: who: dobj
{
  [[who getlocation] emote: who: "blow smoke at": "blows smoke at": dobj: ""];
  return self;
}

@end
