/*
    Page.m  Class definition.
    Copyright (C) 1995  David Flater.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "cheezmud.h"

@implementation Page

- init
{
  [super init];
  [self describe: "page": "a page": "the page":
  "This wimp runs errands for the king and queen in hopes of getting knighted\n\
someday."];
  stamina = maxstamina = 10.0;
  panic = 5;
  movecount = random() % 8;
  [[Tuxedo new] setlocation: self];
  [[Shortsword new] setlocation: self];
  strcpy (deadname, "page");
  strcpy (deaddef, "the dead page");
  strcpy (deadindef, "a dead page");
  strcpy (deaddesc, "This page has folded for the last time.");
  return self;
}

- (void) heartbeat
{
  if (dead)
    return;
  [super heartbeat];

  //  Move around
  if ([enemies isEmpty]) {
    if (++movecount == 8) {
      movecount = 0;
      [self walkabout];
    }
  }

}

- walkabout
{
  int result, choice, loop;
  id s;
  if (!location)
    return self;
  for (loop=0;loop<12;loop++) {
    choice = random() % 6;
    result = 0;
    switch (choice) {
    case 0:
      result = [self do: "n"];
      break;
    case 1:
      s = [location dirquery: 's'];
      if (!s)
        break;
      if (strcmp ([s mudname], "middleroad"))
        result = [self do: "s"];
      break;
    case 2:
      result = [self do: "e"];
      break;
    case 3:
      result = [self do: "w"];
      break;
    case 4:
      result = [self do: "u"];
      break;
    case 5:
      result = [self do: "d"];
      break;
    default:
      assert (0);
    }
    if (result)
      return self;
  }
  return self;
}

//  Run for the shrine
- runaway
{
  if (!location)
    return self;
  if (!(strcmp ([location mudname], "ofqwand") &&
        strcmp ([location mudname], "ofqsword") &&
        strcmp ([location mudname], "ofkwand") &&
        strcmp ([location mudname], "ofksword")))
    [self do: "e"];
  else if (!(strcmp ([location mudname], "ofqcup") &&
        strcmp ([location mudname], "ofqcoin") &&
        strcmp ([location mudname], "ofkcup") &&
        strcmp ([location mudname], "ofkcoin")))
    [self do: "w"];
  //  This is slightly bogus, but why bother coding it all out for the
  //  sake of some stupid Page that is lost in some stupid place whose
  //  name just happens to start with "imp"....
  if (!strncmp ([location mudname], "imp", 3)) {
    [self do: "n"];
    [self do: "n"];
    [self do: "d"];
    [self do: "d"];
    [self do: "d"];
    [self do: "pray"];
  }
  else
    [super runaway];

  return self;
}

@end
