/*
    Nonroom.h  Class definition.
    Copyright (C) 1995  David Flater.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _NONROOM_H
#define _NONROOM_H

//  Class for objects that have a location.

#include "Mudobject.h"

@interface Nonroom: Mudobject
{
  id location;
}

//  ACTIONS

//  METHODS

- init;
- free;
- logout;

//  Default level is 0
- (int) level;

- getlocation;
- setlocation: whereto;
- teleport: whereto;

//  Do an action.
- (int) do: (char *) someaction;

//  Return id of object to do action.
- resolve_action: (char *) action: (int) numargs;

//  What happens if somebody tries to read it
- getread: who;

//  Clone this object.
// - clone;

- hit: fromwho: (float) damage;

- theres_a_fight_going_on;

//  These have to be here to get rid of stupid compiler warnings.
- contents;
- find: (char *) what: (int) number;

@end
#endif
