/*
    Knight.m  Class definition.
    Copyright (C) 1995  David Flater.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "cheezmud.h"

@implementation Knight

- init
{
  [super init];
  [self describe: "knight": "a knight": "the knight":
  "This is a knight of the royal guard."];
  stamina = maxstamina = 15.0;
  movecount = random() % 8;
  [[Shield new] setlocation: self];
  [[Spear new] setlocation: self];
  strcpy (deadname, "knight");
  strcpy (deaddef, "the dead knight");
  strcpy (deadindef, "a dead knight");
  strcpy (deaddesc, "This is a former knight of the royal guard.");
  return self;
}

- (int) level
{
  return 1;
}

- (void) heartbeat
{
  if (dead)
    return;
  [super heartbeat];

  //  Move around
  if ([enemies isEmpty]) {
    if (++movecount == 8) {
      movecount = 0;
      [self runaway];
    }
  }

}

// Stay on the second and third floors
- runaway
{
  int result, choice, loop;
  id d;
  if (!location)
    return self;
  for (loop=0;loop<12;loop++) {
    choice = random() % 6;
    result = 0;
    switch (choice) {
    case 0:
      result = [self do: "n"];
      break;
    case 1:
      result = [self do: "s"];
      break;
    case 2:
      result = [self do: "e"];
      break;
    case 3:
      result = [self do: "w"];
      break;
    case 4:
      result = [self do: "u"];
      break;
    case 5:
      d = [location dirquery: 'd'];
      if (!d)
        break;
      if (strncmp ([d mudname], "imp1", 4))
        result = [self do: "d"];
      break;
    default:
      assert (0);
    }
    if (result)
      return self;
  }
  return self;
}

@end
