/*
    Fighter.h  Class definition.
    Copyright (C) 1995  David Flater.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _FIGHTER_H
#define _FIGHTER_H

//  This class provides useful functions to inherit for players and
//  fighting monsters.

#include "Container.h"

/* A pacifist will run away from combat.
   A warmonger will jump into a fray.
   A bystander will just stand there and not get involved. */
typedef enum {pacifist, warmonger, bystander} fightertype;

@interface Fighter: Container
{
  id enemies;
  int heartbeat_kill;
  float stamina, maxstamina;
  int panic;
  fightertype ftype;
  char deadname[20], deaddef[80], deadindef[80], deaddesc[80];
}

//  ACTIONS

- kill: who: dobj;

//  METHODS

- hit: fromwho: (float) damage;
- clue: dontkillme;
- unclue: killme;
- (int) checkkillflag;
- die;
- enemies;
- runaway;
- theres_a_fight_going_on;

- init;
- free;
- (void) heartbeat;
- killagain;

- (float) priority: (char *) action: (int) numargs;

//  Descriptions for listcontents.
- empty: who;
- nonempty: who;

- (float) health;
- (float) stamina;
- (float) maxstamina;
- (void) heal;

//  Receive experience for killing something.
- get_experience: (unsigned long) exp;

@end
#endif
