/*
    Corpse.m  Class definition.
    Copyright (C) 1995  David Flater.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "cheezmud.h"

@implementation Corpse

- init
{
  [super init];
  capacity = 1000000;
  return self;
}

- empty: who
{
  [who echo: "There is nothing to plunder."];
  return self;
}

- nonempty: who
{
  [who echo: "You could plunder the following:"];
  return self;
}

- (void) heartbeat
{
  //  Contents will be lost unless preserved here.  Make sure unique items
  //  don't vanish from the mud.
  void save_unique_items (id whatever)
  {
    if ([whatever isKindOf: [Sack class]]) {
      if (random() & 1)
        [whatever teleport: global_find ("culdesac1", 1)];
      else
        [whatever teleport: global_find ("culdesac2", 1)];
    //  Things that creepy leaves at his place
    } else if ([whatever isKindOf: [Spider class]] ||
               [whatever isKindOf: [Pipe class]]) {
      id shack = global_find ("shack", 1);
      char temp[160];
      [shack echo: "A creepy looking guy walks in and hisses at you."];
      sprintf (temp, "He drops off %s and leaves.", [whatever def]);
      [shack echo: temp];
      [whatever setlocation: shack];
    //  Already did sacks; recurse other containers.
    //  This code is untested since as of right now, the only other kind
    //  of container besides a Sack is a Corpse, and if a Corpse is carrying
    //  a Corpse, the innermost Corpse is older.  Since all Corpses are taken
    //  away after 10 minutes, it is impossible for a Corpse to arrive here
    //  still containing another Corpse!  In the event that things change in
    //  the future, I hope this code works.
    } else if ([whatever isKindOf: [Container class]])
      [[whatever contents] safeWithObjectsCall: save_unique_items];
  }
  if (++beatcount == 2400) {
    char temp[160];
    sprintf (temp, "A creepy looking guy appears out of nowhere, grabs \
%s, and vanishes.", [self def]);
    [location echo: temp];
    dead = 1;
    [contents safeWithObjectsCall: save_unique_items];
    [self logout];
  }
}

@end
