/*
    Bob.m  Class definition.

    "Bob" is property of the Church of the SubGenius.

    Address for donations:

         The Church of the SubGenius
         PO Box 140306
         Dallas, TX 75214
*/

#include "cheezmud.h"

@implementation Bob

- init
{
  [super init];
  [self describe: "\"Bob\"": "J.R. \"Bob\" Dobbs": "\"Bob\"":
  "\"Bob\" is smoking and grinning, as usual."];
  [[Pipe new] setlocation: self];
  ftype = bystander;
  return self;
}

//  This is extremely non-orthogonal and duplicates code from Fighter.m.
//  (But it does have slack)
- hit: fromwho: (float) damage
{
  id c;
  if (dead)
    return self;
  dead = 1;
  [location emote: self: "expire": "expires": " in a terminal puff of smoke"];
  //  Kluge:  theres_a_fight_going_on doesn't work if you get killed in
  //  one swipe, since you are not there for your buddies to query on who
  //  just killed you.  This works around that by calling it special just
  //  before you die.
  [location theres_a_fight_going_on];
  c = [[[Corpse new] describe: "\"Bob\"": "the corpse of \"Bob\"":
  "the corpse of \"Bob\"": "Somebody met \"Bob\" on the road, and killed him."]
  setlocation: location];
  [contents safeMakeObjectsPerform: @selector(setlocation:) with: c];
  //  Killing "Bob" gets you a big bonus and is the quickest way to level 2.
  [fromwho get_experience: (unsigned long) 100];
  [self logout];
  return self;
}

- echo: (char *) text
{
  char n[80], o[80];
  if (!strstr (text, " says: "))
    return self;
  if (!strstr (text, "slack") && !strstr (text, "SLACK"))
    return self;
  if (sscanf (text, "%s", n) != 1)
    return self;
  sprintf (o, "smoke %s", n);
  [self do: o];
  return self;
}

@end
