
#include <sys/time.h>
#include <stdio.h>

#include "keyboard.h"


X11_Keyboard:: X11_Keyboard(Display** D) : TTY_Keyboard()
{
	display  = D;
	extended = 0;
}

// X11 raw/cooked doesn't mean anything.
int
X11_Keyboard:: raw(int newstate)
{
	keyboard_state = newstate;
	return(0);
}

// Kind of a kludge, we either block or don't block, nothing in between.
int
X11_Keyboard:: pending_input(float do_wait)
{
	XEvent event;
	int pending;

	if ( ! *display )
		return(TTY_Keyboard::pending_input(do_wait));
	
	/* Check the pending input */
	if ( ! do_wait ) {
		pending = XPending(*display);
		while ( pending ) {
			XNextEvent(*display, &event);
			if ( event.type == KeyPress )
				return(1);
		}
		return(0);
	}
		
	// Block until we recieve input.
	for ( ; ; ) {
		// Get the next event
		XPeekEvent(*display, &event);

		// Check if keypress, if not, suck it up.
		if ( event.type == KeyPress )
			return(1);
		else {
			XNextEvent(*display, &event);
			switch (event.type) {

				case Expose:
					if ( do_refresh )
						(*App_Refresh)();
					break;
				default:	// Ignore the event
					break;
			}
		}
				
	}
	/* NOTREACHED */
}


int
X11_Keyboard:: ExtendKey(KeySym key)
{
static struct { KeySym sym; char *string; int value; } func_keys[] = {
	{ XK_F1,	"[11~", 	F1 },
	{ XK_F2,	"[12~", 	F2 },
	{ XK_F3,	"[13~", 	F3 },
	{ XK_F4,	"[14~", 	F4 },
	{ XK_F5,	"[15~", 	F5 },
	{ XK_F6,	"[17~", 	F6 },
	{ XK_F7,	"[18~", 	F7 },
	{ XK_F8,	"[19~", 	F8 },
	{ XK_Up,	"[A", 	UP },
	{ XK_Page_Up,	"[5~", 	PGUP },
	{ XK_Left,	"[D", 	LEFT },
	{ XK_Right,	"[C", 	RIGHT },
	{ XK_Down,	"[B", 	DOWN },
	{ XK_Page_Down,	"[6~", 	PGDN },
	{ XK_Home,	"[H",	 	HOME },
	{ XK_End,	"Ow", 	END },
/* Terminate the list */
	{ 0, NULL, 0 } };

	// Otherwise, it's a complex function key:
	for ( int i=0; func_keys[i].string; ++i ) {
		if ( key == func_keys[i].sym )
			return(func_keys[i].value);
	}
	return(0);
}

int
X11_Keyboard:: getch(void)
{
	XEvent event;
	int count;
	char key_string[256];
	int pending;
	KeySym keysym;
	XComposeStatus compose;

	// If we don't have a display, just return characters from tty.
	if ( ! *display )
		return(TTY_Keyboard::getch());

	/* If there is an extended key, return it. */
	if ( extended ) {
		pending = ExtendKey(extended);
		extended = 0;
		return(pending);
	}

	for ( pending=0, count=0; count == 0; )
	{
		/* Wait here for an event and then get the number waiting */
		XPeekEvent(*display, &event);  /* This function blocks */
		pending = XPending(*display);
		
		/* Handle any events pending */
		while (pending > 0)
		{
			/* Get the next X event thanks */
			XNextEvent(*display, &event);

			switch(event.type)
			{
#ifdef WE_HAVE_AN_EVENT_MASK
				case UnmapNotify:
					/* Turn off just all events except the mapping ones */
    					XSelectInput(*display, MainWin, StructureNotifyMask);
					break;

				case MapNotify:
					/* Turn back on all the events 
							that are needed */
    					XSelectInput(*display, MainWin, 
								Event_mask);
					break;
#endif /* WE_HAVE_AN_EVENT_MASK */

				case Expose:
					if ( do_refresh )
						(*App_Refresh)();
					break;
#ifdef HANDLE_MOUSE
				case ButtonRelease:
					handleMouseButtons(*display, event, False);
					break;

				case ButtonPress:
					handleMouseButtons(*display, event, True);
					break;

				case MotionNotify:
					handleMouseMotion(*display, event);
					break;
#endif /* HANDLE_MOUSE */

#ifdef HANDLE_KEYRELEASE
				case KeyRelease:
					keysym = GetKeySym(event);
					handleKeyPress(*display, keysym, event, False);
					break;
#endif /* HANDLE_KEYRELEASE */

				case KeyPress:
					count = 
	XLookupString(&event.xkey, key_string, 256, &keysym, &compose);
					goto pressedkey;

				default:
					break;
			}

			/* Decrement the number of pending events */
			pending--;
		}
	}

  pressedkey:
	if ( count ) 
		return(key_string[0]);

	extended = keysym;
	return(0);
}
