
#ifndef X11_Graphics_h
#define X11_Graphics_h

/**********************************************************************/
/*                                                                    */
/*  Much of the X11 color code has been taken from dosemu0.56         */
/*                                                                    */
/*      -Thanks! :)                                                   */
/*                                                                    */
/**********************************************************************/

#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>

#define PROGNAME	"xdhe"

#define X11_BLACK       0
#define X11_BLUE        1
#define X11_GREEN       2
#define X11_CYAN        3
#define X11_RED         4
#define X11_MAGENTA     5
#define X11_YELLOW      6
#define X11_WHITE       7

#define NUM_COLORS	256	/* Pseudo-color display with 256 colors */

#define FONT_WIDTH	8
#define FONT_HEIGHT	8
#define DISPLAY_WIDTH	(FONT_WIDTH*80)
#define DISPLAY_HEIGHT	(FONT_HEIGHT*50)

// The X11 graphics module:

class X11_Graphics : public TTY_Graphics {

public:
	X11_Graphics();
	virtual ~X11_Graphics();

	virtual int ibm_charset(void);
	virtual void flush(void);
	virtual void setcursor(int on);
	virtual void set_default_colors(void);
	virtual void set_colors(int bright, int fg, int bg);
	virtual void clear(void);
	virtual void clrbox(int x, int y, int width, int height);
	virtual void clreol(void);
	virtual void gotoxy(int x, int y);
	virtual void putch(int ch);
	virtual int has_graphics(void);
	virtual void set_grmode(int newmode);
	virtual void set_colormap(struct color colormap[256]);
	virtual void clr_grscreen(void);
	virtual void put_graphics_txt(int x, int y, char *string, 
							unsigned char color);
	virtual void drawpoint(int x, int y, unsigned char color);

protected:
	virtual int OpenMainWindow(int mode);
	virtual void Map_Color(Colormap colormap, XColor *xcol);
	virtual void expand_8x8font(char smallfont[], char bigfont[]);

	Display *display;		// The X11 display connection
	Window   MainWin;		// Our window on the display
	unsigned long Event_mask;	// The events we wait for
	XImage  *xwindow;		// Our in-core image of our window
	Colormap vga_colormap;		// The 16 color VGA colormap
	Colormap vis_colormap;		// The 256 color VGA colormap
	GC            gc;		// Our current graphics context
	unsigned long vga_colors[16];	// The standard IBM colors (pixels)
	unsigned long fg, bg;		// Current colors 
	int  bright;			// Current brightness
	XImage  *pc8x8[256];		// The 8x8 bitmap font
	struct {
		int x, y;
		} cursor;		// The current cursor location 
	XImage  *vga_cursor;		// The 8x8 cursor image
	XImage  *undercursor;		// The image behind the cursor
	int      cursor_on;		// Do we draw the cursor?
	GC	 cursor_gc;		// An XOR GC for the cursor
};

#endif
