
#include <stdio.h>
#include <string.h>
#include <sys/types.h>

#include "dehacked.h"
#include "linux_text.h"

// If you update this structure, be SURE you update the header. :)
struct string_struct lnx_strings[LNX_NTEXTSEGS] = {
	// Messages...
	{ 0x101A7,	(0x10566-0x101A7), NULL, 0 },
	// More messages...
	{ 0xCDDB,	(0xCE60-0xCDDB), NULL, 0 },
	// Even more messages...
	{ 0xD1A1,	(0xD214-0xD1A1), NULL, 0 },
	// Level ending texts...
	{ 0x480,	(0x1223-0x480), NULL, 0 },
	// Textures names...
	{ 0x1223,	(0x126C-0x1223), NULL, 0 },
	// Monster names...
	{ 0x16F0,	(0x17B5-0x16F0), NULL, 0 },
	// Command line options...
	{ 0x3293,	(0x35AB-0x3293), NULL, 0 },
	// More command line options...
	{ 0x3664,	(0x3C3E-0x3664), NULL, 0 },
	// Level names...
/*	{ 0x27E62,	(0x27F09-0x27E62), NULL, 0 }, */
	{ 0x25300,	(0x257d9-0x25300), NULL, 0 },
	// Sprite names...  (in reverse order)
	{ 0x27AC4,	(0x27D76-0x27AC4), NULL, 0 },
	// Sound names...  (in reverse order)
	{ 0x27F0F,	(0x281DA-0x27F0F), NULL, 0 },
	// Cheat texts...
	{ 0x23A63,	(0x23B88-0x23A63), NULL, 0 },
};

void lnx_loadtxt(char *buffer, int *len, int *nobjs, FILE *fp)
{
	char *o, *p;
	int i, j, S;

	for ( *len=0, i=0; i<LNX_NTEXTSEGS; ++i ) {
		fseek(fp, lnx_strings[i].offset, SEEK_SET);
		fread((void *)buffer, lnx_strings[i].length, 1, fp);
		for ( p=buffer, j=0, S=1; j<lnx_strings[i].length; ++j, ++p )
		{
			if ( ! *p ) 
				++S;
		}
		lnx_strings[i].text = new char *[S];
		for ( o=p=buffer, j=0, S=0; j<lnx_strings[i].length; ++j, ++p )
		{
			if ( ! *p ) {
				lnx_strings[i].text[S++] = o;
				o = p+1;
			}
		} 
		lnx_strings[i].text[S] = NULL;
		lnx_strings[i].nstrings = S;
		*nobjs += S;
		*len += lnx_strings[i].length;
		buffer += lnx_strings[i].length;
	}
}

void lnx_writetxt(FILE *fp)
{
	int i;

	for ( i=0; i<LNX_NTEXTSEGS; ++i ) {
		fseek(fp, lnx_strings[i].offset, SEEK_SET);
		fwrite((void *)lnx_strings[i].text[0], 
						lnx_strings[i].length, 1, fp);
	}
}

void lnx_savetxt(char *textorigp, char *textdatap, int len, FILE *patchp)
{
	int i;

	for ( i=0; i<len; ++i ) {
		if ( strcmp(textorigp+i, textdatap+i) != 0 ) {
			fprintf(patchp, "\nText %d %d\n%s%s\n",
	strlen(textdatap+i), strlen(textorigp+i), textdatap+i, textorigp+i);
		}
		while ( (i < len) && *(textdatap+i) ) ++i;
	}
}

EBool lnx_matchtxt(char *textdatap, int len, char *string, int *offset)
{
	int i;

	for ( i=0; i<len; ++i ) {
		if ( strcmp(textdatap+i, string) == 0 ) {
			*offset = i;
			return YES;
		}
		while ( (i < len) && *(textdatap+i) ) ++i;
	}
	return NO;
}
