// DeHackEd version 2.3
// Written by Greg Lewis, gregl@umich.edu
// If you release any versions of this code, please include
// the author in the credits.  Give credit where credit is due!

// Function prototypes
int  Checkforfile(char *doomfile, char *arg1, char *doomname, char *type, FILE **fp);
void Convertpatch(FILE *patchp, char patchformat);
int  CreateDiffSave(FILE *patchp);
void CreateDoomhack(void);
int  GetDoomFiles(char *arg1);
int  GetNextLine(char *nextline, int *numlines, FILE *patchp);
int  LoadDiff(FILE *patchp);
void Loaddoom(FILE *exefp);
int  LoadOld(FILE *patchp, EBool commandline);
int  Loadpatch(char *filename, EBool commandline);
int  OldSave(char *filename, EBool Overwrite);
void Parseconfigfile(void);
void Preparefilename(char *fullname);
int  ProcessLine(char *nextline, char **line2);
int  Savepatch(char *filename, EBool Overwrite);
int  Searchforentry(char *name, ResourceS *entry);
void Writedoom(void);

// Offsets in the exe...
// Note: SGI X11 Doom is not yet supported!
long offset[NUMDATA][NUMVERS] =
		{0x8b3c8L, 0x9ed10L, 0x9ed10L, 0xa4400L, 0x45a48L, 0x44a48L, 0x6b77cL,	// Thing
		 0x8714cL, 0x971d4L, 0x971d4L, 0x9c8c4L, 0x48fe8L, 0x47fe8L, 0x6ed24L,	// Sound
		 0x87ba8L, 0x9834cL, 0x9834cL, 0x9da3cL, 0x3f084L, 0x3e084L, 0x64db8L,	// Frame
		 0x87a04L, 0x98124L, 0x98124L, 0x9d814L, 0x3ee5cL, 0x3de5cL, 0x64b90L,	// Sprite
		 0x85b7cL, 0x95714L, 0x95714L, 0x9ad84L, 0x3d754L, 0x3c754L, 0x63430L,	// Ammo
		 0x85b9cL, 0x95734L, 0x95734L, 0x9ada4L, 0x3d774L, 0x3c774L, 0x63450,	// Weapon
		 0x6f414L, 0xa2228L, 0xa2228L, 0xa7918L, 0x0L,		0x0L,     0x6fcd0L,};		// Text

// Selected text offsets showing minor text differences in versions
int diffoffset[5][3] = {   0,    0,    0,  // Doom 1.2 (N/A)
								6936, 7020, 7104,  // Doom I/1.666
									0, 	0, 	0,  // Doom ][/1.666 (N/A)
								6936, 7016, 7096,  // Doom ][/1.7
								6936, 7016, 7100}; // Doom ][/1.7a

// Main variables from dehacked.cpp
extern char thingorder[THING_FIELDS];
extern int  numobj[NUMDATA][NUMVERS];					// Number of objects for dif version
extern char doomexe[80];					// Doom.exe file name
extern char doombak[80];
extern char doomwad[80];					// Doom.wad file name
extern char doompath[80];					// Directory to run doom from
extern char doomargs[80];					// Arguments when Doom is run
extern char patchdir[80];					// Patch file directory
extern EVersions version;					// The Doom version we're using
extern ETruever  truever;					// The "real" Doom version we're using
extern FILE *doomexefp;						// File pointer to doom.exe
extern FILE *doombakfp;
extern FILE *doomwadfp;						// File pointer to doom.wad
extern char curdir[MAXPATHLEN+1];				// Directory at start of program
extern long doomsize;

// The data arrays
extern unsigned long (*thingdata )[THING_FIELDS];
extern unsigned long (*framedata )[FRAME_FIELDS];
extern unsigned long (*sounddata )[SOUND_FIELDS];
extern unsigned long (*weapondata)[WEAPON_FIELDS];
extern unsigned long *spritedata;
extern unsigned long *maxammodata;
extern unsigned long *perammodata;
extern char *textdatap;

extern int size[NUMDATA][NUMVERS];

// Functions from dehacked.cpp
extern void AbortProg(char *func);

// Functions from print.cpp
extern int   Printinputwindow(char *buffer, char *prompt, EInptype type,
										int length);
extern void  Printoptions(void);
extern EBool Printwindow(char *message, int type);

// Data from print.h
extern char *datanames[NUMDATA];
extern char *thingfields[THING_FIELDS];
extern char *soundfields[7];
extern char *framefields[7];
extern char *weaponfields[7];
extern char *ammolist[9];
extern char *weaponlist[9];
extern char *namelist[160];

// Thing conversion array from 1.2 to 1.666
unsigned char thingconvar[104]={ 0,  11,   1,   2,  12,  13,  14,  18,  15,  19,
										  21,  30,  31,  32,  16,  33,  34,  35,  37,  38,
										  39,  41,  42,  43,  44,  45,  46,  47,  48,  49,
										  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,
										  60,  61,  63,  64,  65,  66,  67,  68,  69,  70,
										  71,  72,  73,  74,  75,  76,  77,  81,  82,  83,
										  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,
										  94,  95,  96,  97,  98,  99, 100, 101, 102, 103,
										 104, 105, 106, 107, 108, 109, 110, 111, 112, 113,
										 114, 115, 116, 117, 118, 119, 120, 121, 122, 123,
										 124, 125, 126, 137};

// Frame conversion array from 1.2 to 1.666
int frameconvar[512]={	0,   1,   2,   3,   4,   5,   6,   7,   8,   9,
							  10,  11,  12,  13,  14,  15,  16,  17,  18,  19,
							  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,
							  30,  31,  49,  50,  51,  52,  53,  54,  55,  56,
							  57,  58,  59,  60,  61,  62,  63,  64,  65,  66,
							  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,
							  77,  78,  79,  80,  81,  82,  83,  84,  85,  86,
							  87,  88,  89,  90,  91,  92,  93,  94,  95,  96,
							  97,  98,  99, 100, 101, 102, 103, 104, 105, 106,
							 522, 523, 524, 525, 526, 107, 108, 109, 110, 111,
/* 100 */				 112, 113, 114, 115, 116, 117, 118, 119, 120, 121,
							 122, 123, 124, 125, 126, 127, 128, 129, 149, 150,
							 151, 152, 153, 154, 155, 156, 157, 158, 159, 160,
							 161, 162, 163, 164, 165, 166, 167, 168, 169, 170,
							 171, 172, 173, 174, 175, 176, 177, 178, 179, 180,
							 181, 182, 183, 184, 185, 186, 187, 188, 189, 190,
							 191, 192, 193, 194, 195, 196, 197, 198, 199, 200,
							 201, 202, 207, 208, 209, 210, 211, 212, 213, 214,
							 215, 216, 217, 218, 219, 220, 221, 222, 223, 224,
							 225, 226, 227, 228, 229, 230, 231, 232, 233, 234,
/* 200 */				 235, 442, 443, 444, 445, 446, 447, 448, 449, 450,
							 451, 452, 453, 454, 455, 456, 457, 458, 459, 460,
							 461, 462, 463, 464, 465, 466, 467, 468, 469, 475,
							 476, 477, 478, 479, 480, 481, 482, 483, 484, 485,
							 486, 487, 488, 489, 490, 491, 492, 493, 494, 495,
							 502, 503, 504, 505, 506, 507, 508, 509, 510, 511,
							 512, 513, 514, 515, 527, 528, 529, 530, 531, 532,
							 533, 534, 535, 536, 537, 538, 539, 540, 541, 542,
							 543, 544, 545, 546, 547, 548, 585, 586, 587, 588,
							 589, 590, 591, 592, 593, 594, 595, 596, 597, 598,
/* 300 */				 599, 600, 601, 602, 603, 604, 605, 606, 607, 608,
							 609, 610, 611, 612, 613, 614, 615, 616, 617, 618,
							 619, 620, 621, 622, 623, 624, 625, 626, 627, 628,
							 629, 630, 631, 674, 675, 676, 677, 678, 679, 680,
							 681, 682, 683, 684, 685, 686, 687, 688, 689, 690,
							 691, 692, 693, 694, 695, 696, 697, 698, 699, 700,
							 130, 131, 132, 133, 134, 135, 136, 137, 138, 139,
							 140, 141, 802, 803, 804, 805, 806, 807, 808, 809,
							 810, 811, 812, 816, 817, 818, 819, 820, 821, 822,
							 823, 824, 825, 826, 827, 828, 829, 830, 831, 832,
/* 400 */				 833, 834, 835, 836, 837, 838, 839, 840, 841, 842,
							 843, 844, 845, 846, 847, 848, 849, 850, 851, 852,
							 853, 854, 855, 856, 861, 862, 863, 864, 865, 866,
							 867, 868, 869, 870, 871, 872, 873, 874, 875, 876,
							 877, 878, 879, 880, 881, 882, 883, 884, 886, 887,
							 888, 889, 890, 891, 892, 893, 894, 895, 896, 897,
							 898, 899, 900, 901, 902, 903, 904, 905, 906, 907,
							 908, 909, 910, 911, 912, 913, 914, 915, 916, 917,
							 918, 919, 920, 921, 922, 923, 924, 925, 926, 927,
							 928, 929, 930, 931, 932, 933, 934, 935, 936, 937,
/* 500 */				 938, 939, 940, 941, 942, 943, 944, 945, 946, 947,
							 948, 949};

// Sound conversion array from 1.2 to 1.666
unsigned char soundconvar[63] = { 0,  1,  2,  3,  8,  9, 10, 11, 12, 13,
											14, 15, 16, 17, 18, 19, 20, 21, 22, 23,
											24, 25, 26, 27, 31, 32, 33, 34, 35, 36,
											37, 38, 39, 40, 41, 42, 43, 44, 45, 51,
											52, 55, 57, 59, 60, 61, 62, 63, 64, 65,
											66, 67, 68, 69, 75, 76, 77, 81, 82, 83,
											84, 85, 86};

// Sprite conversion array from 1.2 to 1.666
unsigned char spriteconvar[105]={  0,   1,   2,   3,   4,   5,   7,   8,   9,  10,
											 11,  12,  13,  14,  15,  16,  17,  18,  19,  41,
											 20,  21,  22,  23,  24,  25,  28,  29,  30,  39,
											 40,  42,  44,  45,  49,  26,  55,  56,  57,  58,
											 60,  61,  62,  63,  64,  65,  66,  67,  68,  69,
											 70,  71,  72,  73,  75,  76,  77,  78,  79,  80,
											 81,  82,  83,  84,  85,  86,  87,  88,  89,  90,
											 91,  92,  94,  95,  96,  97,  98,  99, 100, 101,
											102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
											112, 113, 114, 115, 116, 117, 118, 119, 120, 121,
											122, 123, 124, 125, 126};
