
#include <stdio.h>

main(int argc, char *argv[])
{
	FILE *file;
	char *data;
	unsigned int datalen;
	unsigned long offset;

	if ( argc != 4 ) {
		fprintf(stderr, "Usage: %s <file> <offset> <len>\n", argv[0]);
		exit(0);
	}

	if ( (file=fopen(argv[1], "r")) == NULL ) {
		perror(argv[1]);
		exit(255);
	}
	sscanf(argv[2], "%lx", &offset);
	sscanf(argv[3], "%d", &datalen);
	if ( fseek(file, offset, SEEK_SET) != 0 ) {
		perror("fseek() error");
		exit(255);
	}
	if ( ! (data=(char *)malloc(datalen)) ) {
		perror("malloc() error");
		exit(255);
	}
	if ( fread(data, datalen, 1, file) == 1 ) {
		fwrite(data, datalen, 1, stdout);
	} else {
		perror("short read");
		exit(255);
	}
	exit(0);
}
