/* WATCOMC reimplementation of the GO32 text functions
*/

#ifndef __WINDOWS__

#include <graph.h>
#include <bios.h>

#define CTRL 0x4
#define ALT 0x8

static unsigned char ansi_unalt[] = {
/*000*/   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/*016*/ 'Q','W','E','R','T','Y','U','I','O','P','[',']',  0,  0,'A','S',
/*032*/ 'D','F','G','H','J','K','L',';','\'','`',0,'\\','Z','X','C','V',
/*048*/ 'B','N','M',',','.','/',  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/*064*/   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/*080*/   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/*096*/   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/*112*/   0,  0,  0,  0,  0,  0,  0,  0,'1','2','3','4','5','6','7','8',
/*128*/ '9','0','_','=',  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/*144*/   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/*160*/   0,  0,  0,  0,  0,  0, 13,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/*176*/   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/*192*/   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/*208*/   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/*224*/   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/*240*/   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
};


int
getkey()
{ unsigned key = _bios_keybrd(_KEYBRD_READ);
  int ch = key&0xff;
  
  if ( ch == ' ' )
  { unsigned status = _bios_keybrd(_KEYBRD_SHIFTSTATUS);

    if ( status & CTRL )
      ch = 0;
  } else if ( ch == 0 )
  { unsigned code = key >> 8;
    ch = ansi_unalt[code] + 128;
  }

  return ch;
}


static void
ScreenInit()
{ static int done = 0;

  if ( !done )
  { _setvideomode(_DEFAULTMODE);
    done++;
  }    
}


void
ScreenGetCursor(int *row, int *col)
{ struct rccoord pos = _gettextposition();

  *row = pos.row-1;
  *col = pos.col-1;
}


void
ScreenSetCursor(int row, int col)
{ _settextposition(row+1, col+1);
}


int
ScreenCols()
{ short r1, c1, r2, c2;

  _gettextwindow(&r1, &c1, &r2, &c2);
  return 1 + c2 - c1;
}


int
ScreenRows()
{ short r1, c1, r2, c2;

  _gettextwindow(&r1, &c1, &r2, &c2);
  return 1 + r2 - r1;
}

#endif /*__WINDOWS__*/
