/* readline.c -- a general facility for reading lines of input
   with emacs style editing and completion. */

/* Copyright (C) 1987, 1989, 1992 Free Software Foundation, Inc.

   This file is part of the GNU Readline Library, a library for
   reading lines of text with interactive input and history editing.

   The GNU Readline Library is free software; you can redistribute it
   and/or modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 1, or
   (at your option) any later version.

   The GNU Readline Library is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   The GNU General Public License is often shipped with GNU software, and
   is generally kept in a file called COPYING or LICENSE.  If you do not
   have a copy of the license, write to the Free Software Foundation,
   675 Mass Ave, Cambridge, MA 02139, USA. */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <windows.h>
#include <stdio.h>
#include <console.h>
#include <uxnt.h>
#include <readline/readline.h>
#include <readline/history.h>
#include <stdlib.h>
#include <malloc.h>

main(int argc, char **argv)
{
  HIST_ENTRY **history_list ();
  char *temp = (char *)NULL;
  char *prompt = "readline% ";
  int done = 0;
  int i;

  rl_printf("argc = %d; argv = ", argc);
  for(i=0; i<argc; i++)
    rl_printf("\"%s\" ", argv[i]);
  rl_printf("\n\n");

  while (!done)
    {
      temp = readline (prompt);

      /* Test for EOF. */
      if (!temp)
	exit (1);

      /* If there is anything on the line, print it and remember it. */
      if (*temp)
	{
	  rl_eprintf ("%s\r\n", temp);
	  add_history (temp);
	}

      /* Check for `command' that we handle. */
      if (strcmp (temp, "quit") == 0)
	done = 1;
      else if (strcmp (temp, "list") == 0)
	{
	  HIST_ENTRY **list = history_list ();
	  register int i;
	  if (list)
	    {
	      for (i = 0; list[i]; i++)
		{
		  rl_eprintf ("%d: %s\r\n", i, list[i]->line);
		  free (list[i]->line);
		}
	      free (list);
	    }
	}
      else if ( strcmp(temp, "read Pce") == 0 )
      { FILE *fd;
	char line[1024];

	if ( (fd = fopen("/e:/src/xpce/Pce", "r")) )
	{ rl_eprintf("fd = 0x%x\n", (unsigned) fd);
	  while(fgets(line, sizeof(line), fd))
	  { rl_eprintf(".");
	    rl_flush();
	  }
	  rl_eprintf("\n");
	} else
	  rl_eprintf("Failed to open\n");

	fclose(fd);
      }
      free (temp);
    }

    return 0;
}

		 /*******************************
		 *	       MAIN		*
		 *******************************/

int PASCAL
WinMain(HANDLE hInstance, HANDLE hPrevInstance,
	LPSTR lpszCmdLine, int nCmdShow)
{ /*S__iob = S__getiob();*/

  return rlc_main(hInstance, hPrevInstance, lpszCmdLine, nCmdShow, main, NULL);
}
