/*  $Id$

    Designed and implemented by Jan Wielemaker
    E-mail: jan@swi.psy.uva.nl

    Copyright (C) 1994 University of Amsterdam. All rights reserved.
*/

#ifndef _CONSOLE_H_INCLUDED
#define _CONSOLE_H_INCLUDED

#include <signal.h>

#ifndef SIGWINCH
#define SIGWINCH SIGUSR1
#endif

#define RLC_APPTIMER_ID	100		/* >=100: application timer */

#ifdef ___WIN386_INCLUDED__
HANDLE		rlc_hinstance(void);	/* hInstance of WinMain() */
HWND		rlc_hwnd(void);		/* HWND of console window */
#endif

typedef struct
{ int	 	 first;
  int	 	 last;
  int	 	 size;			/* size of the buffer */
  unsigned char *buffer;		/* character buffer */
} rlc_queue, *RlcQueue;

typedef void	(*RlcUpdateHook)(void);	/* Graphics update hook */
typedef void	(*RlcTimerHook)(int);	/* Timer fireing hook */
typedef int	(*RlcRenderHook)(int);	/* Render one format */
typedef void	(*RlcRenderAllHook)(void); /* Render all formats */

extern RlcUpdateHook	rlc_update_hook;
extern RlcTimerHook	rlc_timer_hook;
extern RlcRenderHook	rlc_render_hook;
extern RlcRenderAllHook rlc_render_all_hook;

void		rlc_title(char *title);
void		rlc_dispatch(RlcQueue q);
void		rlc_check_intr(void);
RlcQueue	rlc_make_queue(int size);
void		rlc_free_queue(RlcQueue q);
int		rlc_from_queue(RlcQueue q);
int		rlc_is_empty_queue(RlcQueue q);
void		rlc_empty_queue(RlcQueue q);
void		rlc_word_char(int chr, int isword);
int		getch(void);
int		getche(void);
int		getkey(void);
void		ScreenInit(void);
void		ScreenGetCursor(int *row, int *col);
void		ScreenSetCursor(int row, int col);
int		ScreenCols(void);
int		ScreenRows(void);

#endif /* _CONSOLE_H_INCLUDED */
