/*
 *  member.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include "ckfncplc.h"

struct ScaledType;
class Compound ;
class TextFragmentList ;
class ArraySize ;
class MofStream ;
class NodeParameterList ;
class MemberFunctionList ;
struct NodeParameter ;
class OutTokens ;

class MemberFunction {
	const char * Type ; // this an empty string for constructor
	const char * Name ;
	TextFragmentList * HelpLine ;
	TextFragmentList * FullDescription ;
	NodeParameterList * Parameters ;
	int wait_flag:1 ;
	const char * the_help_file ;
public:
	MemberFunction(const char * type, const char * name,
		TextFragmentList * MenuLine, TextFragmentList * Full,
		NodeParameterList * parameters,int wait =0, const char * hlp=0):
			the_help_file(hlp)
		{Type = type; Name = name;  HelpLine = MenuLine ;
		FullDescription = Full, Parameters = parameters;wait_flag=wait;}
	int is_constructor() const {return ! *Type;}
	void EmitMemberFunc(MofStream& FileOut) ;
	void EmitCtorFunc(MofStream& FileOut, int CtorFlag=1) ;
	void EmitCtor(MofStream& Out) ;
	void EmitAssignCtorParam(MofStream& Out) ;
	void EmitNodeParameterDescriptions(MofStream& Out) ;
	void EmitSetNodeVariables(MofStream& Out) ;
	void EmitSetNodeParameterValues(MofStream& Out) ;
	void EmitParamCheckFuncs(MofStream& Out, CheckFuncPlace Place) ;
	void EmitCtorParameterChecks(MofStream& Out) ;
	void EmitCtorParameterArray(MofStream& Out) ;
	void EmitSetVariables(MofStream& Out) ;
	void EmitInteractiveCompleteStructures(MofStream& Out,
		MemberFunctionList * Members, const char * Pre) ;
	void EmitSetCompleterStructures(MofStream& Out) ;
	void EmitSetStructures(MofStream& Out) ;
	int AnyParameters() ;
	void EmitGetParameters(MofStream& Out, int CtorFlag=1) ;
	void EmitDecInteractiveEntity(MofStream& Out,
		MemberFunctionList * Members) ;
	void EmitInteractiveInterface(MofStream& Out);
	void EmitInteractiveInterface(MofStream& Out,
		MemberFunctionList * Members);
	void EmitMemberParmCheckFuncs();
	void EmitInteractiveFunctions();
	void EmitMemberFunction(MofStream& Out) ;
	void DoEmitParameterListElement(MofStream& Out, Compound * name) ;
	void EmitMemberEntry(MofStream& Out, const char * NodeName) ;
	void CheckForArrayExt(MofStream& Out, MofStream& Hout) ;
	void IsNodeParameterName(const char * TestName) ;
	void WriteMemberItemExecute(MofStream& Out) ;
	void WriteMemberItemGenericDescribe(MofStream& Out) ;
	void EmitSelectMemberParamToDescribeMenu(MofStream& Out, const char *);
	void WriteMemberItemGenericExecute(MofStream& Out) ;
	const char * GetName() { return Name ; }
	int IsParameterName(const char * Name);
	int IsFunctionName(const char * Name);
	void EmitCheckLegalFunctions(MofStream& Out, const char * NodeName);
	void OutTeX(OutTokens& Out);
	void BriefOutTeX(OutTokens& Out) ;
	const char * help_file() const {return the_help_file;}
};

class MemberFunctionList: public SingleList {
public:
	ErrCode Insert(MemberFunction *nt) {return SingleList::Insert(nt);}
	ErrCode Append(MemberFunction *nt) {return SingleList::Append(nt);}
	MemberFunction * Get()   {return (MemberFunction *) SingleList::Get();}
	MemberFunction * Pop() {return (MemberFunction *) SingleList::Pop();}
	MemberFunction * GetNFromTop(int N) ;
	MemberFunction * GetNthEntry(int N) ;
	MemberFunctionList(){}
	MemberFunctionList(MemberFunction * obj) {Append(obj);}
	~MemberFunctionList();
	int Size(){return SingleList::Size();}
	void EmitMemberDeclarations(MofStream& Out);
	void EmitInteractiveInterface(MofStream& Out);
	void EmitMemberParmCheckFuncs();
	void EmitInteractiveFunctions();
	void EmitMemberFunctions(MofStream& Out);
	int IsParameterName(const char * Name);
	int IsFunctionName(const char * Name);
} ;

class MemberFunctionListIterator: public SingleListIterator {
public:
	MemberFunctionListIterator(MemberFunctionList& df):
		SingleListIterator((SingleList&) df){}
	MemberFunction * operator()()
		{return (MemberFunction *) Next();}
};

extern MemberFunctionList * TheMemberFunctions ;

const char * DoEmitParameterList(MofStream& Out, const char * BaseName, int Type,
	ParameterFunction * Func, CheckFuncPlace Place) ;
void DoEmitParameterListElement(MofStream& CppOut, Compound * name) ;
void DoEmitParamCheckFunc(MofStream& Out, int Type, const char * name,
	Compound * param, CheckFuncPlace Place) ;

char * MakeParameterFunctionName(const char * BaseName) ;
char * MakeDefaultArrayName ( const char * Node, const char * Param) ;


void EmitEntry(MofStream& Out, const char * Name, const char * NodeName,
const char * Pre) ;

int IsReference(const char * Type) ;

const char *OperConvert(const char * Name) ;

void CheckMembers(TextFragmentList * FragList) ;

