/*
 *  to_low_arg.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include "ObjProGen/cpyrght_exe.h"
#include <ctype.h>
#include <getopt.h>
#include <stream.h>
#include <stdlib.h>

void usage()
{
	cerr << "Usage:to_low_arg [-u] argument list\nArguments are converted to lower or\n";
	cerr << "upper (-u) case and written to stdout.\n" ;
	exit(1);
}

main(int argc, char **argv)
{
	int c ;
	int upper_flag = 0 ;
	while (( c = getopt(argc,argv,"u")) != EOF) switch(c) {
case 'u' :  upper_flag = 1 ;
		break ;
default:
		usage();
	}
	int first = 1 ;
	for (; optind < argc; optind++) {
		if (!first) cout << " " ;
		first = 0 ;
		for (const char * pt =argv[optind]; *pt; pt++)
			if (upper_flag) cout << (char) toupper(*pt);
			else cout << (char) tolower(*pt);
	}
}
