/*
 *  unpack.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */

#ifndef UNPACK_DOT_H
#define UNPACK_DOT_H
#define __DSP_PP_TARGET_CODE__

#include "ObjProDSP/portable.h"
#include "ObjProDSP/entenm.h"
#include "ObjProGen/debug.h"
#include "ObjProDSPcom/tarnod.h"
class UnpackWord: public TargetNode {
#line 44 "../unpack.usr"
 
	int32 Ratio ;
	uint32 Mask ;
	int16 sign_bit ;
	uint32 fill_ones ;
#ifdef INTERACTIVE
	virtual void input_linked(int in_channel)
		{propagate_arith_type(in_channel,-GetOutputWordSize()*
            GetOutputsPerInput());}
#endif
#line 31 "/usrb/dist/ftp/opd-0.1/src/include/ObjProDSPtar/ObjProUsr/unpack.h"
	int16  OutputWordSize_1;
	int16  OutputsPerInput_2;
	int16  SignedOutput_3;
public:
	UnpackWord (const char * Name, int16 OutputWordSize, int16 OutputsPerInput, 
		int16 SignedOutput,
		DfNodeInLink* in_links, DfNodeOutLink* out_links,
		int ** exec_seq,  NodeExecuteType exec_type,
		int delay);
	virtual ~UnpackWord();
	int16 GetOutputWordSize() const {return OutputWordSize_1;}
	int16 GetOutputsPerInput() const {return OutputsPerInput_2;}
	int16 GetSignedOutput() const {return SignedOutput_3;}
	virtual ErrCode DoNode(int32);
};

extern UnpackWord * UnpackWordDef;


#endif /* #ifdef UNPACK_DOT_H */
