/*
 *  sigbase.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */

#ifndef SIGBASE_DOT_H
#define SIGBASE_DOT_H

#include "ObjProDSP/portable.h"
#include "ObjProDSP/entenm.h"
#include "ObjProGen/debug.h"
#include "ObjProGui/strmstr.h"
#include "ObjProUsr/signode.h"

class Signal: public SignalStr {
	int16  procOut_1;
	int32  procEltSz_2;
	int32  procIncOut_3;
	int32  procBlockSize_4;
	TimingType  procTheTimingType_5;
	ArithType::ArithCapabilities  procArithTypeOut_6;
public:
	Signal (const char * Name, int16 procOut, int32 procEltSz, int32 procIncOut, 
		int32 procBlockSize, TimingType procTheTimingType, 
		ArithType::ArithCapabilities procArithTypeOut);
	virtual ~Signal();
	int16 GetprocOut() const {return procOut_1;}
	int32 GetprocEltSz() const {return procEltSz_2;}
	int32 GetprocIncOut() const {return procIncOut_3;}
	int32 GetprocBlockSize() const {return procBlockSize_4;}
	TimingType GetprocTheTimingType() const {return procTheTimingType_5;}
	ArithType::ArithCapabilities GetprocArithTypeOut() const {return procArithTypeOut_6;}
	virtual int CheckSafeDelete() ;
};


#endif /* #ifdef SIGBASE_DOT_H */
