/*
 *  genplot.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */

#ifndef GENPLOT_DOT_H
#define GENPLOT_DOT_H

#include "ObjProDSP/portable.h"
#include "ObjProDSP/entenm.h"
#include "ObjProGen/debug.h"
#include "ObjProUsr/gpltstr.h"

class GenericPlot: public GenericPlotStr {
	int16  procIn_1;
	int32  procEltSz_2;
	const char *  procCaption_3;
	double  procMin_4;
	double  procMax_5;
	double  procMinimumX_6;
	double  procMaximumX_7;
	int16  procNumberBlocks_8;
	int16  procScaleFlag_9;
	int32  procBlockSize_10;
	TimingType  procTheTimingType_11;
	double  procXYSamplesPerPlot_12;
	PlottingStreamType  procStreamType_13;
public:
	GenericPlot (const char * Name, int16 procIn, int32 procEltSz, 
		const char * procCaption, double procMin, double procMax, 
		double procMinimumX, double procMaximumX, 
		int16 procNumberBlocks, int16 procScaleFlag, 
		int32 procBlockSize, TimingType procTheTimingType, 
		double procXYSamplesPerPlot, 
		PlottingStreamType procStreamType);
	virtual ~GenericPlot();
	int16 GetprocIn() const {return procIn_1;}
	int32 GetprocEltSz() const {return procEltSz_2;}
	const char * GetprocCaption() const {return procCaption_3;}
	double GetprocMin() const {return procMin_4;}
	double GetprocMax() const {return procMax_5;}
	double GetprocMinimumX() const {return procMinimumX_6;}
	double GetprocMaximumX() const {return procMaximumX_7;}
	int16 GetprocNumberBlocks() const {return procNumberBlocks_8;}
	int16 GetprocScaleFlag() const {return procScaleFlag_9;}
	int32 GetprocBlockSize() const {return procBlockSize_10;}
	TimingType GetprocTheTimingType() const {return procTheTimingType_11;}
	double GetprocXYSamplesPerPlot() const {return procXYSamplesPerPlot_12;}
	PlottingStreamType GetprocStreamType() const {return procStreamType_13;}
	virtual int CheckSafeDelete() ;
};


#endif /* #ifdef GENPLOT_DOT_H */
