/*
 *  display.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */

#ifndef DISPLAY_DOT_H
#define DISPLAY_DOT_H

#include "ObjProDSP/portable.h"
#include "ObjProDSP/entenm.h"
#include "ObjProGen/debug.h"
#include "ObjProUsr/dsplstr.h"

class DisplayNode: public DisplayNodeStr {
	int16  proc_in_1;
	int32  procDeltaIn_2;
	int32  procEltSz_3;
	int32  procBlockSize_4;
	TimingType  procTheTimingType_5;
	ArithType::ArithCapabilities  procArithTypeIn_6;
public:
	DisplayNode (const char * Name, int16 proc_in, int32 procDeltaIn, 
		int32 procEltSz, int32 procBlockSize, 
		TimingType procTheTimingType, 
		ArithType::ArithCapabilities procArithTypeIn);
	virtual ~DisplayNode();
	int16 Getproc_in() const {return proc_in_1;}
	int32 GetprocDeltaIn() const {return procDeltaIn_2;}
	int32 GetprocEltSz() const {return procEltSz_3;}
	int32 GetprocBlockSize() const {return procBlockSize_4;}
	TimingType GetprocTheTimingType() const {return procTheTimingType_5;}
	ArithType::ArithCapabilities GetprocArithTypeIn() const {return procArithTypeIn_6;}
	virtual int CheckSafeDelete() ;
};


#endif /* #ifdef DISPLAY_DOT_H */
