/*
 *  blockplt.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */

#ifndef BLOCKPLT_DOT_H
#define BLOCKPLT_DOT_H

#include "ObjProDSP/portable.h"
#include "ObjProDSP/entenm.h"
#include "ObjProGen/debug.h"
#include "ObjProUsr/genplot.h"

class GenericBlockPlot: public GenericPlot {
	int32  procEltSz_1;
	const char *  procCaption_2;
	double  procMinY_3;
	double  procMaxY_4;
	double  procMinX_5;
	double  procMaxX_6;
	int16  procNumberBlocks_7;
	int16  procScaleFlag_8;
	int32  procBlockSize_9;
	TimingType  procTheTimingType_10;
public:
	GenericBlockPlot (const char * Name, int32 procEltSz, 
		const char * procCaption, double procMinY, double procMaxY, 
		double procMinX, double procMaxX, int16 procNumberBlocks, 
		int16 procScaleFlag, int32 procBlockSize, 
		TimingType procTheTimingType);
	virtual ~GenericBlockPlot();
	int32 GetprocEltSz() const {return procEltSz_1;}
	const char * GetprocCaption() const {return procCaption_2;}
	double GetprocMinY() const {return procMinY_3;}
	double GetprocMaxY() const {return procMaxY_4;}
	double GetprocMinX() const {return procMinX_5;}
	double GetprocMaxX() const {return procMaxX_6;}
	int16 GetprocNumberBlocks() const {return procNumberBlocks_7;}
	int16 GetprocScaleFlag() const {return procScaleFlag_8;}
	int32 GetprocBlockSize() const {return procBlockSize_9;}
	TimingType GetprocTheTimingType() const {return procTheTimingType_10;}
	virtual int CheckSafeDelete() ;
};


#endif /* #ifdef BLOCKPLT_DOT_H */
