/*
 *  prmpt_diag.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */

#ifndef PRMPT_DIAG_DOT_H
#define PRMPT_DIAG_DOT_H
#include <IV-look/dialogs.h>
#include <InterViews/action.h>

class RootMenuView;
class ivLayoutKit ;
class ivWidgetKit ;
class Action ;
class Style ;
class UserPrompt ;
class FieldEditor ;
class StringList ;
class ivWindow;

class InformationImpl : public Dialog {
	RootMenuView& root_view;

	inline const ivLayoutKit& layout() ;
    inline ivWidgetKit& kit() ;
	Action * accept ;

public:
	InformationImpl(RootMenuView& view,Style& style); 
	virtual ~InformationImpl(); 
	int run_dialog(StringList *, ivWindow *win=0);
	void cancel();
	void ok();
};

declareActionCallback(InformationImpl)


class PromptImpl : public Dialog {
	UserPrompt* prompt ;
	RootMenuView& root_view;
	FieldEditor* editor ;
	const char * abort_message ;
	enum {max_buf=128};
	char buf[max_buf+1];
	const char * response_default ;
	ivWindow * win ;

	inline const ivLayoutKit& layout() ;
    inline ivWidgetKit& kit() ;

public:
	PromptImpl(RootMenuView& view,Style& style); 
	virtual ~PromptImpl();
	int run_dialog(UserPrompt* prompt, StringList& strs,
		const char * abort_mess, ivWindow * win);
	void accept_editor(FieldEditor*);
	void cancel_editor(FieldEditor*);
	void use_file_chooser();
	void accept_string();
	void cancel();
	virtual void dismiss(boolean accept);
};

declareActionCallback(PromptImpl)

#include "xdrv.h"

inline const ivLayoutKit& PromptImpl::layout() {return root_view.layout();}
inline ivWidgetKit& PromptImpl::kit() {return root_view.kit();}

inline const ivLayoutKit& InformationImpl::layout()
		{return root_view.layout();}
inline ivWidgetKit& InformationImpl::kit() {return root_view.kit();}


#endif /* #ifdef PRMPT_DIAG_DOT_H */
