/*
 *  strgck.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
// Objects for checking lists or arrays of strings

#include <string.h>
#include <iostream.h>
#include "strgck.h"
#include "slist.h"

const char * DuplicateStringCheck::Ck() 
{
	for ( ; StringToCheck < LimitIndex -1 ; StringToCheck++) {
		const char * CurStr = GetString(StringToCheck) ;
		for ( ; CurrentCheck < LimitIndex ; CurrentCheck++)
			if (!strcmp(CurStr,GetString(CurrentCheck))) {
				// cout << "ToCheck = " << StringToCheck <<
				//	", Current = " << CurrentCheck << "\n" ;
				CurrentCheck++ ;
				return CurStr ;
			}
		CurrentCheck = StringToCheck+2;
	}
	return 0 ;
}

int ConstIsInList(const char * Name,class ConstStringList * List)
{
	ConstStringListIterator Next(*List) ;
	const char * AnEntry ;
	while (AnEntry = Next()) if (!strcmp(AnEntry,Name)) return 1;
	return 0 ;
}

int IsInList(const char * Name,class StringList * List)
{
	StringListIterator Next(*List) ;
	char * AnEntry ;
	while (AnEntry = Next()) if (!strcmp(AnEntry,Name)) return 1;
	return 0 ;
}

