/*
 *  helpg.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include <iostream.h>
#include "outtok.h"
#include "usercom.h"
// #include "winmgr.h"
// #include "textwin.h"
#include "cgidbg.h"
#include "hlpfil.h"

#include "help.h"
#include "shared.h"
#include "remcom.h"
#include "cgidbg.h"


// HelpControl HelpDo ;

void HelpControl::SetHelpLevel(HelpLevel NewLevel)
{
	if (NewLevel < HelpLevelNone || NewLevel > HelpLevelAll) 
		DbgError("HelpControl::HelpServer","bad level");
	Level = NewLevel ;
	// following should only be in version on gui side
	// LogOut << "Setting help level to " << NewLevel << "\n" ;
	PacketHeader ChangeHelp(PacketHelpControl,NewLevel);
	WriteSeg->WritePacket(ChangeHelp);
}

 
OutTokens * HelpControl::MakeOutToken(OutTokens::ReturnOption Option)
{
/*
 *	TheHelpWindow = TheWindowsManager->GetOutWindow(OutputHelp);
 *	if (!TheHelpWindow->IsVisible()) return 0 ;
 *	int Width = TheHelpWindow->GetCharacterWidth();
 *	int Height = TheHelpWindow->GetCharacterHeight()-1;
 *	Output->SetWindow(OutputHelp);
 *	if (Option == OutTokens::ReturnIgnore) return new OutTokens(
 *		OutputAppend,OutputHelp,0, "", " ", "", Width, Height,Option);
 *	return new OutTokens(OutputHelp,0, "", " ", "", Width, Height,Option);
 */
	DbgError("HelpControl::MakeOutToken","called");
	return 0 ;
}

void HelpControl::DescribeMenuAction(const char ** Description)
{
	// LogOut << "HelpControl::DescribeMenuAction\n" ;
	if (!Description) return ;
	if (!*Description) return ;
	OutTokens * Out = MakeOutToken(OutTokens::ReturnIgnore); 
	if (!Out) TheLog << "HelpControl::DescribeMenuAction::Null Out\n";
	if (!Out) return ;
	// TheHelpWindow->SetSuspend();
	// TheHelpWindow->NewPage();
	int FinalNewLine = 0;
	for (const char ** NextText = Description; *NextText; NextText++) {
		// LogMsg("Writing help line:",*NextText);
		if (!(FinalNewLine = Out->NextFillOut(*NextText))) break ;
	}
	if (FinalNewLine) Out->NewLine();
	else *Output+OutputHelp << "\n" ;
	// TheHelpWindow->ClearSuspend();
	// TheHelpWindow->Redraw();
	delete Out ;
}


void HelpControl::AutoDescribeMenuAction(const char ** Description)
{
/*
 *	LogForm("HelpControl::AutoDescribe, Level = %d (%d)",
 *		Level,HelpLevelAll) ;
 *	if (Description) if (*Description) LogMsg("FirstLine is:",*Description);
 *		else LogMsg("Null first line");
 *	else LogMsg("Null list");
 */
	if (Level < HelpLevelAll) return ;
	DescribeMenuAction(Description) ;
}


void HelpControl::DisplayHelpFile(const char * FileName)
{
	const char * FullName ;
	FILE * HelpFile = OpenHelpFile(FileName, &FullName );
	if (!HelpFile) {
		*Output+OutputHelp << "Can't find help file `" <<
			FullName << "'.\n" ;
		return ;
	}
	OutTokens * Out = MakeOutToken(OutTokens::ReturnIgnore); 
	if (!Out) TheLog << "HelpControl::DisplayHelpFile - Null Out\n";
	if (!Out) return ;
	const BufferSize = 1024;
	char Buffer[BufferSize];
	//if (ReturnOrQuit(OutputHelp)) {
	// TheHelpWindow->SetSuspend();
	// TheHelpWindow->NewPage();
	int FinalNewLine = 0;
	while (fgets(Buffer,BufferSize,HelpFile)) {
		int Lng = strlen(Buffer)-1 ;
		if (Buffer[Lng] == '\n') Buffer[Lng] = '\0' ;
		if(!(FinalNewLine = Out->NewLine())) break;
		if (!(FinalNewLine = Out->NextConcat(Buffer))) break ;
	}
	// if (FinalNewLine) Out->NewLine();
	// else TheWindowsManager->GetHelpWindow()->AppendText("\n");
	// LogOut << "HelpFileDisplay before ClearSuspend\n" ;
	// TheHelpWindow->ClearSuspend();
	// Out->NewLine() ;
	// TheHelpWindow->Redraw();
	// else *Output+OutputHelp << "\n" ;
	// LogOut << "HelpFileDisplay before delete Out\n" ;
	delete Out ;
	fclose (HelpFile) ;
	// LogOut << "Exit HelpFileDisplay\n" ;
}


void HelpControl::HelpServer(PacketHeader& Head, const char * Data)
{
	DbgError("HelpControl::HelpServer", "called on gui side");
} 

static int HelpVisible()
{
/*
 *	if (!TheWindowsManager) return 0 ;
 *	if (!TheWindowsManager->GetHelpWindow()->IsVisible()) return 0;
 */
	return 1 ;
}

int HelpControl::ConfirmVisible()
{
	if (!HelpVisible()) return 0;
	return Confirm();
}

int HelpControl::AllVisible()
{
	if (!HelpVisible()) return 0;
	return All();
}

