/*
 *  outwordc.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include "outword.h"
#include "binfile.h"

void OutputWord::ctor()
{
#ifdef INTERACTIVE
    set_delete_if_unlinked();
#endif
	file = new BinaryOutputFile(GetFileName(),this,GetFormatOut());
}

void OutputWord::dtor()
{
	delete file ;
}

ErrCode OutputWord::kernel(int32 k)
{
	if (node_state >= EndOfData) return node_state ;
	if (!file->is_open()) {
		file->open(1);
		if (!file->is_open()) return node_state = FatalError ;
		FileName_1 = file->name();
	}
	for (int32 i = 0 ; i < k ; i++)
		for (int32 b = 0 ; b < GetBlockSize(); b++)
			for (int e = 0; e < GetInEltSize(); e++) {
				if (integer_read_flag) file->write_integer(ReadBinary());
				else file->write(ReadWord());
				if (file->file_state() >= EndOfData)
					return node_state=file->file_state() ;
			}
	return OK ;
}


