/*
 *  callback.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */

#ifndef CALLBACK_DOT_H
#define CALLBACK_DOT_H

enum CallBackStatus {
	CallBackSuccess,
	CallBackSuccess2,
	CallBackError,
	CallBackFailure,
	CallBackAbort
};

enum RemoteParseFileState {
	ParseFileOk,
	ParseFileBadState,
	ParseFileBadRead,
	ParseFileOpened
};
	

enum CallBackCase {
	CallBackCaseAction,	// Do action 
	CallBackCaseReturn,	// Call back return from action
	CallBackCaseNoCallBack  // just do action - no call back
};

enum ReturnCallBackAction { 	// Cases for CallBack from action
	ParseReadFileReturn,	// Parser read file (read state is returned)
	InitReadFinished	// Parser has read initial state
} ;

enum DoCallBackAction {		// Cases for inital call
	ParseReadFileAction,	// Parser do file read
	ReadyForInitReadState,	// Parser ready for init with previous state
} ;

enum DoActionNoCallBack {
	DoActionSetSaveFileName
};

typedef void (*CallBack) (CallBackStatus);

typedef int (*ReturnCallBack) (int);

typedef int (*NameCallBack) (CallBackStatus, char *, int Lines);

#endif /* #ifdef CALLBACK_DOT_H */
