/*
 *  vocnode.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */

#ifndef VOCNODE_DOT_H
#define VOCNODE_DOT_H
#include "ObjProArith/hrdarth.h"

#include "ObjProDSP/portable.h"
#include "ObjProDSP/entenm.h"
#include "ObjProGen/debug.h"
#include "ObjProUsr/sigbase.h"

class VoiceNode: public Signal {
#line 47 "../vocnode.usr"
 
	class CreativeVoiceFile * TheInputFile ;
	int32 SampleRate ;
	const char * FileDescription ;
	int VoiceStart ;
	ErrCode node_state ;
	
#line 29 "/usrb/dist/ftp/opd-0.1/src/include/ObjProDSPint/ObjProUsr/vocnode.h"
	const char *  FileName_1;
	int16  NoHeader_2;
public:
	VoiceNode (const char * Name, const char * FileName, int16 NoHeader);
	virtual ~VoiceNode();
	const char * GetFileName() const {return FileName_1;}
	int16 GetNoHeader() const {return NoHeader_2;}
	virtual int CheckSafeDelete() ;
	virtual ErrCode DoNode(int32);
	void Describe(OutTokens& Out, ListEntity Option);
	virtual int CppList(OutTokens& Out, CppListCmds Cmd);
	virtual double TimeFirst(DfNodeInLink *,DfNodeOutLink *);
	void DisplayHeader ();
};

extern VoiceNode * VoiceNodeDef;


#endif /* #ifdef VOCNODE_DOT_H */
