#include <stdio.h>
#include "mkmk.h"

extern int lib;
extern int include;

makefile_create(char *ProgName, char *ObjName, char *CCFlags, char *CC, 
		char *ExtraLibs, char *LibDir, char *IncDir, char *INSTALLDIR,
		char *MODE)
{
  FILE *Makefile;
  rename("Makefile","Makefile.bak");
  Makefile=fopen("Makefile","w");
  
  fprintf(Makefile,"# Generated by makegen....\n\n");
  fprintf(Makefile,"TARGET = %s\n",ProgName);
  fprintf(Makefile,"OBJECTS = %s\n\n",ObjName);
  fprintf(Makefile,"CC = %s\n",CC);
  fprintf(Makefile,"CFLAGS = %s $(INCDIR)\n\n",CCFlags);
  fprintf(Makefile,"LIBS = %s\nLIBDIR = %s\nINCDIR = %s\n\nINSTALLDIR = %s\n\n"
	  ,ExtraLibs,LibDir,IncDir,INSTALLDIR);
  fprintf(Makefile,"all: $(TARGET)\n\n");
  fprintf(Makefile,"$(TARGET): $(OBJECTS)\n");
  fprintf(Makefile,"\t$(CC) $(CFLAGS) -o $(TARGET) $(OBJECTS) $(LIBDIR) $(LIBS)\n\n");
  fprintf(Makefile,"clean:\n\trm -f a.out core *~ \\#* *.bak $(TARGET) $(OBJECTS)\n\n"); 
  if(include)
    fprintf(Makefile,"install:\n\tinstall -s -m %s $(TARGET) $(INSTALLDIR)\n",MODE);
  fclose(Makefile);
  printf("Created Makefile...\n"); 
  fflush(stdout); 
}   



