/*
                                O P T I O N S . C
*/

#include "icmake.h"

int options (char **argv, int *argc)
{
    register int
        c;
#ifdef MSDOS        
    char
        *cp;
    FILE
        *new;
#endif        

    while ((c = getopt(argc, argv)) != -1)
    {
        switch (c)
        {
            case 'a':
                about();
            break;

            case 'b':
                flags |= f_blunt;
            break;

            case 'c':
                flags |= f_compiler;
            break;

            case 'i':
                flags |= f_icmake;          /* flag icmake taken literally  */
                if (!(source_name = getoptval(argc, argv)))
                    error("-i requires source-filename");
                return (getoptindex());     /* and return the index of args */
                                            /* to icm-exec */
#ifdef MSDOS                                           
            case 'o':
                if (!(cp = getoptval(argc, argv)))
                    error("-o requires output-filename");
                if (!(new = fopen(cp, "w")))
                    error("Can't open redirection file `%s'", cp);
                redirect_nr = fileno(new);
            break;
#endif
            case 'p':
                flags |= f_preprocessor;
            break;

            case 'q':
                flags |= f_quiet;           /* no banner */
            break;

            case '-':
                return (getoptindex());     /* return index of args to icm-exec
                                            */
        }
    }
    return (*argc);                         /* return index of args to icm-exec
                                            */
}

/*
int flags;

void main(int argc, char **argv)
{
    options(argv, &argc);

    printf("flags: %x\n"
            "arguments:\n"
            ,
            flags);
    while (argc--)
        puts(*argv++);
}
*/
