/*
                                E T O B . C

                 Convert expression to boolean expression
                 Links are not generated by etob(), but they
                 may exist.
*/

#include "iccomp.h"

void etob(e)
    ESTRUC_
        *e;
{
    switch (e->type & (e_int | e_str | e_list | e_bool))
    {
        case e_int:
            if (test_type(e, e_const))
            {
                e->evalue = e->evalue != 0;
                set_type(e, e_int | e_const);
                return;
            }
        break;

        case e_str:
            if (test_type(e, e_const))
            {
                e->evalue = 1;
                set_type(e, e_int | e_const);
                return;
            }
        break;

        case e_bool:
            return;
    }
    etoc(e);                                /* convert to code */

    gencode (e, op_jmp_true);
    gencode (e, op_jmp, j_falselist);
    set_type(e, e_code | e_bool);
}